/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanautomation.modules.automator;

import com.codetaylor.mc.artisanautomation.modules.automator.block.BlockAutomator;
import com.codetaylor.mc.artisanautomation.modules.automator.block.BlockAutomatorPowerRF;
import com.codetaylor.mc.artisanautomation.modules.automator.client.TESRAutomator;
import com.codetaylor.mc.artisanautomation.modules.automator.event.TooltipEventHandler;
import com.codetaylor.mc.artisanautomation.modules.automator.item.ItemUpgrade;
import com.codetaylor.mc.artisanautomation.modules.automator.network.CSPacketAutomatorClearInventoryGhostSlot;
import com.codetaylor.mc.artisanautomation.modules.automator.network.CSPacketAutomatorFluidDestroy;
import com.codetaylor.mc.artisanautomation.modules.automator.network.CSPacketAutomatorFluidLockModeChange;
import com.codetaylor.mc.artisanautomation.modules.automator.network.CSPacketAutomatorFluidModeChange;
import com.codetaylor.mc.artisanautomation.modules.automator.network.CSPacketAutomatorInventoryLockModeChange;
import com.codetaylor.mc.artisanautomation.modules.automator.network.CSPacketAutomatorOutputModeChange;
import com.codetaylor.mc.artisanautomation.modules.automator.network.CSPacketAutomatorTabStateChange;
import com.codetaylor.mc.artisanautomation.modules.automator.network.SCPacketAutomatorTabStateChange;
import com.codetaylor.mc.artisanautomation.modules.automator.tile.automator.TileAutomator;
import com.codetaylor.mc.artisanautomation.modules.automator.tile.supplier.TileAutomatorPowerSupplierRF;
import com.codetaylor.mc.artisanworktables.ModArtisanWorktables;
import com.codetaylor.mc.athenaeum.module.ModuleBase;
import com.codetaylor.mc.athenaeum.network.IPacketRegistry;
import com.codetaylor.mc.athenaeum.network.IPacketService;
import com.codetaylor.mc.athenaeum.network.tile.ITileDataService;
import com.codetaylor.mc.athenaeum.network.tile.SCPacketTileData;
import com.codetaylor.mc.athenaeum.packer.PackAPI;
import com.codetaylor.mc.athenaeum.registry.Registry;
import com.codetaylor.mc.athenaeum.util.ModelRegistrationHelper;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModuleAutomator
extends ModuleBase {
    public static final String MOD_NAME = "Artisan Automation";
    public static final String MOD_ID = "artisanautomation";
    public static final CreativeTabs CREATIVE_TAB = ModArtisanWorktables.CREATIVE_TAB;
    public static final Logger LOG = LogManager.getLogger((String)"artisanautomation");
    public static IPacketService PACKET_SERVICE;
    public static ITileDataService TILE_DATA_SERVICE;

    public ModuleAutomator() {
        super(0, MOD_ID);
        this.setRegistry(new Registry(MOD_ID, CREATIVE_TAB));
        this.enableAutoRegistry();
        PACKET_SERVICE = this.enableNetwork();
        TILE_DATA_SERVICE = this.enableNetworkTileDataService(PACKET_SERVICE);
        MinecraftForge.EVENT_BUS.register((Object)new TooltipEventHandler());
    }

    public void onNetworkRegister(IPacketRegistry registry) {
        registry.register(CSPacketAutomatorTabStateChange.class, CSPacketAutomatorTabStateChange.class, Side.SERVER);
        registry.register(SCPacketAutomatorTabStateChange.class, SCPacketAutomatorTabStateChange.class, Side.CLIENT);
        registry.register(CSPacketAutomatorOutputModeChange.class, CSPacketAutomatorOutputModeChange.class, Side.SERVER);
        registry.register(CSPacketAutomatorClearInventoryGhostSlot.class, CSPacketAutomatorClearInventoryGhostSlot.class, Side.SERVER);
        registry.register(CSPacketAutomatorInventoryLockModeChange.class, CSPacketAutomatorInventoryLockModeChange.class, Side.SERVER);
        registry.register(CSPacketAutomatorFluidLockModeChange.class, CSPacketAutomatorFluidLockModeChange.class, Side.SERVER);
        registry.register(CSPacketAutomatorFluidModeChange.class, CSPacketAutomatorFluidModeChange.class, Side.SERVER);
        registry.register(CSPacketAutomatorFluidDestroy.class, CSPacketAutomatorFluidDestroy.class, Side.SERVER);
        registry.register(SCPacketTileData.class, SCPacketTileData.class, Side.CLIENT);
    }

    public void onRegister(Registry registry) {
        registry.registerBlockWithItem((Block)new BlockAutomator(), "automator");
        registry.registerBlockWithItem((Block)new BlockAutomatorPowerRF(), "automator_power_rf");
        registry.registerItem((Item)new ItemUpgrade(), "upgrade_speed");
        registry.registerItem((Item)new ItemUpgrade(), "upgrade_fluid_capacity");
        registry.registerItem((Item)new ItemUpgrade(), "upgrade_energy_capacity");
        registry.registerItem((Item)new ItemUpgrade(), "upgrade_auto_export_items");
        registry.registerItem((Item)new ItemUpgrade(), "upgrade_auto_import_items");
        registry.registerItem((Item)new ItemUpgrade(), "upgrade_auto_import_export_items");
        registry.registerItem((Item)new ItemUpgrade(), "upgrade_auto_import_fluids");
        registry.registerItem((Item)new ItemUpgrade(), "upgrade_tool_repair");
        this.registerTileEntities(registry, TileAutomator.class, TileAutomatorPowerSupplierRF.class);
    }

    public void onClientPreInitializationEvent(FMLPreInitializationEvent event) {
        super.onClientPreInitializationEvent(event);
        String resourcePath = "textures/gui/atlas/packed.json";
        ResourceLocation resourceLocation = new ResourceLocation(MOD_ID, resourcePath);
        PackAPI.register((ResourceLocation)resourceLocation, () -> {
            try {
                Minecraft minecraft = Minecraft.func_71410_x();
                IResourceManager resourceManager = minecraft.func_110442_L();
                IResource resource = resourceManager.func_110536_a(resourceLocation);
                return Optional.of(resource.func_110527_b());
            }
            catch (Exception e) {
                LOG.error("Error loading packed atlas data: " + resourceLocation, (Throwable)e);
                return Optional.empty();
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public void onClientRegister(Registry registry) {
        registry.registerClientModelRegistrationStrategy(() -> {
            ModelRegistrationHelper.registerBlockItemModels((Block[])new Block[]{Blocks.AUTOMATOR, Blocks.AUTOMATOR_POWER_RF});
            ModelRegistrationHelper.registerItemModels((Item[])new Item[]{Items.UPGRADE_SPEED, Items.UPGRADE_FLUID_CAPACITY, Items.UPGRADE_ENERGY_CAPACITY, Items.UPGRADE_AUTO_EXPORT_ITEMS, Items.UPGRADE_AUTO_IMPORT_ITEMS, Items.UPGRADE_AUTO_IMPORT_EXPORT_ITEMS, Items.UPGRADE_AUTO_IMPORT_FLUIDS, Items.UPGRADE_TOOL_REPAIR});
            ClientRegistry.bindTileEntitySpecialRenderer(TileAutomator.class, (TileEntitySpecialRenderer)new TESRAutomator());
        });
    }

    public void registerTileEntities(Registry registry, Class<? extends TileEntity> ... tileEntityClasses) {
        for (Class<? extends TileEntity> tileEntityClass : tileEntityClasses) {
            this.registerTileEntity(registry, tileEntityClass);
        }
    }

    public void registerTileEntity(Registry registry, Class<? extends TileEntity> tileEntityClass) {
        registry.registerTileEntityRegistrationStrategy(() -> GameRegistry.registerTileEntity((Class)tileEntityClass, (ResourceLocation)new ResourceLocation(registry.getModId(), "tile." + tileEntityClass.getSimpleName())));
    }

    @GameRegistry.ObjectHolder(value="artisanautomation")
    public static class Items {
        @GameRegistry.ObjectHolder(value="upgrade_speed")
        public static final ItemUpgrade UPGRADE_SPEED = null;
        @GameRegistry.ObjectHolder(value="upgrade_fluid_capacity")
        public static final ItemUpgrade UPGRADE_FLUID_CAPACITY = null;
        @GameRegistry.ObjectHolder(value="upgrade_energy_capacity")
        public static final ItemUpgrade UPGRADE_ENERGY_CAPACITY = null;
        @GameRegistry.ObjectHolder(value="upgrade_auto_export_items")
        public static final ItemUpgrade UPGRADE_AUTO_EXPORT_ITEMS = null;
        @GameRegistry.ObjectHolder(value="upgrade_auto_import_items")
        public static final ItemUpgrade UPGRADE_AUTO_IMPORT_ITEMS = null;
        @GameRegistry.ObjectHolder(value="upgrade_auto_import_export_items")
        public static final ItemUpgrade UPGRADE_AUTO_IMPORT_EXPORT_ITEMS = null;
        @GameRegistry.ObjectHolder(value="upgrade_auto_import_fluids")
        public static final ItemUpgrade UPGRADE_AUTO_IMPORT_FLUIDS = null;
        @GameRegistry.ObjectHolder(value="upgrade_tool_repair")
        public static final ItemUpgrade UPGRADE_TOOL_REPAIR = null;
    }

    @GameRegistry.ObjectHolder(value="artisanautomation")
    public static class Blocks {
        @GameRegistry.ObjectHolder(value="automator")
        public static final BlockAutomator AUTOMATOR = null;
        @GameRegistry.ObjectHolder(value="automator_power_rf")
        public static final BlockAutomatorPowerRF AUTOMATOR_POWER_RF = null;
    }
}

