/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.tile;

import com.blakebr0.cucumber.energy.EnergyStorageCustom;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.util.VanillaPacketDispatcher;
import com.blakebr0.extendedcrafting.block.BlockPedestal;
import com.blakebr0.extendedcrafting.config.ModConfig;
import com.blakebr0.extendedcrafting.crafting.CombinationRecipe;
import com.blakebr0.extendedcrafting.crafting.CombinationRecipeManager;
import com.blakebr0.extendedcrafting.tile.TilePedestal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreDictionary;

public class TileCraftingCore
extends TileEntity
implements ITickable {
    private final ItemStackHandler inventory = new StackHandler(1);
    private final EnergyStorageCustom energy = new EnergyStorageCustom(ModConfig.confCraftingCoreRFCapacity);
    private int progress;
    private int oldEnergy;
    private int pedestalCount;

    private static List<CombinationRecipe> getValidRecipes(ItemStack stack) {
        ArrayList<CombinationRecipe> valid = new ArrayList<CombinationRecipe>();
        if (!stack.func_190926_b()) {
            for (CombinationRecipe recipe : CombinationRecipeManager.getInstance().getRecipes()) {
                ItemStack input = recipe.getInput();
                if (input.func_190926_b() || !input.func_77969_a(stack) || !StackHelper.compareTags((ItemStack)input, (ItemStack)stack)) continue;
                valid.add(recipe);
            }
        }
        return valid;
    }

    public void func_73660_a() {
        boolean mark = false;
        List<BlockPos> pedestalLocations = this.locatePedestals();
        if (!this.func_145831_w().field_72995_K) {
            CombinationRecipe recipe = this.getRecipe();
            if (recipe != null) {
                if (this.getEnergy().getEnergyStored() > 0) {
                    List<TilePedestal> pedestals = this.getPedestalsWithStuff(recipe, pedestalLocations);
                    boolean done = this.process(recipe);
                    if (done) {
                        for (TilePedestal pedestal : pedestals) {
                            IItemHandlerModifiable inventory = pedestal.getInventory();
                            inventory.setStackInSlot(0, StackHelper.decrease((ItemStack)inventory.getStackInSlot(0), (int)1, (boolean)true));
                            pedestal.func_70296_d();
                            ((WorldServer)this.func_145831_w()).func_180505_a(EnumParticleTypes.SMOKE_NORMAL, false, (double)pedestal.func_174877_v().func_177958_n() + 0.5, (double)pedestal.func_174877_v().func_177956_o() + 1.1, (double)pedestal.func_174877_v().func_177952_p() + 0.5, 20, 0.0, 0.0, 0.0, 0.1, new int[0]);
                        }
                        ((WorldServer)this.func_145831_w()).func_180505_a(EnumParticleTypes.END_ROD, false, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 1.1, (double)this.func_174877_v().func_177952_p() + 0.5, 50, 0.0, 0.0, 0.0, 0.1, new int[0]);
                        this.getInventory().setStackInSlot(0, recipe.getOutput().func_77946_l());
                        this.progress = 0;
                        mark = true;
                    } else {
                        ((WorldServer)this.func_145831_w()).func_180505_a(EnumParticleTypes.SPELL, false, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 1.1, (double)this.func_174877_v().func_177952_p() + 0.5, 2, 0.0, 0.0, 0.0, 0.1, new int[0]);
                    }
                }
            } else {
                this.progress = 0;
            }
        }
        if (this.oldEnergy != this.energy.getEnergyStored()) {
            this.oldEnergy = this.energy.getEnergyStored();
            if (!mark) {
                mark = true;
            }
        }
        if (mark) {
            this.func_70296_d();
        }
    }

    private List<BlockPos> locatePedestals() {
        ArrayList<BlockPos> pedestals = new ArrayList<BlockPos>();
        Iterable blocks = BlockPos.func_177980_a((BlockPos)this.func_174877_v().func_177982_a(-3, 0, -3), (BlockPos)this.func_174877_v().func_177982_a(3, 0, 3));
        for (BlockPos aoePos : blocks) {
            Block block = this.func_145831_w().func_180495_p(aoePos).func_177230_c();
            if (!(block instanceof BlockPedestal)) continue;
            pedestals.add(aoePos);
        }
        this.pedestalCount = pedestals.size();
        return pedestals;
    }

    private List<TilePedestal> getPedestalsWithStuff(CombinationRecipe recipe, List<BlockPos> locations) {
        ArrayList<Object> remaining = new ArrayList<Object>(recipe.getPedestalItems());
        ArrayList<TilePedestal> pedestals = new ArrayList<TilePedestal>();
        if (locations.isEmpty()) {
            return null;
        }
        block0: for (BlockPos pos : locations) {
            TileEntity tile = this.func_145831_w().func_175625_s(pos);
            if (!(tile instanceof TilePedestal)) continue;
            TilePedestal pedestal = (TilePedestal)tile;
            Iterator<Object> rem = remaining.iterator();
            while (rem.hasNext()) {
                boolean match = false;
                Object next = rem.next();
                ItemStack stack = pedestal.getInventory().getStackInSlot(0);
                if (next instanceof ItemStack) {
                    ItemStack nextStack = (ItemStack)next;
                    match = OreDictionary.itemMatches((ItemStack)nextStack, (ItemStack)stack, (boolean)false) && (!nextStack.func_77942_o() || StackHelper.compareTags((ItemStack)nextStack, (ItemStack)stack));
                } else if (next instanceof List) {
                    Iterator itr = ((List)next).iterator();
                    while (itr.hasNext() && !(match = OreDictionary.itemMatches((ItemStack)((ItemStack)itr.next()), (ItemStack)stack, (boolean)false))) {
                    }
                }
                if (!match) continue;
                pedestals.add(pedestal);
                remaining.remove(next);
                continue block0;
            }
        }
        if (pedestals.size() != recipe.getPedestalItems().size()) {
            return null;
        }
        if (!remaining.isEmpty()) {
            return null;
        }
        return pedestals;
    }

    private boolean process(CombinationRecipe recipe) {
        int extract = recipe.getPerTick();
        long difference = recipe.getCost() - (long)this.progress;
        if (difference < (long)recipe.getPerTick()) {
            extract = (int)difference;
        }
        int extracted = this.getEnergy().extractEnergy(extract, false);
        this.progress += extracted;
        return (long)this.progress >= recipe.getCost();
    }

    public CombinationRecipe getRecipe() {
        return this.getRecipe(this.locatePedestals());
    }

    public CombinationRecipe getRecipe(List<BlockPos> locations) {
        List<CombinationRecipe> recipes = TileCraftingCore.getValidRecipes(this.getInventory().getStackInSlot(0));
        if (!recipes.isEmpty()) {
            for (CombinationRecipe recipe : recipes) {
                List<TilePedestal> pedestals = this.getPedestalsWithStuff(recipe, locations);
                if (pedestals == null) continue;
                return recipe;
            }
        }
        return null;
    }

    public int getProgress() {
        return this.progress;
    }

    public IItemHandlerModifiable getInventory() {
        return this.inventory;
    }

    public EnergyStorageCustom getEnergy() {
        return this.energy;
    }

    public int getPedestalCount() {
        return this.pedestalCount;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.deserializeNBT(tag);
        this.progress = tag.func_74762_e("Progress");
        this.energy.setEnergy(tag.func_74762_e("Energy"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        tag.func_179237_a(this.inventory.serializeNBT());
        tag.func_74768_a("Progress", this.progress);
        tag.func_74768_a("Energy", this.energy.getEnergyStored());
        return tag;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), -1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager manager, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public final NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void func_70296_d() {
        super.func_70296_d();
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers((TileEntity)this);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        return this.getCapability(capability, side) != null;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.energy);
        }
        return (T)super.getCapability(capability, side);
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.func_145831_w().func_175625_s(this.func_174877_v()) == this && player.func_174818_b(this.func_174877_v().func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    class StackHandler
    extends ItemStackHandler {
        StackHandler(int size) {
            super(size);
        }

        protected int getStackLimit(int slot, ItemStack stack) {
            return 1;
        }

        public void onContentsChanged(int slot) {
            TileCraftingCore.this.func_70296_d();
        }
    }
}

