/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.item;

import com.blakebr0.cucumber.iface.IEnableable;
import com.blakebr0.cucumber.item.ItemBase;
import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.extendedcrafting.ExtendedCrafting;
import com.blakebr0.extendedcrafting.config.ModConfig;
import com.blakebr0.extendedcrafting.crafting.table.TableRecipeManager;
import com.blakebr0.extendedcrafting.item.ItemSingularity;
import com.blakebr0.extendedcrafting.item.ItemSingularityCustom;
import com.blakebr0.extendedcrafting.item.ModItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;

public class ItemSingularityUltimate
extends ItemBase
implements IEnableable {
    public static ArrayList<ItemStack> singularities = new ArrayList();
    public static ArrayList<Integer> blacklistDefaults = new ArrayList();
    public static ArrayList<Integer> blacklistCustoms = new ArrayList();

    public ItemSingularityUltimate() {
        super("ec.singularity_ultimate");
        this.func_77637_a(ExtendedCrafting.CREATIVE_TAB);
        this.func_77625_d(16);
    }

    public void configure(Configuration config) {
        ConfigCategory category = config.getCategory("singularity");
        String[] values = config.get(category.getName(), "ultimate_singularity_recipe_blacklist", new String[0]).getStringList();
        category.get("ultimate_singularity_recipe_blacklist").setComment("Blacklist Singularities from being in the Ultimate Singularity crafting recipe.\n- Syntax: singularityType;meta\n- 'singularityType' can be 'default' or 'custom'.\n- 'default' for the ones added by the mod by default, 'custom' being the ones defined in '_custom_singularities'.\n- Example: custom;12");
        for (String value : values) {
            int meta;
            String[] parts = value.split(";");
            if (parts.length != 2) {
                ExtendedCrafting.LOGGER.error("Invalid ultimate singularity blacklist syntax length: " + value);
                continue;
            }
            String type = parts[0];
            if (!type.equals("default") && !type.equals("custom")) {
                ExtendedCrafting.LOGGER.error("Invalid ultimate singularity blacklist type: " + value);
                continue;
            }
            try {
                meta = Integer.valueOf(parts[1]);
            }
            catch (NumberFormatException e) {
                ExtendedCrafting.LOGGER.error("Invalid ultimate singularity blacklist meta: " + value);
                continue;
            }
            if (type.equals("default")) {
                blacklistDefaults.add(meta);
                continue;
            }
            if (!type.equals("custom")) continue;
            blacklistCustoms.add(meta);
        }
    }

    public boolean isEnabled() {
        return ModConfig.confSingularityEnabled;
    }

    public static void addSingularityToRecipe(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemSingularity && blacklistDefaults.contains(stack.func_77960_j())) {
            return;
        }
        if (item instanceof ItemSingularityCustom && blacklistCustoms.contains(stack.func_77960_j())) {
            return;
        }
        if (singularities.size() < 82) {
            singularities.add(stack);
        } else {
            ExtendedCrafting.LOGGER.error("Unable to add " + stack.func_82833_r() + " to the Ultimate Singularity recipe as there is no more room.");
        }
    }

    public void initRecipe() {
        if (!ModConfig.confUltimateSingularityRecipe || !this.isEnabled()) {
            return;
        }
        TableRecipeManager.getInstance().addShapeless(4, new ItemStack((Item)ModItems.itemSingularityUltimate, 1, 0), singularities.toArray());
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add("\u00a7o" + Utils.localize((String)"tooltip.ec.singularity_ultimate"));
    }

    public class BlacklistEntry {
        public String type;
        public int meta;

        public BlacklistEntry(String type, int meta) {
            this.type = type;
            this.meta = meta;
        }
    }
}

