/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.crafttweaker;

import com.blakebr0.extendedcrafting.crafting.CompressorRecipe;
import com.blakebr0.extendedcrafting.crafting.CompressorRecipeManager;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.oredict.IOreDictEntry;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.extendedcrafting.CompressionCrafting")
public class CompressionCrafting {
    @ZenMethod
    public static void addRecipe(IItemStack output, IItemStack input, int inputCount, IItemStack catalyst, int powerCost) {
        CraftTweakerAPI.apply((IAction)new Add(new CompressorRecipe(CompressionCrafting.toStack(output), CompressionCrafting.toStack(input), inputCount, CompressionCrafting.toStack(catalyst), false, powerCost)));
    }

    @ZenMethod
    public static void addRecipe(IItemStack output, IItemStack input, int inputCount, IItemStack catalyst, int powerCost, int powerRate) {
        CraftTweakerAPI.apply((IAction)new Add(new CompressorRecipe(CompressionCrafting.toStack(output), CompressionCrafting.toStack(input), inputCount, CompressionCrafting.toStack(catalyst), false, powerCost, powerRate)));
    }

    @ZenMethod
    public static void remove(IItemStack target) {
        CraftTweakerAPI.apply((IAction)new Remove(CompressionCrafting.toStack(target)));
    }

    private static ItemStack toStack(IItemStack item) {
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        Object internal = item.getInternal();
        if (internal == null || !(internal instanceof ItemStack)) {
            CraftTweakerAPI.getLogger().logError("Not a valid item stack: " + item);
        }
        return (ItemStack)internal;
    }

    private static Object toObject(IIngredient ingredient) {
        if (ingredient == null) {
            return null;
        }
        if (ingredient instanceof IOreDictEntry) {
            return CompressionCrafting.toString((IOreDictEntry)ingredient);
        }
        if (ingredient instanceof IItemStack) {
            return CompressionCrafting.toStack((IItemStack)ingredient);
        }
        return null;
    }

    private static Object[] toObjects(IIngredient[] list) {
        if (list == null) {
            return null;
        }
        Object[] ingredients = new Object[list.length];
        for (int x = 0; x < list.length; ++x) {
            ingredients[x] = CompressionCrafting.toActualObject(list[x]);
        }
        return ingredients;
    }

    private static List toList(IIngredient[] list) {
        return Arrays.asList(CompressionCrafting.toObjects(list));
    }

    private static Object toActualObject(IIngredient ingredient) {
        if (ingredient == null) {
            return null;
        }
        if (ingredient instanceof IOreDictEntry) {
            return OreDictionary.getOres((String)CompressionCrafting.toString((IOreDictEntry)ingredient));
        }
        if (ingredient instanceof IItemStack) {
            return CompressionCrafting.toStack((IItemStack)ingredient);
        }
        return null;
    }

    private static String toString(IOreDictEntry entry) {
        return entry.getName();
    }

    private static class Remove
    implements IAction {
        ItemStack remove;

        public Remove(ItemStack remove) {
            this.remove = remove;
        }

        public void apply() {
            CompressorRecipeManager.getInstance().removeRecipes(this.remove);
        }

        public String describe() {
            return "Removing all Compression Crafting recipes for " + this.remove.func_82833_r();
        }
    }

    private static class Add
    implements IAction {
        CompressorRecipe recipe;

        public Add(CompressorRecipe add) {
            this.recipe = add;
        }

        public void apply() {
            CompressorRecipeManager.getInstance().getRecipes().add(this.recipe);
        }

        public String describe() {
            return "Adding a Compression Crafting recipe for " + this.recipe.getOutput().func_82833_r();
        }
    }
}

