/*
 * Decompiled with CFR 0.152.
 */
package magicbees.bees;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import forestry.api.apiculture.hives.HiveManager;
import forestry.api.apiculture.hives.IHiveGen;
import java.util.List;
import java.util.Random;
import magicbees.util.ConfigWorldGen;
import magicbees.world.HiveGenNether;
import magicbees.world.HiveGenOblivion;
import magicbees.world.HiveGenUnderground;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.BiomeDictionary;

public enum EnumHiveGen {
    CURIOUS(3.0f, HiveManager.genHelper.tree(), BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.HILLS),
    UNUSUAL(1.0f, HiveManager.genHelper.ground(new Block[]{Blocks.field_150346_d, Blocks.field_150349_c}), BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.RIVER),
    RESONANT(0.9f, HiveManager.genHelper.ground(new Block[]{Blocks.field_150354_m, Blocks.field_150322_A}), BiomeDictionary.Type.SANDY, BiomeDictionary.Type.MESA, BiomeDictionary.Type.HOT, BiomeDictionary.Type.MAGICAL),
    DEEP(3.8f, (IHiveGen)new HiveGenUnderground(10, 15, 5), new BiomeDictionary.Type[]{BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.MAGICAL}){

        @Override
        void postGen(World world, Random random, BlockPos blockPos) {
            if (!ConfigWorldGen.postGenRedstone) {
                return;
            }
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                EnumHiveGen.spawnVein(world, blockPos.func_177972_a(facing), 5, Blocks.field_150451_bX.func_176223_P(), Blocks.field_150348_b);
            }
        }
    }
    ,
    INFERNAL(50.0f, (IHiveGen)new HiveGenNether(0, 175, 6), new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER}){

        @Override
        void postGen(World world, Random random, BlockPos blockPos) {
            if (!ConfigWorldGen.postGenNetherQuartz) {
                return;
            }
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                EnumHiveGen.spawnVein(world, blockPos.func_177972_a(facing), 4, Blocks.field_150371_ca.func_176223_P(), Blocks.field_150424_aL);
            }
        }
    }
    ,
    INFERNAL_OVERWORLD(0.95f, (IHiveGen)new HiveGenUnderground(5, 13, 6), new BiomeDictionary.Type[]{BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.HOT}){

        @Override
        void postGen(World world, Random random, BlockPos blockPos) {
            if (!ConfigWorldGen.postGenGlowstone) {
                return;
            }
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                if (facing.func_176740_k() != EnumFacing.Axis.Y) {
                    EnumHiveGen.spawnVein(world, blockPos.func_177972_a(facing), world.field_73012_v.nextInt(4) + 1, Blocks.field_150426_aN.func_176223_P(), Blocks.field_150348_b);
                    continue;
                }
                BlockPos pos = blockPos.func_177972_a(facing);
                if (!HiveGenUnderground.isReplaceableOreGen(world.func_180495_p(pos), world, pos, Blocks.field_150348_b)) continue;
                world.func_180501_a(pos, Blocks.field_150426_aN.func_176223_P(), 2);
            }
        }
    }
    ,
    OBLIVION(20.0f, (IHiveGen)new HiveGenOblivion(), new BiomeDictionary.Type[]{BiomeDictionary.Type.END}){

        @Override
        void postGen(World world, Random random, BlockPos blockPos) {
            if (!ConfigWorldGen.postGenObsidianSpikes) {
                return;
            }
            int obsidianSpikeHeight = world.field_73012_v.nextInt(8) + 3;
            for (int i = 1; i < obsidianSpikeHeight && blockPos.func_177956_o() - i > 0; ++i) {
                world.func_180501_a(blockPos.func_177967_a(EnumFacing.DOWN, i), Blocks.field_150343_Z.func_176223_P(), 2);
            }
        }
    }
    ,
    OBLIVION_OVERWORLD(0.87f, (IHiveGen)new HiveGenUnderground(5, 5, 5), new BiomeDictionary.Type[]{BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.COLD}){

        @Override
        void postGen(World world, Random random, BlockPos blockPos) {
            if (!ConfigWorldGen.postGenEndstone) {
                return;
            }
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                EnumHiveGen.spawnVein(world, blockPos.func_177972_a(facing), world.field_73012_v.nextInt(facing.func_176740_k() == EnumFacing.Axis.Y ? 3 : 6) + 1, Blocks.field_150377_bs.func_176223_P(), Blocks.field_150348_b);
            }
        }
    };

    final float chance;
    final IHiveGen hiveGen;
    final List<BiomeDictionary.Type> biomes;

    private EnumHiveGen(float chance, IHiveGen hiveGen, BiomeDictionary.Type ... biomes) {
        this.chance = chance;
        this.hiveGen = hiveGen;
        this.biomes = Lists.newArrayList((Object[])((Object[])Preconditions.checkNotNull((Object)biomes)));
    }

    void postGen(World world, Random random, BlockPos blockPos) {
    }

    private static void spawnVein(World world, BlockPos pos, int maxSpawnCount, IBlockState replacement, Block toReplace) {
        maxSpawnCount = world.field_73012_v.nextInt(maxSpawnCount + 1);
        int spawnAttempts = 0;
        int spawnCount = 0;
        while (spawnCount < maxSpawnCount && (double)spawnAttempts < (double)maxSpawnCount * 1.2) {
            ++spawnAttempts;
            if (world.func_175667_e(pos) && !world.func_175623_d(pos) && HiveGenUnderground.isReplaceableOreGen(world.func_180495_p(pos), world, pos, toReplace)) {
                world.func_180501_a(pos, replacement, 2);
                ++spawnCount;
            }
            pos = pos.func_177972_a(EnumFacing.field_82609_l[world.field_73012_v.nextInt(6)]);
        }
    }
}

