/*
 * Decompiled with CFR 0.152.
 */
package magicbees.bees;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeModifier;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum EnumBeeModifiers implements IBeeModifier
{
    MAGIC("Magic", 240, 1.0f, 1.0f, 1.0f, 2.0f, 0.6f),
    RESILIENT("Resilient", 800, 1.0f, 1.0f, 1.0f, 2.0f, 0.5f),
    GENTLE("Gentle", 200, 1.0f, 0.7f, 1.5f, 1.4f, 0.01f),
    METABOLIC("Metabolic", 130, 1.0f, 1.8f, 1.0f, 1.2f, 1.0f),
    NECROTIC("Necrotic", 280, 1.0f, 1.0f, 0.3f, 0.75f, 1.2f),
    TEMPORAL("Temporal", 300, 1.0f, 1.0f, 2.5f, 1.0f, 0.8f),
    OBLIVION("Oblivion", 50, 1.0f, 1.0f, 1.0E-4f, 0.0f, 1.0f);

    private final String frameName;
    private final int maxDamage;
    private final float territoryMod;
    private final float mutationMod;
    private final float lifespanMod;
    private final float productionMod;
    private final float floweringMod;
    private final float geneticDecayMod;
    private final boolean isSealed;
    private final boolean isLit;
    private final boolean isSunlit;
    private final boolean isHellish;

    private EnumBeeModifiers(String name, int damage, float territory, float mutation, float lifespan, float production, float geneticDecay) {
        this(name, damage, territory, mutation, lifespan, production, 1.0f, geneticDecay, false, false, false, false);
    }

    private EnumBeeModifiers(String name, int damage, float territory, float mutation, float lifespan, float production, float flowering, float geneticDecay, boolean sealed, boolean lit, boolean sunlit, boolean hellish) {
        this.frameName = name;
        this.maxDamage = damage;
        this.territoryMod = territory;
        this.mutationMod = mutation;
        this.lifespanMod = lifespan;
        this.productionMod = production;
        this.floweringMod = flowering;
        this.geneticDecayMod = geneticDecay;
        this.isSealed = sealed;
        this.isLit = lit;
        this.isSunlit = sunlit;
        this.isHellish = hellish;
    }

    public String getName() {
        return this.frameName;
    }

    public int getMaxDamage() {
        return this.maxDamage;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        this.getTooltip(tooltip, "territory", this.territoryMod, 1);
        this.getTooltip(tooltip, "mutation", this.mutationMod, 1);
        this.getTooltip(tooltip, "lifespan", this.lifespanMod, this == OBLIVION ? 4 : 1);
        this.getTooltip(tooltip, "production", this.productionMod, 1);
        this.getTooltip(tooltip, "flowering", this.floweringMod, 1);
        this.getTooltip(tooltip, "genetic_decay", this.geneticDecayMod, this == GENTLE ? 2 : 1);
    }

    @SideOnly(value=Side.CLIENT)
    private void getTooltip(List<String> tooltip, String type, float value, int decimals) {
        if (value == 1.0f) {
            return;
        }
        String translated = I18n.func_74838_a((String)("magicbees.frame.modifier." + type));
        tooltip.add(String.format(translated + ": %." + decimals + "fx", Float.valueOf(value)));
    }

    public float getTerritoryModifier(@Nonnull IBeeGenome genome, float currentModifier) {
        return this.territoryMod;
    }

    public float getMutationModifier(@Nonnull IBeeGenome genome, @Nonnull IBeeGenome mate, float currentModifier) {
        return this.mutationMod;
    }

    public float getLifespanModifier(@Nonnull IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        return this.lifespanMod;
    }

    public float getProductionModifier(@Nonnull IBeeGenome genome, float currentModifier) {
        return this.productionMod;
    }

    public float getFloweringModifier(@Nonnull IBeeGenome genome, float currentModifier) {
        return this.floweringMod;
    }

    public float getGeneticDecay(@Nonnull IBeeGenome genome, float currentModifier) {
        return this.geneticDecayMod;
    }

    public boolean isSealed() {
        return this.isSealed;
    }

    public boolean isSelfLighted() {
        return this.isLit;
    }

    public boolean isSunlightSimulated() {
        return this.isSunlit;
    }

    public boolean isHellish() {
        return this.isHellish;
    }
}

