/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.util;

import com.therandomlabs.randompatches.RandomPatches;
import com.therandomlabs.randompatches.core.RPCoreContainer;
import com.therandomlabs.randompatches.repackage.com.therandomlabs.randomlib.TRLUtils;
import com.therandomlabs.randompatches.util.CertificateHelper;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.common.MetadataCollection;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.fml.common.versioning.InvalidVersionSpecificationException;
import net.minecraftforge.fml.common.versioning.VersionParser;
import net.minecraftforge.fml.common.versioning.VersionRange;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public final class RPUtils {
    private RPUtils() {
    }

    public static boolean detect(String className) {
        try {
            Class.forName(className, false, (ClassLoader)Launch.classLoader);
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
        return true;
    }

    public static File getModFile(Map<String, Object> data, Class<?> clazz, String packageName) {
        File modFile = (File)data.get("coremodLocation");
        if (modFile != null) {
            return modFile;
        }
        String uri = clazz.getResource("/" + StringUtils.replaceChars((String)clazz.getName(), (char)'.', (char)'/') + ".class").toString();
        if (uri.startsWith("file:/")) {
            uri = uri.substring(6, uri.indexOf(packageName) - 1);
        } else if (uri.startsWith("jar:file:/")) {
            uri = uri.substring(10, uri.indexOf(packageName) - 2);
        } else {
            return null;
        }
        try {
            return new File(URLDecoder.decode(uri, StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static ModMetadata loadMetadata(File source, String modid, String name, String version) {
        InputStream stream = null;
        JarFile jar = null;
        if (source != null) {
            try {
                if (source.isDirectory()) {
                    stream = new FileInputStream(new File(source, "mcmod.info"));
                } else {
                    jar = new JarFile(source);
                    stream = jar.getInputStream(jar.getJarEntry("mcmod.info"));
                }
            }
            catch (IOException ex) {
                RandomPatches.LOGGER.error("Failed to load mcmod.info: " + source, (Throwable)ex);
                IOUtils.closeQuietly((InputStream)stream);
                IOUtils.closeQuietly((Closeable)jar);
            }
        }
        HashMap<String, String> fallback = new HashMap<String, String>();
        fallback.put("name", name);
        fallback.put("version", version);
        ModMetadata metadata = MetadataCollection.from((InputStream)stream, (String)modid).getMetadataForId(modid, fallback);
        IOUtils.closeQuietly((InputStream)stream);
        IOUtils.closeQuietly((Closeable)jar);
        return metadata;
    }

    public static Class<?> getResourcePackClass(ModContainer container) {
        File source = container.getSource();
        if (source == null) {
            return null;
        }
        String className = source.isDirectory() ? "net.minecraftforge.fml.client.FMLFolderResourcePack" : "net.minecraftforge.fml.client.FMLFileResourcePack";
        try {
            return Class.forName(className, true, RPCoreContainer.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static VersionRange createVersionRange(String versionRange) {
        try {
            return VersionRange.createFromVersionSpec((String)versionRange);
        }
        catch (InvalidVersionSpecificationException ex) {
            RandomPatches.LOGGER.error("Failed to create version range", (Throwable)ex);
            return null;
        }
    }

    public static boolean hasFingerprint(Class<?> clazz, String fingerprintToFind) {
        List<String> fingerprints = CertificateHelper.getFingerprints(clazz.getProtectionDomain().getCodeSource().getCertificates());
        for (String fingerprint : fingerprints) {
            if (!fingerprintToFind.equals(fingerprint)) continue;
            return true;
        }
        return false;
    }

    public static void ensureMinimumRPVersion(String minimumVersion) {
        DefaultArtifactVersion version;
        VersionRange range = VersionParser.parseRange((String)("[" + minimumVersion + ",)"));
        if (!range.containsVersion((ArtifactVersion)(version = new DefaultArtifactVersion("randompatches", "1.12.2-1.22.1.1")))) {
            TRLUtils.crashReport("RandomPatches " + minimumVersion + " or higher is required", new IllegalStateException());
        }
    }
}

