/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.syncer.message;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.malisis.core.MalisisCore;
import net.malisis.core.network.IMalisisMessageHandler;
import net.malisis.core.registry.AutoLoad;
import net.malisis.core.util.syncer.ISyncHandler;
import net.malisis.core.util.syncer.ISyncableData;
import net.malisis.core.util.syncer.ObjectData;
import net.malisis.core.util.syncer.Syncer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

@AutoLoad(value=true)
public class SyncerMessage
implements IMalisisMessageHandler<Packet<?, ?>, IMessage> {
    public SyncerMessage() {
        MalisisCore.network.registerMessage(this, SyncerMessage.getPacketClass(), Side.CLIENT);
    }

    private static Class<Packet<?, ?>> getPacketClass() {
        return new Packet().getClass();
    }

    @Override
    public void process(Packet<?, ?> message, MessageContext ctx) {
        this.doProcess(message, ctx);
    }

    public <T, S extends ISyncableData> void doProcess(Packet<T, S> message, MessageContext ctx) {
        ISyncHandler handler = ((Packet)message).getHandler();
        Object receiver = handler.getReceiver(ctx, ((Packet)message).data);
        Syncer.instance.updateValues(receiver, handler, ((Packet)message).values);
    }

    public static class Packet<T, S extends ISyncableData>
    implements IMessage {
        private int handlerId;
        private S data;
        private int indexes;
        private Map<String, Object> values;

        public Packet() {
        }

        public Packet(int handlerId, S data, int fieldIndexes, Map<String, Object> fieldValues) {
            this.handlerId = handlerId;
            this.data = data;
            this.indexes = fieldIndexes;
            this.values = fieldValues;
        }

        private ISyncHandler<T, S> getHandler() {
            return Syncer.instance.getHandlerFromId(this.handlerId);
        }

        public void fromBytes(ByteBuf buf) {
            this.handlerId = buf.readInt();
            ISyncHandler<T, S> handler = this.getHandler();
            if (handler == null) {
                return;
            }
            this.data = handler.getSyncData(null);
            this.data.fromBytes(buf);
            this.indexes = buf.readInt();
            this.values = new HashMap<String, Object>();
            int index = 0;
            while (this.indexes > 0) {
                if ((this.indexes & 1) != 0) {
                    Object data = null;
                    ObjectData od = handler.getObjectData(index);
                    Class<?> clazz = od.getType();
                    if (ISyncableData.class.isAssignableFrom(clazz)) {
                        if (buf.readBoolean()) {
                            try {
                                data = clazz.newInstance();
                                ((ISyncableData)data).fromBytes(buf);
                            }
                            catch (IllegalAccessException | InstantiationException e) {
                                e.printStackTrace();
                            }
                        }
                    } else if (clazz.isEnum()) {
                        data = clazz.getEnumConstants()[buf.readInt()];
                    } else if (clazz == String.class) {
                        if (buf.readBoolean()) {
                            data = ByteBufUtils.readUTF8String((ByteBuf)buf);
                        }
                    } else if (clazz == Boolean.TYPE) {
                        data = buf.readBoolean();
                    } else if (clazz == Byte.TYPE) {
                        data = buf.readByte();
                    } else if (clazz == Integer.TYPE) {
                        data = buf.readInt();
                    } else if (clazz == Long.TYPE) {
                        data = buf.readLong();
                    } else if (clazz == Character.TYPE) {
                        data = Character.valueOf(buf.readChar());
                    } else if (clazz == Short.TYPE) {
                        data = buf.readShort();
                    } else if (clazz == Float.TYPE) {
                        data = Float.valueOf(buf.readFloat());
                    } else if (clazz == Double.TYPE) {
                        data = buf.readDouble();
                    }
                    this.values.put(od.getName(), data);
                }
                this.indexes >>= 1;
                ++index;
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.handlerId);
            this.data.toBytes(buf);
            buf.writeInt(this.indexes);
            for (Map.Entry<String, Object> entry : this.values.entrySet()) {
                Object obj = entry.getValue();
                if (obj == null) {
                    obj = false;
                    continue;
                }
                if (obj instanceof ISyncableData) {
                    buf.writeBoolean(true);
                    ((ISyncableData)obj).toBytes(buf);
                    continue;
                }
                if (obj instanceof Enum) {
                    buf.writeInt(((Enum)obj).ordinal());
                    continue;
                }
                if (obj instanceof String) {
                    buf.writeBoolean(true);
                    ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)((String)obj));
                    continue;
                }
                if (obj instanceof Boolean) {
                    buf.writeBoolean(((Boolean)obj).booleanValue());
                    continue;
                }
                if (obj instanceof Byte) {
                    buf.writeByte((int)((Byte)obj).byteValue());
                    continue;
                }
                if (obj instanceof Integer) {
                    buf.writeInt(((Integer)obj).intValue());
                    continue;
                }
                if (obj instanceof Long) {
                    buf.writeLong(((Long)obj).longValue());
                    continue;
                }
                if (obj instanceof Character) {
                    buf.writeChar((int)((Character)obj).charValue());
                    continue;
                }
                if (obj instanceof Short) {
                    buf.writeShort((int)((Short)obj).shortValue());
                    continue;
                }
                if (obj instanceof Float) {
                    buf.writeFloat(((Float)obj).floatValue());
                    continue;
                }
                if (!(obj instanceof Double)) continue;
                buf.writeDouble(((Double)obj).doubleValue());
            }
        }
    }
}

