/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.bbcode.render;

import java.util.LinkedList;
import java.util.List;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.util.bbcode.BBString;
import net.malisis.core.util.bbcode.node.BBNode;
import net.malisis.core.util.bbcode.render.BBRenderElement;
import net.malisis.core.util.bbcode.render.IBBCodeRenderer;

public class BBCodeRenderer {
    private BBString bbText;
    private LinkedList<BBRenderElement> renderElements = new LinkedList();

    public BBCodeRenderer(BBString bbText) {
        this.bbText = bbText;
    }

    public List<BBRenderElement> buildLines(List<String> lines) {
        this.renderElements.clear();
        this.buildRenderElements(this.bbText.getRoot(), new BBRenderElement(null));
        this.wrapRenderElements(lines);
        return this.renderElements;
    }

    private void buildRenderElements(BBNode node, BBRenderElement element) {
        for (BBNode n : node) {
            BBRenderElement nodeElement = new BBRenderElement(element);
            n.apply(nodeElement);
            if (n.isStandAlone()) {
                this.renderElements.add(nodeElement);
                continue;
            }
            this.buildRenderElements(n, nodeElement);
        }
    }

    private void wrapRenderElements(List<String> lines) {
        if (this.renderElements.size() == 0 || lines.size() == 0) {
            return;
        }
        int line = 0;
        int index = 0;
        for (int i = 0; i < this.renderElements.size(); ++i) {
            String currentLine = lines.get(line);
            BBRenderElement el = this.renderElements.get(i);
            el.line = line;
            BBRenderElement split = el.split(currentLine.length() - index);
            index += el.text.length();
            if (split != null) {
                this.renderElements.add(i + 1, split);
            }
            if (index < currentLine.length()) continue;
            ++line;
            index = 0;
        }
    }

    public void render(GuiRenderer renderer, int x, int y, int z, IBBCodeRenderer<?> bbsr) {
        int ox = x;
        int oy = y;
        int lineHeight = bbsr.getLineHeight();
        for (BBRenderElement el : this.renderElements) {
            if (el.line > bbsr.getStartLine() + bbsr.getVisibleLines()) {
                return;
            }
            if (el.line < bbsr.getStartLine()) continue;
            el.render(renderer, ox, oy, z);
            if (el.newLine) {
                ox = x;
                oy += lineHeight;
                continue;
            }
            ox += el.width();
        }
    }
}

