/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.bbcode.gui;

import com.google.common.eventbus.Subscribe;
import java.util.EnumSet;
import net.malisis.core.client.gui.Anchor;
import net.malisis.core.client.gui.ComponentPosition;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.client.gui.component.interaction.UIButton;
import net.malisis.core.client.gui.component.interaction.UITextField;
import net.malisis.core.client.gui.event.ComponentEvent;
import net.malisis.core.util.bbcode.BBString;
import net.malisis.core.util.bbcode.gui.BBTextField;
import net.malisis.core.util.bbcode.node.BBColorNode;
import net.malisis.core.util.bbcode.node.BBItemNode;
import net.malisis.core.util.bbcode.node.BBNode;
import net.malisis.core.util.bbcode.node.BBShadowNode;
import net.malisis.core.util.bbcode.node.BBStyleNode;
import net.minecraft.client.gui.GuiScreen;

public class BBCodeEditor
extends UIContainer<BBCodeEditor> {
    protected UIContainer<?> menu;
    protected UIButton btnBold;
    protected UIButton btnItalic;
    protected UIButton btnUnderline;
    protected UIButton btnStrikethrough;
    protected UIButton btnColor;
    protected UIButton btnBgColor;
    protected UIButton btnItem;
    protected UIButton btnWysiwyg;
    protected BBTextField bbTexfield;
    protected ComponentPosition menuPosition = ComponentPosition.TOP;
    protected int buttonAnchor = Anchor.LEFT | Anchor.MIDDLE;
    protected EnumSet<Tag> activeStyles = EnumSet.noneOf(Tag.class);
    protected boolean isWysiwyg = false;
    private int defaultColor = 0xFFFFFF;

    public BBCodeEditor(MalisisGui gui) {
        super(gui);
        this.bbTexfield = new BBTextField(gui, this);
        this.createMenu(gui);
        this.add(this.bbTexfield);
        this.add(this.menu);
        this.setMenuPosition(ComponentPosition.TOP);
        this.setWysiwyg(true);
    }

    public BBCodeEditor(MalisisGui gui, int width, int height) {
        this(gui);
        this.setSize(width, height);
    }

    public ComponentPosition getMenuPosition() {
        return this.menuPosition;
    }

    public String getRawText() {
        return this.bbTexfield.getBBText().getRawText();
    }

    public BBString getBBText() {
        return this.bbTexfield.getBBText();
    }

    public String getBBFormattedTex() {
        return this.bbTexfield.getBBText().getBBString();
    }

    public boolean isWysiwyg() {
        return this.bbTexfield.isWysiwyg();
    }

    public BBCodeEditor setWysiwyg(boolean w) {
        this.bbTexfield.setWysiwyg(w);
        return this;
    }

    public BBCodeEditor setMenuPosition(ComponentPosition position) {
        this.menuPosition = position;
        this.calculateTextfieldPosition();
        this.calculateMenuPosition();
        return this;
    }

    public BBCodeEditor setButtonAnchor(int anchor) {
        this.buttonAnchor = anchor;
        this.calculateTextfieldPosition();
        this.calculateMenuPosition();
        return this;
    }

    protected void createMenu(MalisisGui gui) {
        this.menu = new UIContainer(gui);
        this.menu.setParent(this);
        this.createButtons(gui);
        this.setMenuPosition(ComponentPosition.TOP);
    }

    protected void createButtons(MalisisGui gui) {
        int s = 10;
        this.btnBold = (UIButton)((UIButton)new UIButton(gui, "B").setAutoSize(false).setSize(s, s).setTooltip("Bold")).register(this);
        this.btnItalic = (UIButton)((UIButton)new UIButton(gui, "I").setAutoSize(false).setSize(s, s).setTooltip("Italic")).register(this);
        this.btnUnderline = (UIButton)((UIButton)new UIButton(gui, "U").setAutoSize(false).setSize(s, s).setTooltip("Underline")).register(this);
        this.btnStrikethrough = (UIButton)((UIButton)new UIButton(gui, "S").setAutoSize(false).setSize(s, s).setTooltip("Strikethrough")).register(this);
        this.btnColor = (UIButton)((UIButton)new UIButton(gui, "C").setAutoSize(false).setSize(s, s).setTooltip("Color")).register(this);
        this.btnBgColor = (UIButton)((UIButton)new UIButton(gui, "BC").setAutoSize(false).setSize(16, s).setTooltip("Background Color")).register(this);
        this.btnItem = (UIButton)((UIButton)new UIButton(gui, "Item").setAutoSize(false).setSize(22, s).setTooltip("Item")).register(this);
        this.btnWysiwyg = (UIButton)new UIButton(gui, "WYSIWYG").setAutoSize(false).setSize(45, s).register(this);
        this.menu.add(this.btnBold);
        this.menu.add(this.btnItalic);
        this.menu.add(this.btnUnderline);
        this.menu.add(this.btnStrikethrough);
        this.menu.add(this.btnColor);
        this.menu.add(this.btnBgColor);
        this.menu.add(this.btnItem);
        this.menu.add(this.btnWysiwyg);
    }

    protected void calculateTextfieldPosition() {
        int x = 0;
        int y = 0;
        int w = 0;
        int h = 0;
        int s = 14;
        switch (this.menuPosition) {
            case TOP: {
                y = s;
                h = -s;
                break;
            }
            case BOTTOM: {
                h = -s;
                break;
            }
            case LEFT: {
                x = s;
                w = -s;
                break;
            }
            case RIGHT: {
                w = -s;
            }
        }
        ((UITextField)this.bbTexfield.setPosition(x, y)).setSize(w, h);
    }

    protected void calculateMenuPosition() {
        int x = 0;
        int y = 0;
        int w = 0;
        int h = 0;
        int a = Anchor.NONE;
        int s = 12;
        switch (this.menuPosition) {
            case TOP: {
                h = s;
                break;
            }
            case BOTTOM: {
                h = s;
                a = Anchor.BOTTOM;
                break;
            }
            case LEFT: {
                w = s;
                break;
            }
            case RIGHT: {
                w = s;
                a = Anchor.RIGHT;
            }
        }
        ((UIContainer)this.menu.setPosition(x, y, a)).setSize(w, h);
        this.calculateButtonPositions();
    }

    protected void calculateButtonPositions() {
        int x = 0;
        int y = 1;
        int a = Anchor.vertical(this.buttonAnchor) | Anchor.CENTER;
        if (this.menuPosition.isHorizontal()) {
            x = 1;
            y = 0;
            a = Anchor.horizontal(this.buttonAnchor) | Anchor.MIDDLE;
        }
        if (Anchor.vertical(a) == Anchor.BOTTOM) {
            y *= -1;
        }
        if (Anchor.horizontal(a) == Anchor.RIGHT) {
            x *= -1;
        }
        this.btnBold.setPosition(0 * x, 0 * y, a);
        this.btnItalic.setPosition(11 * x, 11 * y, a);
        this.btnUnderline.setPosition(22 * x, 22 * y, a);
        this.btnStrikethrough.setPosition(33 * x, 33 * y, a);
        this.btnColor.setPosition(44 * x + 2 * x, 44 * y + 2 * y, a);
        this.btnBgColor.setPosition(55 * x + 2 * x, 55 * y + 2 * y, a);
        this.btnItem.setPosition(72 * x + 2 * x, 66 * y + 2 * y, a);
        this.btnWysiwyg.setPosition(100 * x + 2 * x, 66 * y + 2 * y, a);
    }

    public boolean isStyleActive(Tag s) {
        return this.activeStyles.contains((Object)s);
    }

    public String getFormattedText() {
        return null;
    }

    @Subscribe
    public void onClick(UIButton.ClickEvent event) {
        UIButton button = (UIButton)event.getComponent();
        if (button == this.btnBold) {
            this.bbTexfield.addTag(Tag.BOLD);
        } else if (button == this.btnItalic) {
            this.bbTexfield.addTag(Tag.ITALIC);
        } else if (button == this.btnUnderline) {
            this.bbTexfield.addTag(Tag.UNDERLINE);
        } else if (button == this.btnStrikethrough) {
            this.bbTexfield.addTag(Tag.STRIKETHOUGH);
        } else if (button == this.btnColor) {
            this.bbTexfield.addTag(Tag.COLOR);
        } else if (button == this.btnBgColor) {
            this.bbTexfield.addTag(Tag.BGCOLOR);
        } else if (button == this.btnItem) {
            this.bbTexfield.addTag(Tag.ITEM);
        } else if (button == this.btnWysiwyg) {
            this.setWysiwyg(!this.isWysiwyg());
            return;
        }
        this.bbTexfield.setFocused(true);
    }

    @Override
    public boolean onKeyTyped(char keyChar, int keyCode) {
        UIButton button;
        if (!GuiScreen.func_146271_m()) {
            return super.onKeyTyped(keyChar, keyCode);
        }
        boolean active = false;
        switch (keyCode) {
            case 48: {
                this.bbTexfield.addTag(Tag.BOLD);
                button = this.btnBold;
                break;
            }
            case 23: {
                this.bbTexfield.addTag(Tag.ITALIC);
                button = this.btnItalic;
                break;
            }
            case 22: {
                this.bbTexfield.addTag(Tag.UNDERLINE);
                button = this.btnUnderline;
                break;
            }
            case 31: {
                this.bbTexfield.addTag(Tag.STRIKETHOUGH);
                button = this.btnStrikethrough;
                break;
            }
            default: {
                return super.onKeyTyped(keyChar, keyCode);
            }
        }
        if (button != null) {
            button.setBgColor(active ? 0xBBFFCC : this.defaultColor);
        }
        return true;
    }

    public static class BBCodeChangeEvent
    extends ComponentEvent<BBCodeEditor> {
        public BBCodeChangeEvent(BBCodeEditor component) {
            super(component);
        }
    }

    static enum Tag {
        BOLD(new BBStyleNode("b")),
        ITALIC(new BBStyleNode("i")),
        UNDERLINE(new BBStyleNode("u")),
        STRIKETHOUGH(new BBStyleNode("s")),
        SHADOW(new BBShadowNode()),
        COLOR(new BBColorNode("color")),
        BGCOLOR(new BBColorNode("bgcolor")),
        ITEM(new BBItemNode(""));

        public BBNode node;

        private Tag(BBNode node) {
            this.node = node;
        }
    }
}

