/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.icon.provider;

import net.malisis.core.renderer.icon.Icon;
import net.malisis.core.renderer.icon.provider.IIconProvider;
import net.malisis.core.util.ItemUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public interface IBlockIconProvider
extends IIconProvider {
    public Icon getIcon(IBlockState var1, EnumFacing var2);

    @Override
    default public Icon getIcon() {
        return null;
    }

    default public Icon getIcon(IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing side) {
        return this.getIcon(state, side);
    }

    default public Icon getIcon(ItemStack itemStack, EnumFacing side) {
        return this.getIcon(ItemUtils.getStateFromItemStack(itemStack), side);
    }

    default public Icon getParticleIcon(IBlockState state) {
        return this.getIcon(state, null);
    }

    public static interface IStatesIconProvider
    extends IBlockIconProvider {
        @Override
        default public Icon getIcon(IBlockState state, EnumFacing side) {
            return this.getIcon(state);
        }

        public Icon getIcon(IBlockState var1);
    }

    public static interface ISidesIconProvider
    extends IBlockIconProvider {
        @Override
        default public Icon getIcon(IBlockState state, EnumFacing side) {
            return this.getIcon(side);
        }

        public Icon getIcon(EnumFacing var1);
    }
}

