/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.font;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.imageio.ImageIO;
import net.malisis.core.MalisisCore;
import net.malisis.core.renderer.font.CharData;
import net.malisis.core.renderer.font.FontGeneratorOptions;
import org.apache.commons.io.FileUtils;

public class FontGenerator {
    private Font font;
    private CharData[] charData;
    private FontGeneratorOptions options;

    public FontGenerator(Font font, CharData[] charData, FontGeneratorOptions options) {
        this.font = font;
        this.charData = charData;
        this.options = options;
    }

    public BufferedImage generate(int size, File textureFile, File uvFile) {
        BufferedImage img = this.generateTexture(size, textureFile);
        this.generateUVs(size, uvFile);
        return img;
    }

    private BufferedImage generateTexture(int size, File textureFile) {
        BufferedImage img = new BufferedImage(size, size, 2);
        Graphics2D g = this.initGraphics(img);
        int x = 10;
        int y = 10;
        for (int c = 35; c < 256; c = (int)((char)(c + 1))) {
            CharData cd = this.charData[c];
            if ((float)x + cd.getFullWidth(this.options) > (float)size) {
                x = (int)this.options.mx;
                y = (int)((float)y + (this.options.fontSize + this.options.my + this.options.py + 15.0f));
            }
            g.drawString("" + cd.getChar(), (float)x, (float)y + cd.getAscent());
            cd.setUVs(x, y, size, this.options);
            if (this.options.debug) {
                g.setColor(Color.RED);
                g.drawLine(x, (int)((float)y + cd.getAscent()), (int)((float)x + cd.getFullWidth(this.options)), (int)((float)y + cd.getAscent()));
                g.setColor(Color.MAGENTA);
                g.drawRect(x, y, (int)cd.getCharWidth(), (int)cd.getCharHeight());
                g.setColor(Color.BLACK);
            }
            x = (int)((float)x + (cd.getFullWidth(this.options) + 15.0f));
        }
        try {
            ImageIO.write((RenderedImage)img, "png", textureFile);
            MalisisCore.log.info(textureFile.getName() + " (" + size + "x" + size + ") written.");
        }
        catch (IOException e) {
            MalisisCore.log.error("Failed to create font texture file for {}.", (Object)this.font.getName(), (Object)e);
        }
        return img;
    }

    private void generateUVs(int size, File uvFile) {
        try {
            StringBuilder sb = new StringBuilder();
            for (CharData cd : this.charData) {
                if (cd.getChar() < '#' || cd.getChar() == ';') {
                    sb.append((int)cd.getChar());
                } else {
                    sb.append(cd.getChar());
                }
                sb.append(";");
                sb.append(cd.u());
                sb.append(";");
                sb.append(cd.v());
                sb.append(";");
                sb.append(cd.U());
                sb.append(";");
                sb.append(cd.V());
                sb.append(";\n");
            }
            FileUtils.write((File)uvFile, (CharSequence)sb, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            MalisisCore.log.error("Failed to create UV file for {}.", (Object)this.font.getName(), (Object)e);
        }
    }

    private Graphics2D initGraphics(BufferedImage img) {
        Graphics2D g = img.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        if (this.options.antialias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.setFont(this.font);
        if (this.options.debug) {
            int color = 0x666666;
            for (int i = 0; i < img.getWidth(); i += 25) {
                color = i % 500 == 0 ? 0x333333 : (i % 100 == 0 ? 0x777777 : 0xBBBBBB);
                g.setColor(new Color(color));
                g.drawLine(i, 0, i, img.getWidth());
                g.drawLine(0, i, img.getHeight(), i);
            }
        }
        g.setColor(this.options.debug ? Color.BLACK : Color.WHITE);
        return g;
    }

    static {
        File f = new File("fonts/");
        if (!f.exists()) {
            f.mkdir();
        }
    }
}

