/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.interaction.button.builder;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import net.malisis.core.client.gui.GuiTexture;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.client.gui.component.decoration.UIImage;
import net.malisis.core.client.gui.component.decoration.UITooltip;
import net.malisis.core.client.gui.component.interaction.UIButton;
import net.malisis.core.renderer.font.FontOptions;
import net.malisis.core.renderer.font.MalisisFont;
import net.malisis.core.renderer.icon.GuiIcon;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class UIButtonBuilder {
    private final MalisisGui gui;
    @Nullable
    private UIContainer container;
    @Nullable
    private FontOptions fontOptions;
    @Nullable
    private FontOptions hoverFontOptions;
    @Nullable
    private MalisisFont font;
    @Nullable
    private Object object;
    @Nullable
    private String text;
    @Nullable
    private UIImage image;
    @Nullable
    private UITooltip tooltip;
    @Nullable
    private Runnable onClickRunnable;
    private int width;
    private int height;
    private int x;
    private int y;
    private int z;
    private int anchor;
    private boolean enabled = true;
    private boolean visible = true;

    public UIButtonBuilder(MalisisGui gui) {
        this.gui = gui;
    }

    public UIButtonBuilder text(String text) {
        this.text = text;
        return this;
    }

    public UIButtonBuilder tooltip(String text) {
        return this.tooltip(new UITooltip(this.gui, text, 15));
    }

    public UIButtonBuilder tooltip(UITooltip tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public UIButtonBuilder image(UIImage image) {
        this.image = image;
        return this;
    }

    public UIButtonBuilder icon(GuiIcon icon) {
        return this.image(new UIImage(this.gui, null, icon));
    }

    public UIButtonBuilder texture(GuiTexture texture) {
        return this.image(new UIImage(this.gui, texture, null));
    }

    public UIButtonBuilder size(int width, int height) {
        this.width(width);
        this.height(height);
        return this;
    }

    public UIButtonBuilder size(int size) {
        this.size(size, size);
        return this;
    }

    public UIButtonBuilder width(int width) {
        this.width = width;
        return this;
    }

    public UIButtonBuilder height(int height) {
        this.height = height;
        return this;
    }

    public UIButtonBuilder fontOptions(FontOptions fontOptions) {
        this.fontOptions = fontOptions;
        return this;
    }

    public UIButtonBuilder hoverFontOptions(FontOptions hoverFontOptions) {
        this.hoverFontOptions = hoverFontOptions;
        return this;
    }

    public UIButtonBuilder font(MalisisFont font) {
        this.font = font;
        return this;
    }

    public UIButtonBuilder enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public UIButtonBuilder visible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public UIButtonBuilder position(int x, int y) {
        return this.position(x, y, 0);
    }

    public UIButtonBuilder position(int x, int y, int z) {
        this.x(x);
        this.y(y);
        this.z(z);
        return this;
    }

    public UIButtonBuilder x(int x) {
        this.x = x;
        return this;
    }

    public UIButtonBuilder y(int y) {
        this.y = y;
        return this;
    }

    public UIButtonBuilder z(int z) {
        this.z = z;
        return this;
    }

    public UIButtonBuilder anchor(int anchor) {
        this.anchor = anchor;
        return this;
    }

    public UIButtonBuilder listener(Object object) {
        this.object = object;
        return this;
    }

    public UIButtonBuilder container(UIContainer container) {
        this.container = container;
        return this;
    }

    public UIButtonBuilder onClick(Runnable onClickRunnable) {
        this.onClickRunnable = onClickRunnable;
        return this;
    }

    public UIButton build(String id) {
        Preconditions.checkNotNull((Object)id);
        UIButton button = new UIButton(this.gui);
        button.setPosition(this.x, this.y);
        button.setName(id);
        if (this.text != null) {
            button.setText(this.text);
        }
        if (this.image != null) {
            button.setImage(this.image);
        }
        if (this.tooltip != null) {
            button.setTooltip(this.tooltip);
        }
        if (this.width != 0) {
            button.setSize(this.width, button.getHeight());
        }
        if (this.height != 0) {
            button.setSize(button.getWidth(), this.height);
        }
        if (this.anchor != 0) {
            button.setAnchor(this.anchor);
        }
        if (this.object != null) {
            button.register(this.object);
        }
        if (this.fontOptions != null) {
            button.setFontOptions(this.fontOptions);
        }
        if (this.hoverFontOptions != null) {
            button.setHoveredFontOptions(this.hoverFontOptions);
        }
        if (this.font != null) {
            button.setFont(this.font);
        }
        if (this.container != null) {
            this.container.add(button);
        }
        if (this.onClickRunnable != null) {
            button.onClick(this.onClickRunnable);
        }
        button.setEnabled(this.enabled);
        button.setVisible(this.visible);
        button.setZIndex(this.z);
        return button;
    }
}

