/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.container.dialog;

import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.malisis.core.client.gui.Anchor;
import net.malisis.core.client.gui.BasicScreen;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.container.BasicForm;
import net.malisis.core.client.gui.component.container.UIBackgroundContainer;
import net.malisis.core.client.gui.component.container.dialog.MessageBoxButtons;
import net.malisis.core.client.gui.component.container.dialog.MessageBoxResult;
import net.malisis.core.client.gui.component.control.UIScrollBar;
import net.malisis.core.client.gui.component.control.UISlimScrollbar;
import net.malisis.core.client.gui.component.decoration.UILabel;
import net.malisis.core.client.gui.component.interaction.UIButton;
import net.malisis.core.client.gui.component.interaction.button.builder.UIButtonBuilder;
import net.malisis.core.util.FontColors;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BasicMessageBox
extends BasicForm {
    private static final int buttonPadding = 4;
    private static final int bottomPadding = 23;
    private final MessageBoxButtons messageBoxButtons;
    private final String message;
    @Nullable
    private final Consumer<MessageBoxResult> consumer;
    @Nullable
    private MessageBoxResult result;

    private BasicMessageBox(MalisisGui gui, String title, String message, MessageBoxButtons buttons, @Nullable Consumer<MessageBoxResult> consumer) {
        super(gui, 300, 115, title);
        this.messageBoxButtons = buttons;
        this.message = message;
        this.consumer = consumer;
        this.construct(gui);
        this.setClosable(true);
    }

    public static void showDialog(@Nullable GuiScreen gui, String title, String message, MessageBoxButtons buttons) {
        BasicMessageBox.showDialog(gui, title, message, buttons, null);
    }

    public static void showDialog(@Nullable GuiScreen gui, String title, String message, MessageBoxButtons buttons, @Nullable Consumer<MessageBoxResult> consumer) {
        MessageBoxDialogScreen screen = new MessageBoxDialogScreen(gui, title, message, buttons, consumer);
        screen.display();
    }

    private void construct(MalisisGui gui) {
        this.setBottomPadding(23);
        if (!this.message.isEmpty()) {
            UILabel messageLabel = new UILabel(gui, this.message, true);
            messageLabel.setSize(BasicScreen.getPaddedWidth(this), BasicScreen.getPaddedHeight(this) - 8);
            messageLabel.setFontOptions(FontColors.WHITE_FO);
            UISlimScrollbar scrollbar = new UISlimScrollbar(gui, messageLabel, UIScrollBar.Type.VERTICAL);
            scrollbar.setAutoHide(true);
            this.add(new UIComponent[]{messageLabel.setAnchor(Anchor.CENTER | Anchor.MIDDLE)});
        }
        UIBackgroundContainer buttonContainer = new UIBackgroundContainer(gui);
        ArrayList<UIButton> buttons = new ArrayList<UIButton>();
        switch (this.messageBoxButtons) {
            case OK: {
                buttons.add(this.buildButton(gui, "button.ok"));
                break;
            }
            case OK_CANCEL: {
                buttons.add(this.buildButton(gui, "button.ok"));
                buttons.add(this.buildButton(gui, "button.cancel"));
                break;
            }
            case YES_NO: {
                buttons.add(this.buildButton(gui, "button.yes"));
                buttons.add(this.buildButton(gui, "button.no"));
                break;
            }
            case YES_NO_CANCEL: {
                buttons.add(this.buildButton(gui, "button.yes"));
                buttons.add(this.buildButton(gui, "button.no"));
                buttons.add(this.buildButton(gui, "button.cancel"));
                break;
            }
            case CLOSE: {
                buttons.add(this.buildButton(gui, "button.close"));
            }
        }
        int width = 0;
        int x = 0;
        for (UIButton button : buttons) {
            buttonContainer.add(new UIComponent[]{button.setPosition(x, 0)});
            x += button.getWidth() + 4;
            width += button.getWidth();
        }
        buttonContainer.setSize(width += 4 * (buttons.size() - 1), 15);
        buttonContainer.setPosition(0, 19, Anchor.BOTTOM | Anchor.RIGHT);
        buttonContainer.setBackgroundAlpha(0);
        this.add(buttonContainer);
    }

    @Override
    @Subscribe
    public void onButtonClick(UIButton.ClickEvent event) {
        block8 : switch (((UIButton)event.getComponent()).getName().toLowerCase(Locale.ENGLISH)) {
            case "button.cancel": {
                this.result = MessageBoxResult.CANCEL;
                this.onClose();
                break;
            }
            case "button.close": {
                this.result = MessageBoxResult.CLOSE;
                this.onClose();
                break;
            }
            case "button.no": {
                this.result = MessageBoxResult.NO;
                this.onClose();
                break;
            }
            case "button.ok": {
                this.result = MessageBoxResult.OK;
                this.onClose();
                break;
            }
            case "button.yes": {
                this.result = MessageBoxResult.YES;
                this.onClose();
                break;
            }
            case "button.form.close": {
                switch (this.messageBoxButtons) {
                    case OK: {
                        this.result = MessageBoxResult.OK;
                        this.onClose();
                        break block8;
                    }
                    case OK_CANCEL: {
                        this.result = MessageBoxResult.CANCEL;
                        this.onClose();
                        break block8;
                    }
                    case CLOSE: {
                        this.result = MessageBoxResult.CLOSE;
                        this.onClose();
                        break block8;
                    }
                    case YES_NO: {
                        this.result = MessageBoxResult.NO;
                        this.onClose();
                        break block8;
                    }
                    case YES_NO_CANCEL: {
                        this.result = MessageBoxResult.CANCEL;
                        this.onClose();
                    }
                }
            }
        }
    }

    @Override
    public void onClose() {
        if (this.consumer != null) {
            try {
                this.consumer.accept(this.result);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.onClose();
    }

    private UIButton buildButton(MalisisGui gui, String name) {
        switch (name.toLowerCase()) {
            case "button.cancel": {
                return new UIButtonBuilder(gui).text(I18n.func_135052_a((String)I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), (Object[])new Object[0])).size(64, 15).listener(this).build("button.cancel");
            }
            case "button.close": {
                return new UIButtonBuilder(gui).text(I18n.func_135052_a((String)I18n.func_135052_a((String)"almura.menu_button.close", (Object[])new Object[0]), (Object[])new Object[0])).size(64, 15).listener(this).build("button.close");
            }
            case "button.no": {
                return new UIButtonBuilder(gui).text(I18n.func_135052_a((String)I18n.func_135052_a((String)"gui.no", (Object[])new Object[0]), (Object[])new Object[0])).size(64, 15).listener(this).build("button.no");
            }
            case "button.yes": {
                return new UIButtonBuilder(gui).text(I18n.func_135052_a((String)I18n.func_135052_a((String)"gui.yes", (Object[])new Object[0]), (Object[])new Object[0])).size(64, 15).listener(this).build("button.yes");
            }
        }
        return new UIButtonBuilder(gui).text(I18n.func_135052_a((String)I18n.func_135052_a((String)"almura.menu_button.ok", (Object[])new Object[0]), (Object[])new Object[0])).size(64, 15).listener(this).build("button.ok");
    }

    public static class MessageBoxDialogScreen
    extends BasicScreen {
        @Nullable
        private final GuiScreen gui;
        private final String title;
        private final String message;
        private final MessageBoxButtons buttons;
        @Nullable
        private final Consumer<MessageBoxResult> consumer;

        public MessageBoxDialogScreen(@Nullable GuiScreen gui, String title, String message, MessageBoxButtons buttons, @Nullable Consumer<MessageBoxResult> consumer) {
            super(gui, true);
            this.gui = gui;
            this.title = title;
            this.message = message;
            this.buttons = buttons;
            this.consumer = consumer;
        }

        @Override
        public void construct() {
            this.guiscreenBackground = false;
            this.registerKeyListener((keyChar, keyCode) -> keyCode == 1);
            this.addToScreen(((BasicForm)((BasicForm)new BasicMessageBox(this, this.title, this.message, this.buttons, this.consumer).setMovable(true).setPosition(0, 0, Anchor.MIDDLE | Anchor.CENTER)).setZIndex(50)).setBackgroundAlpha(255));
        }

        @Nullable
        public GuiScreen getParent() {
            return this.gui;
        }
    }
}

