/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.asm.mixin.core;

import net.malisis.core.util.Point;
import net.malisis.core.util.chunkcollision.ChunkCollision;
import net.malisis.core.util.chunkcollision.IChunkCollidable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

public class MixinChunkCollision {

    @Mixin(value={World.class})
    public static class MixinWorld {
        private Pair<Point, Point> infos = null;

        @Inject(method={"rayTraceBlocks(Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/util/math/Vec3d;ZZZ)Lnet/minecraft/util/math/RayTraceResult;"}, at={@At(value="HEAD")})
        private void setInfos(Vec3d src, Vec3d dest, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock, CallbackInfoReturnable<RayTraceResult> cir) {
            this.infos = src != null && dest != null ? Pair.of((Object)new Point(src), (Object)new Point(dest)) : null;
        }

        @Inject(method={"rayTraceBlocks(Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/util/math/Vec3d;ZZZ)Lnet/minecraft/util/math/RayTraceResult;"}, at={@At(value="RETURN")}, cancellable=true)
        private void onRayTraceBlocks(Vec3d src, Vec3d dest, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock, CallbackInfoReturnable<RayTraceResult> cir) {
            if (this.infos == null) {
                return;
            }
            RayTraceResult result = ChunkCollision.get().getRayTraceResult((World)this, this.infos, cir.getReturnValue(), stopOnLiquid, ignoreBlockWithoutBoundingBox, returnLastUncollidableBlock);
            cir.setReturnValue(result);
        }
    }

    @Mixin(value={NetHandlerPlayServer.class})
    public static class MixinNetHandlerPlayServer {
        private World world;
        private BlockPos pos;
        @Shadow
        private MinecraftServer field_147367_d;
        @Shadow
        public EntityPlayerMP field_147369_b;

        @Inject(method={"processPlayerDigging"}, at={@At(value="HEAD")})
        private void captureBlockPos(CPacketPlayerDigging packet, CallbackInfo ci) {
            this.pos = packet.func_179715_a();
            this.world = this.field_147367_d.func_71218_a(this.field_147369_b.field_71093_bK);
        }

        @ModifyVariable(method={"processPlayerDigging"}, ordinal=3, at=@At(value="STORE", ordinal=0), require=1)
        private double onPlayerDigging(double distance) {
            if (this.world.func_180495_p(this.pos).func_177230_c() instanceof IChunkCollidable) {
                return 0.0;
            }
            return distance;
        }
    }

    @Mixin(value={ItemBlock.class})
    public static class MixinItemBlock {
        @Inject(method={"onItemUse"}, at={@At(value="INVOKE", target="net/minecraft/item/ItemBlock.getMetadata(I)I")}, locals=LocalCapture.CAPTURE_FAILSOFT, cancellable=true)
        private void onOnItemUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ, CallbackInfoReturnable<EnumActionResult> cir, IBlockState iblockstate, Block block, ItemStack itemstack) {
            if (!ChunkCollision.get().canPlaceBlockAt(player, world, pos, hand, side)) {
                cir.setReturnValue(EnumActionResult.FAIL);
            }
        }
    }
}

