/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.block;

import com.buuz135.industrial.api.book.IPage;
import com.buuz135.industrial.book.BookCategory;
import com.buuz135.industrial.config.CustomConfiguration;
import com.buuz135.industrial.proxy.ItemRegistry;
import com.buuz135.industrial.tile.block.CustomOrientedBlock;
import com.buuz135.industrial.tile.world.LaserBaseTile;
import com.buuz135.industrial.utils.RecipeUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.ndrei.teslacorelib.items.MachineCaseItem;

public class LaserBaseBlock
extends CustomOrientedBlock<LaserBaseTile> {
    private int workNeeded;
    private int lenseChanceIncrease;

    public LaserBaseBlock() {
        super("laser_base", LaserBaseTile.class, Material.field_151576_e, 0, 0);
    }

    @Override
    public void getMachineConfig() {
        super.getMachineConfig();
        this.workNeeded = CustomConfiguration.config.getInt("workNeeded", "machines." + this.getRegistryName().func_110623_a().toString(), 100, 1, Integer.MAX_VALUE, "Amount of work needed to produce an ore");
        this.lenseChanceIncrease = CustomConfiguration.config.getInt("lenseChanceIncrease", "machines." + this.getRegistryName().func_110623_a().toString(), 5, 1, Integer.MAX_VALUE, "How much weight each lense increases to the ore");
    }

    public int getWorkNeeded() {
        return this.workNeeded;
    }

    public int getLenseChanceIncrease() {
        return this.lenseChanceIncrease;
    }

    @Override
    public void createRecipe() {
        RecipeUtils.addShapedRecipe(new ItemStack((Block)this), new Object[]{"pwp", "gwg", "dmd", Character.valueOf('p'), ItemRegistry.plastic, Character.valueOf('w'), Blocks.field_150426_aN, Character.valueOf('g'), "gearGold", Character.valueOf('d'), "gearDiamond", Character.valueOf('m'), MachineCaseItem.INSTANCE});
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity entity = worldIn.func_175625_s(pos);
        if (entity != null && entity instanceof LaserBaseTile) {
            ((LaserBaseTile)entity).onBlockBroken();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Override
    public BookCategory getCategory() {
        return BookCategory.RESOURCE_PRODUCTION;
    }

    @Override
    public List<IPage> getBookDescriptionPages() {
        List<IPage> pages = super.getBookDescriptionPages();
        return pages;
    }
}

