/*
 * Decompiled with CFR 0.152.
 */
package valoeghese.valoeghesesbe.world.trees.queenpalm;

import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import valoeghese.valoeghesesbe.init.ModBlocks;
import valoeghese.valoeghesesbe.world.trees.enumTypes.EnumDirection;

public class WorldGenQueenPalm
extends WorldGenAbstractTree {
    private final IBlockState TRUNK = ModBlocks.WOOD_LOOKUP.get("LOG_PALM").func_176223_P();
    private static final IBlockState LEAF = ModBlocks.LEAVES_PALM.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(true));
    private static final int minHeight = 7;

    public WorldGenQueenPalm() {
        this(false);
    }

    public WorldGenQueenPalm(boolean notify) {
        super(notify);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        boolean isSoil;
        int height = 7 + rand.nextInt(5);
        boolean flag = true;
        EnumDirection direction = rand.nextInt(3) == 0 ? EnumDirection.getRandomEnumType(rand) : EnumDirection.VERTICAL;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        for (int yPos = 0; yPos <= height + 2; ++yPos) {
            if (yPos >= 0 && yPos < world.func_72800_K()) {
                BlockPos pos21 = pos.func_177982_a(MathHelper.func_76128_c((double)((double)yPos * 0.5 * (double)direction.getXOffsetAsFloat())), yPos, MathHelper.func_76128_c((double)((double)yPos * 0.5 * (double)direction.getZOffsetAsFloat())));
                if (this.isReplaceable(world, pos21)) continue;
                flag = false;
                continue;
            }
            flag = false;
        }
        if (!flag) {
            return false;
        }
        BlockPos down = pos.func_177977_b();
        IBlockState state = world.func_180495_p(down);
        boolean bl = isSoil = state.func_177230_c().canSustainPlant(state, (IBlockAccess)world, down, EnumFacing.UP, (IPlantable)ModBlocks.SAPLING_PALM) || state.func_177230_c() == Blocks.field_150354_m;
        if (isSoil && y < world.func_72800_K() - height - 1) {
            state.func_177230_c().onPlantGrow(state, world, down, pos);
            int topY = y + 1 + height;
            int topX = x + MathHelper.func_76128_c((double)((double)(1 + height) * 0.5 * (double)direction.getXOffsetAsFloat()));
            int topZ = z + MathHelper.func_76128_c((double)((double)(1 + height) * 0.5 * (double)direction.getZOffsetAsFloat()));
            this.growPalmLeaves(world, LEAF, topX, topY, topZ, rand);
            for (int lHeight = 0; lHeight < height; ++lHeight) {
                BlockPos up = pos.func_177981_b(lHeight);
                IBlockState lState = world.func_180495_p(up);
                BlockPos pos21 = pos.func_177982_a(MathHelper.func_76128_c((double)((double)lHeight * 0.5 * (double)direction.getXOffsetAsFloat())), lHeight, MathHelper.func_76128_c((double)((double)lHeight * 0.5 * (double)direction.getZOffsetAsFloat())));
                this.func_175903_a(world, pos.func_177982_a(MathHelper.func_76128_c((double)((double)lHeight * 0.5 * (double)direction.getXOffsetAsFloat())), lHeight, MathHelper.func_76128_c((double)((double)lHeight * 0.5 * (double)direction.getZOffsetAsFloat()))), this.TRUNK);
            }
            return true;
        }
        return false;
    }

    private void growPalmLeaves(World worldIn, IBlockState leavesState, int x, int y, int z, Random rand) {
        for (int xAdd = -1; xAdd < 2; ++xAdd) {
            for (int zAdd = -1; zAdd < 2; ++zAdd) {
                if (worldIn.func_180495_p(new BlockPos(x + xAdd, y, z + zAdd)).func_177230_c() != Blocks.field_150350_a) continue;
                this.func_175903_a(worldIn, new BlockPos(x + xAdd, y, z + zAdd), leavesState);
            }
        }
        if (worldIn.func_180495_p(new BlockPos(x + 2, y, z)).func_177230_c() == Blocks.field_150350_a) {
            this.func_175903_a(worldIn, new BlockPos(x + 2, y, z), leavesState);
        }
        if (worldIn.func_180495_p(new BlockPos(x - 2, y, z)).func_177230_c() == Blocks.field_150350_a) {
            this.func_175903_a(worldIn, new BlockPos(x - 2, y, z), leavesState);
        }
        if (worldIn.func_180495_p(new BlockPos(x, y, z + 2)).func_177230_c() == Blocks.field_150350_a) {
            this.func_175903_a(worldIn, new BlockPos(x, y, z + 2), leavesState);
        }
        if (worldIn.func_180495_p(new BlockPos(x, y, z - 2)).func_177230_c() == Blocks.field_150350_a) {
            this.func_175903_a(worldIn, new BlockPos(x, y, z - 2), leavesState);
        }
        if (worldIn.func_180495_p(new BlockPos(x + 2, y - 1, z + 2)).func_177230_c() == Blocks.field_150350_a) {
            this.func_175903_a(worldIn, new BlockPos(x + 2, y - 1, z + 2), leavesState);
        }
        if (worldIn.func_180495_p(new BlockPos(x + 2, y - 1, z - 2)).func_177230_c() == Blocks.field_150350_a) {
            this.func_175903_a(worldIn, new BlockPos(x + 2, y - 1, z - 2), leavesState);
        }
        if (worldIn.func_180495_p(new BlockPos(x - 2, y - 1, z + 2)).func_177230_c() == Blocks.field_150350_a) {
            this.func_175903_a(worldIn, new BlockPos(x - 2, y - 1, z + 2), leavesState);
        }
        if (worldIn.func_180495_p(new BlockPos(x - 2, y - 1, z - 2)).func_177230_c() == Blocks.field_150350_a) {
            this.func_175903_a(worldIn, new BlockPos(x - 2, y - 1, z - 2), leavesState);
        }
        for (int yAdd = -2; yAdd < 0; ++yAdd) {
            if (worldIn.func_180495_p(new BlockPos(x + 3, y + yAdd, z)).func_177230_c() == Blocks.field_150350_a) {
                this.func_175903_a(worldIn, new BlockPos(x + 3, y + yAdd, z), leavesState);
            }
            if (worldIn.func_180495_p(new BlockPos(x - 3, y + yAdd, z)).func_177230_c() == Blocks.field_150350_a) {
                this.func_175903_a(worldIn, new BlockPos(x - 3, y + yAdd, z), leavesState);
            }
            if (worldIn.func_180495_p(new BlockPos(x, y + yAdd, z + 3)).func_177230_c() == Blocks.field_150350_a) {
                this.func_175903_a(worldIn, new BlockPos(x, y + yAdd, z + 3), leavesState);
            }
            if (worldIn.func_180495_p(new BlockPos(x, y + yAdd, z - 3)).func_177230_c() != Blocks.field_150350_a) continue;
            this.func_175903_a(worldIn, new BlockPos(x, y + yAdd, z - 3), leavesState);
        }
        if (worldIn.func_180495_p(new BlockPos(x, y - 1, z)).func_177230_c() == Blocks.field_150350_a) {
            this.func_175903_a(worldIn, new BlockPos(x, y - 1, z), this.TRUNK);
        }
    }
}

