/*
 * Decompiled with CFR 0.152.
 */
package valoeghese.valoeghesesbe.world.trees.evil;

import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import valoeghese.valoeghesesbe.init.ModBlocks;
import valoeghese.valoeghesesbe.world.trees.enumTypes.EnumDirection;

public class WorldGenEvilTreeSapling
extends WorldGenAbstractTree {
    private static final int minBasicHeight = 7;
    private static final IBlockState LEAVES = ModBlocks.LEAVES_EVIL.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(true));
    private static final IBlockState TRUNK = ModBlocks.LOG_EVIL.func_176223_P();

    public WorldGenEvilTreeSapling() {
        this(true);
    }

    public WorldGenEvilTreeSapling(boolean notify) {
        super(notify);
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos pos) {
        int theight = rand.nextInt(15) + 7 + 1;
        int trunk = 5 + rand.nextInt(2);
        int height = theight + trunk;
        boolean flag = true;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (y >= 1 && y + height + 2 <= worldIn.func_72800_K()) {
            for (int j = y; j < y + 2 + height; ++j) {
                int k = 1;
                if (j == y) {
                    k = 0;
                }
                if (j >= y + 2 + height - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos b1 = new BlockPos.MutableBlockPos();
                for (int l = x - k; l <= x + k && flag; ++l) {
                    for (int i1 = z - k; i1 <= z + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.func_72800_K()) {
                            if (this.isReplaceable(worldIn, (BlockPos)b1.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            IBlockState state = worldIn.func_180495_p(pos.func_177977_b());
            boolean canBlockSustainTree = state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
            if (canBlockSustainTree && y < worldIn.func_72800_K() - height - 1) {
                state.func_177230_c().onPlantGrow(state, worldIn, pos.func_177977_b(), pos);
                for (int lHeight = 0; lHeight <= height; ++lHeight) {
                    BlockPos up = pos.func_177981_b(lHeight);
                    IBlockState lState = worldIn.func_180495_p(up);
                    if (lHeight > trunk && lHeight < height - 4) {
                        if (rand.nextInt(3) > 0) {
                            this.generateBranch(worldIn, pos.func_177981_b(lHeight), rand);
                        }
                        if (rand.nextInt(3) == 0) {
                            this.generateBranch(worldIn, pos.func_177981_b(lHeight), rand);
                        }
                        if (rand.nextInt(4) == 0) {
                            this.generateBranch(worldIn, pos.func_177981_b(lHeight), rand);
                        }
                        if (rand.nextInt(5) == 0) {
                            this.generateBranch(worldIn, pos.func_177981_b(lHeight), rand);
                        }
                    }
                    if (lHeight < height - 1) {
                        this.func_175903_a(worldIn, pos.func_177981_b(lHeight), TRUNK);
                        this.func_175903_a(worldIn, pos.func_177982_a(1, lHeight, 0), TRUNK);
                        this.func_175903_a(worldIn, pos.func_177982_a(1, lHeight, 1), TRUNK);
                        this.func_175903_a(worldIn, pos.func_177982_a(0, lHeight, 1), TRUNK);
                        continue;
                    }
                    this.func_175903_a(worldIn, pos.func_177981_b(lHeight), LEAVES);
                    this.func_175903_a(worldIn, pos.func_177982_a(1, lHeight, 0), LEAVES);
                    this.func_175903_a(worldIn, pos.func_177982_a(1, lHeight, 1), LEAVES);
                    this.func_175903_a(worldIn, pos.func_177982_a(0, lHeight, 1), LEAVES);
                    this.generateLeafNode(worldIn, pos.func_177981_b(lHeight), rand);
                }
            }
            return true;
        }
        return true;
    }

    private void generateBranch(World worldIn, BlockPos origin, Random rand) {
        EnumDirection d1 = EnumDirection.getRandomEnumDirectional(rand);
        EnumDirection d2 = d1.getRandomOppAxisEnum(rand);
        EnumDirection d3 = EnumDirection.getRandomEnumVertical(rand);
        int d4 = 2 + rand.nextInt(2);
        int branchLength = 3 + rand.nextInt(5);
        for (int distance = 1; distance <= branchLength; ++distance) {
            int xOffset = d1.getXOffset() + Math.floorDiv(d2.getXOffset(), 2);
            int zOffset = d1.getZOffset() + Math.floorDiv(d2.getZOffset(), 2);
            int yOffset = Math.floorDiv(d3.getYOffset(), d4);
            BlockPos newPos = new BlockPos(0, 0, 0);
            newPos = origin.func_177982_a(xOffset * distance, yOffset * distance, zOffset * distance);
            if (worldIn.func_180495_p(newPos).func_177230_c() != Blocks.field_150350_a) continue;
            this.func_175903_a(worldIn, newPos, TRUNK.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)d1.getLogAxisOf()));
        }
        int xOffset = d1.getXOffset() + Math.floorDiv(d2.getXOffset(), 2);
        int zOffset = d1.getZOffset() + Math.floorDiv(d2.getZOffset(), 2);
        int yOffset = Math.floorDiv(d3.getYOffset(), d4);
        this.generateLeafNode(worldIn, origin.func_177982_a(xOffset * branchLength, yOffset * branchLength, zOffset * branchLength), rand);
    }

    private void generateLeafNode(World worldIn, BlockPos pos, Random rand) {
        if (worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150350_a) {
            this.func_175903_a(worldIn, pos.func_177984_a(), LEAVES);
        }
        if (worldIn.func_180495_p(pos.func_177982_a(-1, 1, 0)).func_177230_c() == Blocks.field_150350_a) {
            this.func_175903_a(worldIn, pos.func_177982_a(-1, 1, 0), LEAVES);
        }
        if (worldIn.func_180495_p(pos.func_177982_a(1, 1, 0)).func_177230_c() == Blocks.field_150350_a) {
            this.func_175903_a(worldIn, pos.func_177982_a(1, 1, 0), LEAVES);
        }
        if (worldIn.func_180495_p(pos.func_177982_a(0, 1, -1)).func_177230_c() == Blocks.field_150350_a) {
            this.func_175903_a(worldIn, pos.func_177982_a(0, 1, -1), LEAVES);
        }
        if (worldIn.func_180495_p(pos.func_177982_a(0, 1, 1)).func_177230_c() == Blocks.field_150350_a) {
            this.func_175903_a(worldIn, pos.func_177982_a(0, 1, 1), LEAVES);
        }
        for (int y = 0; y > -2; --y) {
            for (int x = -2; x < 3; ++x) {
                for (int z = -1; z < 2; ++z) {
                    if (x == 0 && z == 0) continue;
                    BlockPos newPos = new BlockPos(0, 0, 0);
                    newPos = pos.func_177982_a(x, y, z);
                    if (worldIn.func_180495_p(newPos).func_177230_c() != Blocks.field_150350_a) continue;
                    this.func_175903_a(worldIn, pos.func_177982_a(x, y, z), LEAVES);
                }
                if (Math.abs(x) >= 2) continue;
                if (worldIn.func_180495_p(pos.func_177982_a(x, y, -2)).func_177230_c() == Blocks.field_150350_a) {
                    this.func_175903_a(worldIn, pos.func_177982_a(x, y, -2), LEAVES);
                }
                if (worldIn.func_180495_p(pos.func_177982_a(x, y, 2)).func_177230_c() != Blocks.field_150350_a) continue;
                this.func_175903_a(worldIn, pos.func_177982_a(x, y, 2), LEAVES);
            }
        }
    }
}

