/*
 * Decompiled with CFR 0.152.
 */
package valoeghese.valoeghesesbe.world.trees;

import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import valoeghese.valoeghesesbe.init.ModBlocks;

public class WorldGenBluffPine
extends WorldGenAbstractTree {
    private static final IBlockState TRUNK = ModBlocks.LOG_PINE.func_176223_P();
    private static final IBlockState LEAF = ModBlocks.LEAVES_BLUFF.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(true));
    private static final int minHeight = 7;

    public WorldGenBluffPine() {
        this(false);
    }

    public WorldGenBluffPine(boolean notify) {
        super(notify);
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos pos) {
        int theight = 3 * (rand.nextInt(3) + 1) + 7 + 1;
        int trunk = rand.nextInt(2);
        int height = theight + trunk;
        boolean flag = true;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (y >= 1 && y + height + 2 <= worldIn.func_72800_K()) {
            for (int j = y; j < y + 2 + height; ++j) {
                int k = 1;
                if (j == y) {
                    k = 0;
                }
                if (j >= y + 2 + height - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos b1 = new BlockPos.MutableBlockPos();
                for (int l = x - k; l <= x + k && flag; ++l) {
                    for (int i1 = z - k; i1 <= z + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.func_72800_K()) {
                            if (this.isReplaceable(worldIn, (BlockPos)b1.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            IBlockState state = worldIn.func_180495_p(pos.func_177977_b());
            if ((state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g)) || state.func_177230_c() == Blocks.field_150341_Y) && y < worldIn.func_72800_K() - height - 1) {
                state.func_177230_c().onPlantGrow(state, worldIn, pos.func_177977_b(), pos);
                for (int lHeight = 0; lHeight <= height; ++lHeight) {
                    BlockPos up = pos.func_177981_b(lHeight);
                    IBlockState lState = worldIn.func_180495_p(up);
                    if (lHeight > trunk && lHeight < height - 1) {
                        switch (Integer.remainderUnsigned(lHeight - trunk - 1, 4)) {
                            case 0: {
                                if (height > 11) {
                                    if (lHeight < trunk + 4) {
                                        this.growBigLeaves1(worldIn, LEAF, x, lHeight + y, z, rand);
                                        break;
                                    }
                                    this.growBigLeaves2(worldIn, LEAF, x, lHeight + y, z, rand);
                                    break;
                                }
                                this.growBigLeaves2(worldIn, LEAF, x, lHeight + y, z, rand);
                                break;
                            }
                            case 2: {
                                if (rand.nextBoolean()) {
                                    this.growSmallLeaves2(worldIn, LEAF, x, lHeight + y, z, rand);
                                    break;
                                }
                                this.growSmallLeaves1(worldIn, LEAF, x, lHeight + y, z, rand);
                                break;
                            }
                            default: {
                                this.growSmallLeaves3(worldIn, LEAF, x, lHeight + y, z, rand);
                                break;
                            }
                        }
                    } else if (lHeight == height - 1) {
                        this.growSmallLeaves3(worldIn, LEAF, x, lHeight + y, z, rand);
                    }
                    if (lHeight == height) {
                        this.func_175903_a(worldIn, pos.func_177981_b(lHeight), LEAF);
                        continue;
                    }
                    this.func_175903_a(worldIn, pos.func_177981_b(lHeight), TRUNK);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void growSmallLeaves3(World worldIn, IBlockState leaves, int x, int y, int z, Random rand) {
        for (int xoff = -1; xoff < 2; ++xoff) {
            if (worldIn.func_180495_p(new BlockPos(x + xoff, y, z)).func_177230_c() != Blocks.field_150350_a || xoff == 0) continue;
            this.func_175903_a(worldIn, new BlockPos(x + xoff, y, z), leaves);
        }
        for (int zoff = -1; zoff < 2; ++zoff) {
            if (worldIn.func_180495_p(new BlockPos(x, y, z + zoff)).func_177230_c() != Blocks.field_150350_a || zoff == 0) continue;
            this.func_175903_a(worldIn, new BlockPos(x, y, z + zoff), leaves);
        }
    }

    private void growSmallLeaves2(World worldIn, IBlockState leaves, int x, int y, int z, Random rand) {
        this.growSmallLeaves3(worldIn, leaves, x, y, z, rand);
        if (worldIn.func_180495_p(new BlockPos(x + 1, y, z + 1)).func_177230_c() == Blocks.field_150350_a) {
            this.func_175903_a(worldIn, new BlockPos(x + 1, y, z + 1), leaves);
        }
        if (worldIn.func_180495_p(new BlockPos(x + 1, y, z - 1)).func_177230_c() == Blocks.field_150350_a) {
            this.func_175903_a(worldIn, new BlockPos(x + 1, y, z - 1), leaves);
        }
        if (worldIn.func_180495_p(new BlockPos(x - 1, y, z + 1)).func_177230_c() == Blocks.field_150350_a) {
            this.func_175903_a(worldIn, new BlockPos(x - 1, y, z + 1), leaves);
        }
        if (worldIn.func_180495_p(new BlockPos(x - 1, y, z - 1)).func_177230_c() == Blocks.field_150350_a) {
            this.func_175903_a(worldIn, new BlockPos(x - 1, y, z - 1), leaves);
        }
    }

    private void growSmallLeaves1(World worldIn, IBlockState leaves, int x, int y, int z, Random rand) {
        this.growSmallLeaves2(worldIn, leaves, x, y, z, rand);
        if (worldIn.func_180495_p(new BlockPos(x + 2, y, z)).func_177230_c() == Blocks.field_150350_a) {
            this.func_175903_a(worldIn, new BlockPos(x + 2, y, z), leaves);
        }
        if (worldIn.func_180495_p(new BlockPos(x - 2, y, z)).func_177230_c() == Blocks.field_150350_a) {
            this.func_175903_a(worldIn, new BlockPos(x - 2, y, z), leaves);
        }
        if (worldIn.func_180495_p(new BlockPos(x, y, z + 2)).func_177230_c() == Blocks.field_150350_a) {
            this.func_175903_a(worldIn, new BlockPos(x, y, z + 2), leaves);
        }
        if (worldIn.func_180495_p(new BlockPos(x, y, z - 2)).func_177230_c() == Blocks.field_150350_a) {
            this.func_175903_a(worldIn, new BlockPos(x, y, z - 2), leaves);
        }
    }

    private void growBigLeaves2(World worldIn, IBlockState leaves, int x, int y, int z, Random rand) {
        for (int fdsdffs = 1; fdsdffs <= 2; ++fdsdffs) {
            if (worldIn.func_180495_p(new BlockPos(x, y, z + fdsdffs)).func_177230_c() == Blocks.field_150350_a) {
                this.func_175903_a(worldIn, new BlockPos(x, y, z + fdsdffs), leaves);
            }
            if (worldIn.func_180495_p(new BlockPos(x, y, z - fdsdffs)).func_177230_c() == Blocks.field_150350_a) {
                this.func_175903_a(worldIn, new BlockPos(x, y, z - fdsdffs), leaves);
            }
            if (worldIn.func_180495_p(new BlockPos(x + fdsdffs, y, z)).func_177230_c() == Blocks.field_150350_a) {
                this.func_175903_a(worldIn, new BlockPos(x + fdsdffs, y, z), leaves);
            }
            if (worldIn.func_180495_p(new BlockPos(x - fdsdffs, y, z)).func_177230_c() != Blocks.field_150350_a) continue;
            this.func_175903_a(worldIn, new BlockPos(x - fdsdffs, y, z), leaves);
        }
        if (worldIn.func_180495_p(new BlockPos(x - 1, y, z + 2)).func_177230_c() == Blocks.field_150350_a) {
            this.func_175903_a(worldIn, new BlockPos(x - 1, y, z + 2), leaves);
        }
        if (worldIn.func_180495_p(new BlockPos(x + 1, y, z + 2)).func_177230_c() == Blocks.field_150350_a) {
            this.func_175903_a(worldIn, new BlockPos(x + 1, y, z + 2), leaves);
        }
        if (worldIn.func_180495_p(new BlockPos(x - 1, y, z - 2)).func_177230_c() == Blocks.field_150350_a) {
            this.func_175903_a(worldIn, new BlockPos(x - 1, y, z - 2), leaves);
        }
        if (worldIn.func_180495_p(new BlockPos(x + 1, y, z - 2)).func_177230_c() == Blocks.field_150350_a) {
            this.func_175903_a(worldIn, new BlockPos(x + 1, y, z - 2), leaves);
        }
        if (worldIn.func_180495_p(new BlockPos(x + 2, y, z - 1)).func_177230_c() == Blocks.field_150350_a) {
            this.func_175903_a(worldIn, new BlockPos(x + 2, y, z - 1), leaves);
        }
        if (worldIn.func_180495_p(new BlockPos(x + 2, y, z + 1)).func_177230_c() == Blocks.field_150350_a) {
            this.func_175903_a(worldIn, new BlockPos(x + 2, y, z + 1), leaves);
        }
        if (worldIn.func_180495_p(new BlockPos(x - 2, y, z - 1)).func_177230_c() == Blocks.field_150350_a) {
            this.func_175903_a(worldIn, new BlockPos(x - 2, y, z - 1), leaves);
        }
        if (worldIn.func_180495_p(new BlockPos(x - 2, y, z + 1)).func_177230_c() == Blocks.field_150350_a) {
            this.func_175903_a(worldIn, new BlockPos(x - 2, y, z + 1), leaves);
        }
    }

    private void growBigLeaves1(World worldIn, IBlockState leaves, int x, int y, int z, Random rand) {
        this.growBigLeaves2(worldIn, leaves, x, y, z, rand);
        for (int edna = -1; edna < 2; ++edna) {
            if (worldIn.func_180495_p(new BlockPos(x + edna, y, z + 3)).func_177230_c() == Blocks.field_150350_a) {
                this.func_175903_a(worldIn, new BlockPos(x + edna, y, z + 3), leaves);
            }
            if (worldIn.func_180495_p(new BlockPos(x + edna, y, z - 3)).func_177230_c() == Blocks.field_150350_a) {
                this.func_175903_a(worldIn, new BlockPos(x + edna, y, z - 3), leaves);
            }
            if (worldIn.func_180495_p(new BlockPos(x + 3, y, z + edna)).func_177230_c() == Blocks.field_150350_a) {
                this.func_175903_a(worldIn, new BlockPos(x + 3, y, z + edna), leaves);
            }
            if (worldIn.func_180495_p(new BlockPos(x - 3, y, z + edna)).func_177230_c() != Blocks.field_150350_a) continue;
            this.func_175903_a(worldIn, new BlockPos(x - 3, y, z + edna), leaves);
        }
        if (worldIn.func_180495_p(new BlockPos(x + 2, y, z + 2)).func_177230_c() == Blocks.field_150350_a) {
            this.func_175903_a(worldIn, new BlockPos(x + 2, y, z + 2), leaves);
        }
        if (worldIn.func_180495_p(new BlockPos(x - 2, y, z + 2)).func_177230_c() == Blocks.field_150350_a) {
            this.func_175903_a(worldIn, new BlockPos(x - 2, y, z + 2), leaves);
        }
        if (worldIn.func_180495_p(new BlockPos(x + 2, y, z - 2)).func_177230_c() == Blocks.field_150350_a) {
            this.func_175903_a(worldIn, new BlockPos(x + 2, y, z - 2), leaves);
        }
        if (worldIn.func_180495_p(new BlockPos(x - 2, y, z - 2)).func_177230_c() == Blocks.field_150350_a) {
            this.func_175903_a(worldIn, new BlockPos(x - 2, y, z - 2), leaves);
        }
    }
}

