/*
 * Decompiled with CFR 0.152.
 */
package valoeghese.valoeghesesbe.init;

import api.valoeghese.valoeghesesbe.BushGen;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeBeach;
import net.minecraft.world.biome.BiomeJungle;
import net.minecraft.world.biome.BiomeOcean;
import net.minecraft.world.biome.BiomePlains;
import net.minecraft.world.biome.BiomeRiver;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;
import valoeghese.valoeghesesbe.Main;
import valoeghese.valoeghesesbe.config.ConfigHandler;
import valoeghese.valoeghesesbe.functional.tree.BlockLeavesPeach;
import valoeghese.valoeghesesbe.init.ModBlocks;
import valoeghese.valoeghesesbe.util.MCWorld;
import valoeghese.valoeghesesbe.util.OpenSimplexNoise;
import valoeghese.valoeghesesbe.util.handlers.RegistryHandler;
import valoeghese.valoeghesesbe.world.biomes.BiomeOakHighVillage;
import valoeghese.valoeghesesbe.world.biomes.BiomeOakWHills;
import valoeghese.valoeghesesbe.world.biomes.BiomeOakWoodsBase;
import valoeghese.valoeghesesbe.world.biomes.BiomeWoodsBase;
import valoeghese.valoeghesesbe.world.biomes.alpha3.mini.BiomeAustralianOutback;
import valoeghese.valoeghesesbe.world.biomes.alpha4.BiomeReef;
import valoeghese.valoeghesesbe.world.gen.WorldGenFallenLog;
import valoeghese.valoeghesesbe.world.structures.StructureBase;
import valoeghese.valoeghesesbe.world.trees.WorldGenModdedShrub;
import valoeghese.valoeghesesbe.world.trees.WorldGenOceanPalm;
import valoeghese.valoeghesesbe.world.trees.fruittree.WorldGenPeach;
import valoeghese.valoeghesesbe.world.trees.fruittree.WorldGenPlum;
import valoeghese.valoeghesesbe.world.trees.newzealand.WorldGenPohutukawa1;
import valoeghese.valoeghesesbe.world.trees.newzealand.WorldGenPohutukawa2;
import valoeghese.valoeghesesbe.world.trees.queenpalm.WorldGenQueenPalm;

public class ModStructures
implements IWorldGenerator {
    private static FileReader staticStructureReader;
    private static FileReader staticStructure1Reader;
    private static FileReader staticStructure2Reader;
    private static char[] readerStructureChars;
    private static ConfigHandler structureWeightConfig;
    private static Map<String, String> structureWeightsTrue;
    private static char[] readerStructure1Chars;
    private static ConfigHandler structure1WeightConfig;
    private static Map<String, String> structure1WeightsTrue;
    private static char[] readerStructure2Chars;
    private static ConfigHandler structure2WeightConfig;
    private static Map<String, String> structure2WeightsTrue;
    public static final StructureBase ULURU;
    public static final StructureBase SHIP1;
    public static final StructureBase SHIP2;
    public static final StructureBase SHIP3;
    public static final StructureBase SHIP4;
    public static final StructureBase SHIP5;
    private final WorldGenerator DUNE_SHRUB = new WorldGenModdedShrub(ModBlocks.SHRUB_DUNE.func_176223_P(), true);
    private final WorldGenerator DUNE_SHRUB_2 = new WorldGenModdedShrub(ModBlocks.SHRUB_DUNE_LARGE.func_176223_P(), true);
    private final WorldGenerator POHUTUKAWA = new WorldGenPohutukawa1();
    private final WorldGenerator POHUTUKAWA_LARGE = new WorldGenPohutukawa2(false);
    private final WorldGenerator OCEAN_PALM = new WorldGenOceanPalm(false, 4);
    private final WorldGenerator OAK_CARPET = new WorldGenModdedShrub(ModBlocks.LEAFCARPET_OAK.func_176223_P());
    private final WorldGenerator SPRUCE_CARPET = new WorldGenModdedShrub(ModBlocks.LEAFCARPET_SPRUCE.func_176223_P());
    private final WorldGenerator QUEEN_PALM = new WorldGenQueenPalm(false);
    private final WorldGenerator PEACH = new WorldGenPeach(BlockLeavesPeach.EnumGenotype.PP, false);
    private final WorldGenerator PLUM = new WorldGenPlum(false);

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        boolean grove;
        double chunknoise = new OpenSimplexNoise(world.func_72905_C()).eval((double)chunkX * 0.2, (double)chunkZ * 0.2);
        boolean bl = grove = new OpenSimplexNoise(world.func_72905_C()).eval((double)chunkX * 0.37, (double)chunkZ * 0.37) > 0.59;
        if (Boolean.parseBoolean(structureWeightsTrue.get("MasterGenStructure"))) {
            switch (world.field_73011_w.getDimension()) {
                case 0: {
                    this.generateStructure(ULURU, world, random, chunkX, chunkZ, Integer.parseInt(structure1WeightsTrue.get("SandstoneUluruRarity")), EnumBiomeType.AUSTRALIAN, BiomeAustralianOutback.class);
                    this.generateStructure(SHIP1, world, random, chunkX, chunkZ, Integer.parseInt(structure2WeightsTrue.get("ShipsArchipelagoRarity")), EnumBiomeType.WATER, BiomeReef.class);
                    this.generateStructure(SHIP2, world, random, chunkX, chunkZ, Integer.parseInt(structure2WeightsTrue.get("ShipsArchipelagoRarity")), EnumBiomeType.WATER, BiomeReef.class);
                    this.generateStructure(SHIP3, world, random, chunkX, chunkZ, Integer.parseInt(structure2WeightsTrue.get("ShipsArchipelagoRarity")), EnumBiomeType.WATER, BiomeReef.class);
                    this.generateStructure(SHIP4, world, random, chunkX, chunkZ, Integer.parseInt(structure2WeightsTrue.get("ShipsArchipelagoRarity")), EnumBiomeType.WATER, BiomeReef.class);
                    this.generateStructure(SHIP5, world, random, chunkX, chunkZ, Integer.parseInt(structure2WeightsTrue.get("ShipsArchipelagoRarity")), EnumBiomeType.WATER, BiomeReef.class);
                    this.generateStructure(SHIP1, world, random, chunkX, chunkZ, Integer.parseInt(structure2WeightsTrue.get("ShipsOceanRarity")), EnumBiomeType.WATER, BiomeOcean.class);
                    this.generateStructure(SHIP2, world, random, chunkX, chunkZ, Integer.parseInt(structure2WeightsTrue.get("ShipsOceanRarity")), EnumBiomeType.WATER, BiomeOcean.class);
                    this.generateStructure(SHIP3, world, random, chunkX, chunkZ, Integer.parseInt(structure2WeightsTrue.get("ShipsOceanRarity")), EnumBiomeType.WATER, BiomeOcean.class);
                    this.generateStructure(SHIP4, world, random, chunkX, chunkZ, Integer.parseInt(structure2WeightsTrue.get("ShipsOceanRarity")), EnumBiomeType.WATER, BiomeOcean.class);
                    this.generateStructure(SHIP5, world, random, chunkX, chunkZ, Integer.parseInt(structure2WeightsTrue.get("ShipsOceanRarity")), EnumBiomeType.WATER, BiomeOcean.class);
                    this.generateStructure(SHIP1, world, random, chunkX, chunkZ, Integer.parseInt(structure2WeightsTrue.get("ShipsRiverRarity")), EnumBiomeType.WATER, BiomeRiver.class);
                    this.generateStructure(SHIP2, world, random, chunkX, chunkZ, Integer.parseInt(structure2WeightsTrue.get("ShipsRiverRarity")), EnumBiomeType.WATER, BiomeRiver.class);
                    this.generateStructure(SHIP3, world, random, chunkX, chunkZ, Integer.parseInt(structure2WeightsTrue.get("ShipsRiverRarity")), EnumBiomeType.WATER, BiomeRiver.class);
                    this.generateStructure(SHIP4, world, random, chunkX, chunkZ, Integer.parseInt(structure2WeightsTrue.get("ShipsRiverRarity")), EnumBiomeType.WATER, BiomeRiver.class);
                    this.generateStructure(SHIP5, world, random, chunkX, chunkZ, Integer.parseInt(structure2WeightsTrue.get("ShipsRiverRarity")), EnumBiomeType.WATER, BiomeRiver.class);
                    break;
                }
            }
        }
        WorldGenFallenLog FALLEN_LOG_0 = new WorldGenFallenLog(Blocks.field_150364_r.func_176223_P(), 3 + random.nextInt(3), false);
        WorldGenFallenLog FALLEN_LOG_1 = new WorldGenFallenLog(Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.SPRUCE), 4 + random.nextInt(3), false);
        switch (world.field_73011_w.getDimension()) {
            case 0: {
                double carpetval;
                this.generateTree(this.DUNE_SHRUB, world, random, chunkX, chunkZ, 7.0, -1, 0, BiomeBeach.class);
                this.generateTree(this.DUNE_SHRUB_2, world, random, chunkX, chunkZ, 4.0, -1, 0, BiomeBeach.class);
                this.generateTree((WorldGenerator)FALLEN_LOG_0, world, random, chunkX, chunkZ, 0.4, -1, 0, BiomeOakWoodsBase.class, BiomeOakWHills.class, BiomeOakHighVillage.class);
                this.generateTree((WorldGenerator)FALLEN_LOG_1, world, random, chunkX, chunkZ, 0.25, -1, 0, BiomeWoodsBase.class);
                this.generateTree(this.QUEEN_PALM, world, random, chunkX, chunkZ, 0.2, 50, 85, BiomeJungle.class);
                if (grove) {
                    this.generateTree(this.PEACH, world, random, chunkX, chunkZ, 3.5, -1, 0, BiomePlains.class);
                }
                if (grove) {
                    this.generateTree(this.PLUM, world, random, chunkX, chunkZ, 3.5, 63, 85, BiomeOakWoodsBase.class, BiomeOakWHills.class);
                }
                if ((carpetval = 1.3 + 2.0 * chunknoise) < 0.4) {
                    carpetval = 0.4;
                }
                this.generateTree(this.OAK_CARPET, world, random, chunkX, chunkZ, carpetval, -1, 0, BiomeOakWoodsBase.class, BiomeOakWHills.class, BiomeOakHighVillage.class);
                this.generateTree(this.SPRUCE_CARPET, world, random, chunkX, chunkZ, carpetval, -1, 0, BiomeWoodsBase.class);
                for (BushGen bg : Main.bushes) {
                    bg.load();
                    this.generateTree((WorldGenerator)new WorldGenModdedShrub(bg.gen), world, random, chunkX, chunkZ, 0.9, -1, 0, bg.getAllowedBiomeClasses());
                }
                if (chunkX * 16 > 1200 && chunkZ * 16 > 1500) {
                    this.generateTree(this.POHUTUKAWA_LARGE, world, random, chunkX, chunkZ, 0.2, -1, 0, BiomeBeach.class);
                    this.generateTree(this.POHUTUKAWA, world, random, chunkX, chunkZ, 0.4, -1, 0, BiomeBeach.class);
                }
                if (chunkX * 16 <= 1200 || chunkZ * 16 >= 1520 || chunkZ * 16 <= -1520) break;
                this.generateTree(this.OCEAN_PALM, world, random, chunkX, chunkZ, 0.3, -1, 0, BiomeBeach.class);
                break;
            }
        }
    }

    private void generateTree(WorldGenerator generator, World world, Random rand, int chunkX, int chunkZ, double chancesToSpawn, int minHeight, int maxHeight, Class<?> ... classes) {
        double flooredchances = MathHelper.func_76128_c((double)chancesToSpawn);
        if (chancesToSpawn != flooredchances) {
            chancesToSpawn = rand.nextDouble() < chancesToSpawn - flooredchances ? flooredchances + 1.0 : flooredchances;
        }
        ArrayList classesList = new ArrayList(Arrays.asList(classes));
        int dHeight = maxHeight - minHeight;
        int i = 0;
        while ((double)i < chancesToSpawn) {
            Class<?> biome;
            BlockPos pos = new BlockPos(chunkX * 16 + 10 + rand.nextInt(15), minHeight + rand.nextInt(dHeight), chunkZ * 16 + 10 + rand.nextInt(15));
            if (minHeight < 0) {
                pos = world.func_175645_m(pos);
            }
            if (classesList.contains(biome = world.field_73011_w.getBiomeForCoords(pos).getClass()) || classes.length == 0) {
                generator.func_180709_b(world, rand, pos);
            }
            ++i;
        }
    }

    private void generateTree(WorldGenerator generator, World world, Random rand, int chunkX, int chunkZ, double chancesToSpawn, int minHeight, int maxHeight, Set<Class> classes) {
        double flooredchances = MathHelper.func_76128_c((double)chancesToSpawn);
        if (chancesToSpawn != flooredchances) {
            chancesToSpawn = rand.nextDouble() < chancesToSpawn - flooredchances ? flooredchances + 1.0 : flooredchances;
        }
        int dHeight = maxHeight - minHeight;
        int i = 0;
        while ((double)i < chancesToSpawn) {
            Class<?> biome;
            BlockPos pos = new BlockPos(chunkX * 16 + 10 + rand.nextInt(15), minHeight + rand.nextInt(dHeight), chunkZ * 16 + 10 + rand.nextInt(15));
            if (minHeight < 0) {
                pos = world.func_175645_m(pos);
            }
            if (classes.contains(biome = world.field_73011_w.getBiomeForCoords(pos).getClass()) || classes.size() == 0) {
                generator.func_180709_b(world, rand, pos);
            }
            ++i;
        }
    }

    private void generateStructure(WorldGenerator generator, World world, Random rand, int chunkX, int chunkZ, int rarity, EnumBiomeType btype, Class<?> ... classes) {
        ArrayList classesList = new ArrayList(Arrays.asList(classes));
        int x = chunkX * 16 + rand.nextInt(15) + 8;
        int z = chunkZ * 16 + rand.nextInt(15) + 8;
        int y = btype == EnumBiomeType.AUSTRALIAN ? MCWorld.calculateGenHeight(world, x, z, new Block[]{Blocks.field_150354_m, Blocks.field_150349_c}) - 3 : (btype == EnumBiomeType.WATER ? MCWorld.calculateGenHeight(world, x, z, new Block[]{Blocks.field_150355_j}) : MCWorld.calculateGenHeight(world, x, z, new Block[]{Blocks.field_150349_c}) - 3);
        BlockPos pos = new BlockPos(x, y, z);
        Class<?> biome = world.field_73011_w.getBiomeForCoords(pos).getClass();
        if (world.func_175624_G() != WorldType.field_77138_c && classesList.contains(biome) && rand.nextInt(rarity) == 0) {
            generator.func_180709_b(world, rand, pos);
        }
    }

    private void generateTree(WorldGenerator generator, World world, Random rand, int chunkX, int chunkZ, double chancesToSpawn, int minHeight, int maxHeight, BiomeDictionary.Type ... types) {
        if (chancesToSpawn < 1.0) {
            chancesToSpawn = rand.nextDouble() < chancesToSpawn ? 1.0 : 0.0;
        }
        ArrayList<BiomeDictionary.Type> classesList = new ArrayList<BiomeDictionary.Type>(Arrays.asList(types));
        int dHeight = maxHeight - minHeight;
        int i = 0;
        while ((double)i < chancesToSpawn) {
            BlockPos pos = new BlockPos(chunkX * 16 + 10 + rand.nextInt(15), minHeight + rand.nextInt(dHeight), chunkZ * 16 + 10 + rand.nextInt(15));
            if (minHeight < 0) {
                pos = world.func_175645_m(pos);
            }
            Set typeset = BiomeDictionary.getTypes((Biome)world.field_73011_w.getBiomeForCoords(pos));
            boolean canGenerateInBiome = false;
            for (BiomeDictionary.Type t : typeset) {
                BiomeDictionary.Type t1;
                int n = 0;
                BiomeDictionary.Type[] typeArray = types;
                int n2 = typeArray.length;
                if (n < n2 && t == (t1 = typeArray[n])) {
                    canGenerateInBiome = true;
                }
                if (!canGenerateInBiome) continue;
                break;
            }
            if (canGenerateInBiome) {
                generator.func_180709_b(world, rand, pos);
            }
            ++i;
        }
    }

    private static int calculateGenHeight(World world, int x, int z, Block ... topBlocks) {
        int y = world.func_72800_K();
        boolean foundGround = false;
        block0: while (!foundGround && y-- >= 0) {
            Block block = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            foundGround = false;
            for (Block topBlock : topBlocks) {
                boolean bl = foundGround = block == topBlock;
                if (foundGround) continue block0;
            }
        }
        return y;
    }

    static {
        readerStructureChars = new char[Short.MAX_VALUE];
        readerStructure1Chars = new char[Short.MAX_VALUE];
        readerStructure2Chars = new char[Short.MAX_VALUE];
        ULURU = new StructureBase("uluru");
        SHIP1 = new StructureBase("v_boat_1");
        SHIP2 = new StructureBase("v_boat_2");
        SHIP3 = new StructureBase("v_boat_3");
        SHIP4 = new StructureBase("v_boat_4");
        SHIP5 = new StructureBase("v_boat_5");
        try {
            if (staticStructureReader == null) {
                staticStructureReader = new FileReader(RegistryHandler.getConfigStructureFile());
                staticStructureReader.read(readerStructureChars);
                structureWeightConfig = new ConfigHandler(readerStructureChars, false);
                structureWeightsTrue = structureWeightConfig.getContainer("ConfigStructure");
                System.out.println("Zoesteria has loaded Module STRUCTURE_CONFIG");
                staticStructureReader.close();
            }
            if (staticStructure1Reader == null) {
                staticStructure1Reader = new FileReader(RegistryHandler.getConfigStructure1File());
                staticStructure1Reader.read(readerStructure1Chars);
                structure1WeightConfig = new ConfigHandler(readerStructure1Chars, false);
                structure1WeightsTrue = structure1WeightConfig.getContainer("StructureRarity");
                System.out.println("Zoesteria has loaded Module STRUCTURE_CONFIG_ULURU");
                staticStructure1Reader.close();
            }
            if (staticStructure2Reader == null) {
                staticStructure2Reader = new FileReader(RegistryHandler.getConfigStructure2File());
                staticStructure2Reader.read(readerStructure2Chars);
                structure2WeightConfig = new ConfigHandler(readerStructure2Chars, false);
                structure2WeightsTrue = structure2WeightConfig.getContainer("StructureRarity");
                System.out.println("Zoesteria has loaded Module STRUCTURE_CONFIG_SHIPS");
                staticStructure2Reader.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static enum EnumBiomeType {
        DEFAULT,
        WATER,
        AUSTRALIAN;

    }
}

