/*
 * Decompiled with CFR 0.152.
 */
package valoeghese.valoeghesesbe.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import valoeghese.valoeghesesbe.Main;
import valoeghese.valoeghesesbe.init.ModBlocks;
import valoeghese.valoeghesesbe.init.ModItems;
import valoeghese.valoeghesesbe.util.IHasModel;

public class BlockSmallBush
extends BlockBush
implements IShearable,
IHasModel {
    protected static final AxisAlignedBB SAPLING_AABB = new AxisAlignedBB(0.09999999403953552, 0.0, 0.09999999403953552, (double)0.9f, (double)0.8f, (double)0.9f);
    public static final PropertyEnum<EnumBushType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumBushType.class);

    public BlockSmallBush(String name) {
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)EnumBushType.STANDARD)));
        this.func_149711_c(0.2f);
        this.func_149647_a(Main.tabWorld);
        this.func_149672_a(SoundType.field_185850_c);
        ModBlocks.BLOCKS.add((Block)this);
        ModItems.ITEMS.add((Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName()));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        return super.func_176196_c(worldIn, pos) && soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        return super.func_180671_f(worldIn, pos, state);
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public Item func_180660_a(IBlockState state, Random rand, int f) {
        if (state == this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumBushType.BERRY))) {
            return rand.nextInt(5) >= 2 ? ModItems.BERRY : Items.field_151055_y;
        }
        return Items.field_151055_y;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        int count = this.quantityDropped(state, fortune, rand);
        for (int i = 0; i < count; ++i) {
            Item item = this.func_180660_a(state, rand, fortune);
            if (item == Items.field_190931_a) continue;
            drops.add((Object)new ItemStack(item, 1, 0));
        }
    }

    public int func_149745_a(Random rand) {
        return rand.nextInt(4) + 1;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SAPLING_AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumBushType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (EnumBushType variant : EnumBushType.values()) {
            items.add((Object)new ItemStack((Block)this, 1, variant.getMetadata()));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumBushType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumBushType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer.field_70128_L) {
            return;
        }
        if (stack.func_77960_j() == 2) {
            worldIn.func_180501_a(pos, this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumBushType.CONIFEROUS)), 2);
        } else if (stack.func_77960_j() == 1) {
            worldIn.func_180501_a(pos, this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumBushType.BERRY)), 2);
        }
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public NonNullList<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return NonNullList.func_191197_a((int)1, (Object)new ItemStack((Block)this, 1, ((EnumBushType)((Object)world.func_180495_p(pos).func_177229_b(VARIANT))).getMetadata()));
    }

    @Override
    public void registerModels() {
        Main.proxy.registerModel(Item.func_150898_a((Block)this), 0);
        Main.proxy.registerModelWithCustomResourceLocation(Item.func_150898_a((Block)this), "valoegheses_be:bush_small_1", 1);
        Main.proxy.registerModelWithCustomResourceLocation(Item.func_150898_a((Block)this), "valoegheses_be:bush_small_2", 2);
    }

    public static enum EnumBushType implements IStringSerializable
    {
        STANDARD(0, "standard"),
        BERRY(1, "berry"),
        CONIFEROUS(2, "coniferous");

        private static final EnumBushType[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final String unlocalizedName;

        private EnumBushType(int metaIn, String nameIn) {
            this(metaIn, nameIn, nameIn);
        }

        private EnumBushType(int metaIn, String nameIn, String unlocalizedNameIn) {
            this.meta = metaIn;
            this.name = nameIn;
            this.unlocalizedName = unlocalizedNameIn;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public static EnumBushType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        static {
            META_LOOKUP = new EnumBushType[EnumBushType.values().length];
            EnumBushType[] enumBushTypeArray = EnumBushType.values();
            int n = enumBushTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumBushType blocksmallbush$enumbushtype;
                EnumBushType.META_LOOKUP[blocksmallbush$enumbushtype.getMetadata()] = blocksmallbush$enumbushtype = enumBushTypeArray[i];
            }
        }
    }
}

