/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.me.helpers.BaseActionSource;
import appeng.me.storage.ITickingMonitor;
import appeng.tile.misc.TileCondenser;
import appeng.util.item.AEItemStack;
import appeng.util.item.ItemList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.item.ItemStack;

class CondenserItemInventory
implements IMEMonitor<IAEItemStack>,
ITickingMonitor {
    private final HashMap<IMEMonitorHandlerReceiver<IAEItemStack>, Object> listeners = new HashMap();
    private final TileCondenser target;
    private boolean hasChanged = true;
    private final ItemList cachedList = new ItemList();
    private IActionSource actionSource = new BaseActionSource();
    private ItemList changeSet = new ItemList();

    CondenserItemInventory(TileCondenser te) {
        this.target = te;
    }

    @Override
    public IAEItemStack injectItems(IAEItemStack input, Actionable mode, IActionSource src) {
        if (mode == Actionable.MODULATE && input != null) {
            this.target.addPower(input.getStackSize());
        }
        return null;
    }

    @Override
    public IAEItemStack extractItems(IAEItemStack request, Actionable mode, IActionSource src) {
        AEItemStack ret = null;
        ItemStack slotItem = this.target.getOutputSlot().getStackInSlot(0);
        if (!slotItem.func_190926_b() && request.isSameType(slotItem)) {
            int count = (int)Math.min(request.getStackSize(), Integer.MAX_VALUE);
            ret = AEItemStack.fromItemStack(this.target.getOutputSlot().extractItem(0, count, mode == Actionable.SIMULATE));
        }
        return ret;
    }

    @Override
    public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> out) {
        if (!this.target.getOutputSlot().getStackInSlot(0).func_190926_b()) {
            out.add(AEItemStack.fromItemStack(this.target.getOutputSlot().getStackInSlot(0)));
        }
        return out;
    }

    @Override
    public IItemList<IAEItemStack> getStorageList() {
        if (this.hasChanged) {
            this.hasChanged = false;
            this.cachedList.resetStatus();
            return this.getAvailableItems(this.cachedList);
        }
        return this.cachedList;
    }

    @Override
    public IStorageChannel<IAEItemStack> getChannel() {
        return AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
    }

    @Override
    public AccessRestriction getAccess() {
        return AccessRestriction.READ_WRITE;
    }

    @Override
    public boolean isPrioritized(IAEItemStack input) {
        return false;
    }

    @Override
    public boolean canAccept(IAEItemStack input) {
        return true;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public int getSlot() {
        return 0;
    }

    @Override
    public boolean validForPass(int i) {
        return i == 2;
    }

    @Override
    public void addListener(IMEMonitorHandlerReceiver<IAEItemStack> l, Object verificationToken) {
        this.listeners.put(l, verificationToken);
    }

    @Override
    public void removeListener(IMEMonitorHandlerReceiver<IAEItemStack> l) {
        this.listeners.remove(l);
    }

    public void updateOutput(ItemStack added, ItemStack removed) {
        this.hasChanged = true;
        if (!added.func_190926_b()) {
            this.changeSet.add(AEItemStack.fromItemStack(added));
        }
        if (!removed.func_190926_b()) {
            this.changeSet.add((IAEItemStack)AEItemStack.fromItemStack(removed).setStackSize(-removed.func_190916_E()));
        }
    }

    @Override
    public TickRateModulation onTick() {
        ItemList currentChanges = this.changeSet;
        if (currentChanges.isEmpty()) {
            return TickRateModulation.IDLE;
        }
        this.changeSet = new ItemList();
        Iterator<Map.Entry<IMEMonitorHandlerReceiver<IAEItemStack>, Object>> i = this.listeners.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<IMEMonitorHandlerReceiver<IAEItemStack>, Object> l = i.next();
            IMEMonitorHandlerReceiver<IAEItemStack> key = l.getKey();
            if (key.isValid(l.getValue())) {
                key.postChange(this, currentChanges, this.actionSource);
                continue;
            }
            i.remove();
        }
        return TickRateModulation.URGENT;
    }

    @Override
    public void setActionSource(IActionSource actionSource) {
        this.actionSource = actionSource;
    }
}

