/*
 * Decompiled with CFR 0.152.
 */
package appeng.me;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridStorage;
import appeng.core.AELog;
import appeng.core.worlddata.WorldData;
import appeng.me.Grid;
import appeng.me.GridStorageSearch;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import javax.xml.bind.DatatypeConverter;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public class GridStorage
implements IGridStorage {
    private final long myID;
    private final NBTTagCompound data;
    private final GridStorageSearch mySearchEntry;
    private final WeakHashMap<GridStorage, Boolean> divided = new WeakHashMap();
    private WeakReference<IGrid> internalGrid = null;

    public GridStorage(long id, GridStorageSearch gss) {
        this.myID = id;
        this.mySearchEntry = gss;
        this.data = new NBTTagCompound();
    }

    public GridStorage(String input, long id, GridStorageSearch gss) {
        this.myID = id;
        this.mySearchEntry = gss;
        NBTTagCompound myTag = null;
        try {
            byte[] byteData = DatatypeConverter.parseBase64Binary((String)input);
            myTag = CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(byteData));
        }
        catch (Throwable t) {
            myTag = new NBTTagCompound();
        }
        this.data = myTag;
    }

    public GridStorage() {
        this.myID = 0L;
        this.mySearchEntry = null;
        this.data = new NBTTagCompound();
    }

    public String getValue() {
        Grid currentGrid = (Grid)this.getGrid();
        if (currentGrid != null) {
            currentGrid.saveState();
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            CompressedStreamTools.func_74799_a((NBTTagCompound)this.data, (OutputStream)out);
            return DatatypeConverter.printBase64Binary((byte[])out.toByteArray());
        }
        catch (IOException e) {
            AELog.debug(e);
            return "";
        }
    }

    public IGrid getGrid() {
        return this.internalGrid == null ? null : (IGrid)this.internalGrid.get();
    }

    void setGrid(Grid grid) {
        this.internalGrid = new WeakReference<Grid>(grid);
    }

    @Override
    public NBTTagCompound dataObject() {
        return this.data;
    }

    @Override
    public long getID() {
        return this.myID;
    }

    void addDivided(GridStorage gs) {
        this.divided.put(gs, true);
    }

    boolean hasDivided(GridStorage myStorage) {
        return this.divided.containsKey(myStorage);
    }

    void remove() {
        WorldData.instance().storageData().destroyGridStorage(this.myID);
    }
}

