/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.storage;

import appeng.api.implementations.TransitionResult;
import appeng.api.implementations.items.ISpatialStorageCell;
import appeng.api.storage.ISpatialDimension;
import appeng.api.util.WorldCoord;
import appeng.capabilities.Capabilities;
import appeng.core.AppEng;
import appeng.core.localization.GuiText;
import appeng.items.AEBaseItem;
import appeng.spatial.StorageHelper;
import appeng.util.Platform;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSpatialStorageCell
extends AEBaseItem
implements ISpatialStorageCell {
    private static final String NBT_CELL_ID_KEY = "StorageCellID";
    private static final String NBT_SIZE_X_KEY = "sizeX";
    private static final String NBT_SIZE_Y_KEY = "sizeY";
    private static final String NBT_SIZE_Z_KEY = "sizeZ";
    private final int maxRegion;

    public ItemSpatialStorageCell(int spatialScale) {
        this.func_77625_d(1);
        this.maxRegion = spatialScale;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addCheckedInformation(ItemStack stack, World world, List<String> lines, ITooltipFlag advancedTooltips) {
        int id = this.getStoredDimensionID(stack);
        if (id >= 0) {
            lines.add(GuiText.CellId.getLocal() + ": " + id);
        }
        WorldCoord wc = this.getStoredSize(stack);
        if (wc.x > 0) {
            lines.add(GuiText.StoredSize.getLocal() + ": " + wc.x + " x " + wc.y + " x " + wc.z);
        }
    }

    @Override
    public boolean isSpatialStorage(ItemStack is) {
        return true;
    }

    @Override
    public int getMaxStoredDim(ItemStack is) {
        return this.maxRegion;
    }

    @Override
    public ISpatialDimension getSpatialDimension() {
        int id = AppEng.instance().getStorageDimensionID();
        WorldServer w = DimensionManager.getWorld((int)id);
        if (w == null) {
            DimensionManager.initDimension((int)id);
            w = DimensionManager.getWorld((int)id);
        }
        if (w != null && w.hasCapability(Capabilities.SPATIAL_DIMENSION, null)) {
            return (ISpatialDimension)w.getCapability(Capabilities.SPATIAL_DIMENSION, null);
        }
        return null;
    }

    @Override
    public WorldCoord getStoredSize(ItemStack is) {
        if (is.func_77942_o()) {
            NBTTagCompound c = is.func_77978_p();
            return new WorldCoord(c.func_74762_e(NBT_SIZE_X_KEY), c.func_74762_e(NBT_SIZE_Y_KEY), c.func_74762_e(NBT_SIZE_Z_KEY));
        }
        return new WorldCoord(0, 0, 0);
    }

    @Override
    public int getStoredDimensionID(ItemStack is) {
        if (is.func_77942_o()) {
            NBTTagCompound c = is.func_77978_p();
            return c.func_74762_e(NBT_CELL_ID_KEY);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransitionResult doSpatialTransition(ItemStack is, World w, WorldCoord min, WorldCoord max, int playerId) {
        int targetX = max.x - min.x - 1;
        int targetY = max.y - min.y - 1;
        int targetZ = max.z - min.z - 1;
        int maxSize = this.getMaxStoredDim(is);
        BlockPos targetSize = new BlockPos(targetX, targetY, targetZ);
        ISpatialDimension manager = this.getSpatialDimension();
        int cellid = this.getStoredDimensionID(is);
        if (cellid < 0) {
            cellid = manager.createNewCellDimension(targetSize, playerId);
        }
        try {
            BlockPos scale;
            if (manager.isCellDimension(cellid) && (scale = manager.getCellContentSize(cellid)).equals((Object)targetSize) && targetX <= maxSize && targetY <= maxSize && targetZ <= maxSize) {
                BlockPos offset = manager.getCellDimensionOrigin(cellid);
                this.setStorageCell(is, cellid, targetSize);
                StorageHelper.getInstance().swapRegions(w, min.x + 1, min.y + 1, min.z + 1, manager.getWorld(), offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p(), targetX - 1, targetY - 1, targetZ - 1);
                TransitionResult transitionResult = new TransitionResult(true, 0.0);
                return transitionResult;
            }
            TransitionResult transitionResult = new TransitionResult(false, 0.0);
            return transitionResult;
        }
        finally {
            if (manager.isCellDimension(cellid) && this.getStoredDimensionID(is) < 0) {
                manager.deleteCellDimension(cellid);
            }
        }
    }

    private void setStorageCell(ItemStack is, int id, BlockPos size) {
        NBTTagCompound c = Platform.openNbtData(is);
        c.func_74768_a(NBT_CELL_ID_KEY, id);
        c.func_74768_a(NBT_SIZE_X_KEY, size.func_177958_n());
        c.func_74768_a(NBT_SIZE_Y_KEY, size.func_177956_o());
        c.func_74768_a(NBT_SIZE_Z_KEY, size.func_177952_p());
    }
}

