/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.waila.part;

import appeng.api.parts.IPart;
import appeng.core.localization.WailaText;
import appeng.integration.modules.waila.part.BasePartWailaDataProvider;
import appeng.me.GridAccessException;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.util.Platform;
import com.google.common.collect.Iterators;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public final class P2PStateWailaDataProvider
extends BasePartWailaDataProvider {
    private static final int STATE_UNLINKED = 0;
    private static final int STATE_OUTPUT = 1;
    private static final int STATE_INPUT = 2;
    public static final String TAG_P2P_STATE = "p2p_state";
    public static final String TAG_P2P_FREQUENCY = "p2p_frequency";

    @Override
    public List<String> getWailaBody(IPart part, List<String> currentToolTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        NBTTagCompound nbtData;
        if (part instanceof PartP2PTunnel && (nbtData = accessor.getNBTData()).func_74764_b(TAG_P2P_STATE)) {
            int[] stateArr = nbtData.func_74759_k(TAG_P2P_STATE);
            if (stateArr.length == 2) {
                int state = stateArr[0];
                int outputs = stateArr[1];
                switch (state) {
                    case 0: {
                        currentToolTip.add(WailaText.P2PUnlinked.getLocal());
                        break;
                    }
                    case 1: {
                        currentToolTip.add(WailaText.P2POutput.getLocal());
                        break;
                    }
                    case 2: {
                        currentToolTip.add(P2PStateWailaDataProvider.getOutputText(outputs));
                    }
                }
            }
            short freq = nbtData.func_74765_d(TAG_P2P_FREQUENCY);
            String freqTooltip = Platform.p2p().toHexString(freq);
            currentToolTip.add(I18n.func_74837_a((String)"gui.tooltips.appliedenergistics2.P2PFrequency", (Object[])new Object[]{freqTooltip}));
        }
        return currentToolTip;
    }

    @Override
    public NBTTagCompound getNBTData(EntityPlayerMP player, IPart part, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        if (part instanceof PartP2PTunnel) {
            PartP2PTunnel tunnel = (PartP2PTunnel)part;
            if (!tunnel.isPowered()) {
                return tag;
            }
            short frequency = tunnel.getFrequency();
            tag.func_74777_a(TAG_P2P_FREQUENCY, frequency);
            int state = 0;
            int outputCount = 0;
            if (!tunnel.isOutput()) {
                outputCount = P2PStateWailaDataProvider.getOutputCount(tunnel);
                if (outputCount > 0) {
                    state = 2;
                }
            } else {
                Object input = tunnel.getInput();
                if (input != null) {
                    state = 1;
                }
            }
            tag.func_74783_a(TAG_P2P_STATE, new int[]{state, outputCount});
        }
        return tag;
    }

    private static int getOutputCount(PartP2PTunnel tunnel) {
        try {
            return Iterators.size(tunnel.getOutputs().iterator());
        }
        catch (GridAccessException e) {
            return 0;
        }
    }

    private static String getOutputText(int outputs) {
        if (outputs <= 1) {
            return WailaText.P2PInputOneOutput.getLocal();
        }
        return String.format(WailaText.P2PInputManyOutputs.getLocal(), outputs);
    }
}

