/*
 * Decompiled with CFR 0.152.
 */
package appeng.helpers;

import appeng.api.AEApi;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.container.ContainerNull;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.features.AEFeature;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringJoiner;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class PatternHelper
implements ICraftingPatternDetails,
Comparable<PatternHelper> {
    private final ItemStack patternItem;
    private final InventoryCrafting crafting = new InventoryCrafting((Container)new ContainerNull(), 3, 3);
    private final InventoryCrafting testFrame = new InventoryCrafting((Container)new ContainerNull(), 3, 3);
    private final ItemStack correctOutput;
    private final IRecipe standardRecipe;
    private final IAEItemStack[] condensedInputs;
    private final IAEItemStack[] condensedOutputs;
    private final IAEItemStack[] inputs;
    private final IAEItemStack[] outputs;
    private final boolean isCrafting;
    private final boolean canSubstitute;
    private final Set<TestLookup> failCache = new HashSet<TestLookup>();
    private final Set<TestLookup> passCache = new HashSet<TestLookup>();
    private final IAEItemStack pattern;
    private int priority = 0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PatternHelper(ItemStack is, World w) {
        ItemStack gs;
        int x;
        NBTTagCompound encodedValue = is.func_77978_p();
        if (encodedValue == null) {
            throw new IllegalArgumentException("No pattern here!");
        }
        NBTTagList inTag = encodedValue.func_150295_c("in", 10);
        NBTTagList outTag = encodedValue.func_150295_c("out", 10);
        this.isCrafting = encodedValue.func_74767_n("crafting");
        this.canSubstitute = this.isCrafting && encodedValue.func_74767_n("substitute");
        this.patternItem = is;
        this.pattern = AEItemStack.fromItemStack(is);
        ArrayList in = new ArrayList();
        ArrayList out = new ArrayList();
        for (x = 0; x < inTag.func_74745_c(); ++x) {
            NBTTagCompound ingredient = inTag.func_150305_b(x);
            gs = new ItemStack(ingredient);
            if (!ingredient.func_82582_d() && gs.func_190926_b()) {
                throw new IllegalArgumentException("No pattern here!");
            }
            this.crafting.func_70299_a(x, gs);
            if (!(gs.func_190926_b() || this.isCrafting && gs.func_77942_o())) {
                this.markItemAs(x, gs, TestStatus.ACCEPT);
            }
            in.add(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(gs));
            this.testFrame.func_70299_a(x, gs);
        }
        if (this.isCrafting) {
            this.standardRecipe = CraftingManager.func_192413_b((InventoryCrafting)this.crafting, (World)w);
            if (this.standardRecipe == null) throw new IllegalStateException("No pattern here!");
            this.correctOutput = this.standardRecipe.func_77572_b(this.crafting);
            out.add(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(this.correctOutput));
        } else {
            this.standardRecipe = null;
            this.correctOutput = ItemStack.field_190927_a;
            for (x = 0; x < outTag.func_74745_c(); ++x) {
                IAEItemStack[] resultItemTag = outTag.func_150305_b(x);
                gs = new ItemStack((NBTTagCompound)resultItemTag);
                if (!resultItemTag.func_82582_d() && gs.func_190926_b()) {
                    throw new IllegalArgumentException("No pattern here!");
                }
                if (gs.func_190926_b()) continue;
                out.add(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(gs));
            }
        }
        this.outputs = out.toArray(new IAEItemStack[out.size()]);
        this.inputs = in.toArray(new IAEItemStack[in.size()]);
        HashMap<IAEItemStack, IAEItemStack> tmpOutputs = new HashMap<IAEItemStack, IAEItemStack>();
        for (IAEItemStack io : this.outputs) {
            if (io == null) continue;
            IAEItemStack g = (IAEItemStack)tmpOutputs.get(io);
            if (g == null) {
                tmpOutputs.put(io, io.copy());
                continue;
            }
            g.add(io);
        }
        HashMap<IAEItemStack, IAEItemStack> tmpInputs = new HashMap<IAEItemStack, IAEItemStack>();
        for (IAEItemStack io : this.inputs) {
            if (io == null) continue;
            IAEItemStack g = (IAEItemStack)tmpInputs.get(io);
            if (g == null) {
                tmpInputs.put(io, io.copy());
                continue;
            }
            g.add(io);
        }
        if (tmpOutputs.isEmpty() || tmpInputs.isEmpty()) {
            throw new IllegalStateException("No pattern here!");
        }
        this.condensedInputs = new IAEItemStack[tmpInputs.size()];
        int offset = 0;
        Iterator iterator = tmpInputs.values().iterator();
        while (iterator.hasNext()) {
            IAEItemStack io;
            this.condensedInputs[offset] = io = (IAEItemStack)iterator.next();
            ++offset;
        }
        offset = 0;
        this.condensedOutputs = new IAEItemStack[tmpOutputs.size()];
        iterator = tmpOutputs.values().iterator();
        while (iterator.hasNext()) {
            IAEItemStack io;
            this.condensedOutputs[offset] = io = (IAEItemStack)iterator.next();
            ++offset;
        }
    }

    private void markItemAs(int slotIndex, ItemStack i, TestStatus b) {
        if (b == TestStatus.TEST || i.func_77942_o()) {
            return;
        }
        (b == TestStatus.ACCEPT ? this.passCache : this.failCache).add(new TestLookup(slotIndex, i));
    }

    @Override
    public ItemStack getPattern() {
        return this.patternItem;
    }

    @Override
    public synchronized boolean isValidItemForSlot(int slotIndex, ItemStack i, World w) {
        if (!this.isCrafting) {
            throw new IllegalStateException("Only crafting recipes supported.");
        }
        TestStatus result = this.getStatus(slotIndex, i);
        switch (result) {
            case ACCEPT: {
                return true;
            }
            case DECLINE: {
                return false;
            }
        }
        for (int x = 0; x < this.crafting.func_70302_i_(); ++x) {
            this.testFrame.func_70299_a(x, this.crafting.func_70301_a(x));
        }
        this.testFrame.func_70299_a(slotIndex, i);
        if (this.standardRecipe.func_77569_a(this.testFrame, w)) {
            ItemStack testOutput = this.standardRecipe.func_77572_b(this.testFrame);
            if (Platform.itemComparisons().isSameItem(this.correctOutput, testOutput)) {
                this.testFrame.func_70299_a(slotIndex, this.crafting.func_70301_a(slotIndex));
                this.markItemAs(slotIndex, i, TestStatus.ACCEPT);
                return true;
            }
        } else if (AEConfig.instance().isFeatureEnabled(AEFeature.CRAFTING_MANAGER_FALLBACK)) {
            ItemStack testOutput = CraftingManager.func_82787_a((InventoryCrafting)this.testFrame, (World)w);
            if (Platform.itemComparisons().isSameItem(this.correctOutput, testOutput)) {
                this.testFrame.func_70299_a(slotIndex, this.crafting.func_70301_a(slotIndex));
                this.markItemAs(slotIndex, i, TestStatus.ACCEPT);
                if (AELog.isCraftingDebugLogEnabled()) {
                    this.warnAboutCraftingManager(true);
                }
                return true;
            }
            this.warnAboutCraftingManager(false);
        }
        this.markItemAs(slotIndex, i, TestStatus.DECLINE);
        return false;
    }

    @Override
    public boolean isCraftable() {
        return this.isCrafting;
    }

    @Override
    public IAEItemStack[] getInputs() {
        return this.inputs;
    }

    @Override
    public IAEItemStack[] getCondensedInputs() {
        return this.condensedInputs;
    }

    @Override
    public IAEItemStack[] getCondensedOutputs() {
        return this.condensedOutputs;
    }

    @Override
    public IAEItemStack[] getOutputs() {
        return this.outputs;
    }

    @Override
    public boolean canSubstitute() {
        return this.canSubstitute;
    }

    @Override
    public ItemStack getOutput(InventoryCrafting craftingInv, World w) {
        if (!this.isCrafting) {
            throw new IllegalStateException("Only crafting recipes supported.");
        }
        for (int x = 0; x < craftingInv.func_70302_i_(); ++x) {
            if (this.isValidItemForSlot(x, craftingInv.func_70301_a(x), w)) continue;
            return ItemStack.field_190927_a;
        }
        if (this.outputs != null && this.outputs.length > 0) {
            return this.outputs[0].createItemStack();
        }
        return ItemStack.field_190927_a;
    }

    private TestStatus getStatus(int slotIndex, ItemStack i) {
        if (this.crafting.func_70301_a(slotIndex).func_190926_b()) {
            return i.func_190926_b() ? TestStatus.ACCEPT : TestStatus.DECLINE;
        }
        if (i.func_190926_b()) {
            return TestStatus.DECLINE;
        }
        if (i.func_77942_o()) {
            return TestStatus.TEST;
        }
        if (this.passCache.contains(new TestLookup(slotIndex, i))) {
            return TestStatus.ACCEPT;
        }
        if (this.failCache.contains(new TestLookup(slotIndex, i))) {
            return TestStatus.DECLINE;
        }
        return TestStatus.TEST;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public int compareTo(PatternHelper o) {
        return Integer.compare(o.priority, this.priority);
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    private void warnAboutCraftingManager(boolean foundAlternative) {
        String foundAlternativeRecipe = foundAlternative ? "Found alternative recipe." : "NOT FOUND, please report.";
        StringJoiner joinActualInputs = new StringJoiner(", ");
        for (int j = 0; j < this.testFrame.func_70302_i_(); ++j) {
            ItemStack stack = this.testFrame.func_70301_a(j);
            if (stack.func_190926_b()) continue;
            joinActualInputs.add(stack.toString());
        }
        AELog.warn("Using CraftingManager fallback: Recipe <%s> for output <%s> rejected inputs [%s]. %s", this.standardRecipe.getRegistryName(), this.standardRecipe.func_77571_b(), joinActualInputs, foundAlternativeRecipe);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PatternHelper other = (PatternHelper)obj;
        if (this.pattern != null && other.pattern != null) {
            return this.pattern.equals(other.pattern);
        }
        return false;
    }

    private static final class TestLookup {
        private final int slot;
        private final int ref;
        private final int hash;

        public TestLookup(int slot, ItemStack i) {
            this(slot, i.func_77973_b(), i.func_77952_i());
        }

        public TestLookup(int slot, Item item, int dmg) {
            this.slot = slot;
            this.ref = dmg << 16 | Item.func_150891_b((Item)item) & 0xFFFF;
            int offset = 3 * slot;
            this.hash = this.ref << offset | this.ref >> offset + 32;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            boolean equality;
            if (obj instanceof TestLookup) {
                TestLookup b = (TestLookup)obj;
                equality = b.slot == this.slot && b.ref == this.ref;
            } else {
                equality = false;
            }
            return equality;
        }
    }

    private static enum TestStatus {
        ACCEPT,
        DECLINE,
        TEST;

    }
}

