/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.util;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.core.Api;
import appeng.fluids.items.FluidDummyItem;
import appeng.util.Platform;
import appeng.util.item.AEStack;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public final class AEFluidStack
extends AEStack<IAEFluidStack>
implements IAEFluidStack,
Comparable<AEFluidStack> {
    private final Fluid fluid;
    private NBTTagCompound tagCompound;

    private AEFluidStack(AEFluidStack fluidStack) {
        this.fluid = fluidStack.fluid;
        this.setStackSize(fluidStack.getStackSize());
        this.setCraftable(fluidStack.isCraftable());
        this.setCountRequestable(fluidStack.getCountRequestable());
        if (fluidStack.hasTagCompound()) {
            this.tagCompound = fluidStack.tagCompound.func_74737_b();
        }
    }

    private AEFluidStack(@Nonnull FluidStack fluidStack) {
        this.fluid = fluidStack.getFluid();
        if (this.fluid == null) {
            throw new IllegalArgumentException("Fluid is null.");
        }
        this.setStackSize(fluidStack.amount);
        this.setCraftable(false);
        this.setCountRequestable(0L);
        if (fluidStack.tag != null) {
            this.tagCompound = fluidStack.tag.func_74737_b();
        }
    }

    public static AEFluidStack fromFluidStack(FluidStack input) {
        if (input == null) {
            return null;
        }
        return new AEFluidStack(input);
    }

    public static IAEFluidStack fromNBT(NBTTagCompound data) {
        FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)data);
        if (fluidStack == null) {
            return null;
        }
        AEFluidStack fluid = AEFluidStack.fromFluidStack(fluidStack);
        fluid.setStackSize(data.func_74763_f("Cnt"));
        fluid.setCountRequestable(data.func_74763_f("Req"));
        fluid.setCraftable(data.func_74767_n("Craft"));
        if (fluid.hasTagCompound()) {
            fluid.tagCompound = fluid.tagCompound.func_74737_b();
        }
        return fluid;
    }

    public static IAEFluidStack fromPacket(ByteBuf buffer) throws IOException {
        byte mask = buffer.readByte();
        byte stackType = (byte)((mask & 0xC) >> 2);
        byte countReqType = (byte)((mask & 0x30) >> 4);
        boolean isCraftable = (mask & 0x40) > 0;
        boolean hasTagCompound = (mask & 0x80) > 0;
        NBTTagCompound d = new NBTTagCompound();
        byte len2 = buffer.readByte();
        byte[] name = new byte[len2];
        buffer.readBytes(name, 0, (int)len2);
        d.func_74778_a("FluidName", new String(name, "UTF-8"));
        d.func_74774_a("Count", (byte)0);
        if (hasTagCompound) {
            int len = buffer.readInt();
            byte[] bd = new byte[len];
            buffer.readBytes(bd);
            DataInputStream di = new DataInputStream(new ByteArrayInputStream(bd));
            d.func_74782_a("Tag", (NBTBase)CompressedStreamTools.func_74794_a((DataInputStream)di));
        }
        long stackSize = AEFluidStack.getPacketValue(stackType, buffer);
        long countRequestable = AEFluidStack.getPacketValue(countReqType, buffer);
        FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)d);
        if (fluidStack == null) {
            return null;
        }
        AEFluidStack fluid = AEFluidStack.fromFluidStack(fluidStack);
        fluid.setStackSize(stackSize);
        fluid.setCountRequestable(countRequestable);
        fluid.setCraftable(isCraftable);
        return fluid;
    }

    @Override
    public void add(IAEFluidStack option) {
        if (option == null) {
            return;
        }
        this.incStackSize(option.getStackSize());
        this.setCountRequestable(this.getCountRequestable() + option.getCountRequestable());
        this.setCraftable(this.isCraftable() || option.isCraftable());
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        data.func_74778_a("FluidName", this.fluid.getName());
        data.func_74774_a("Count", (byte)0);
        data.func_74772_a("Cnt", this.getStackSize());
        data.func_74772_a("Req", this.getCountRequestable());
        data.func_74757_a("Craft", this.isCraftable());
        if (this.hasTagCompound()) {
            data.func_74782_a("Tag", (NBTBase)this.tagCompound);
        } else {
            data.func_82580_o("Tag");
        }
    }

    @Override
    public boolean fuzzyComparison(IAEFluidStack other, FuzzyMode mode) {
        return this.fluid == other.getFluid();
    }

    @Override
    public IAEFluidStack copy() {
        return new AEFluidStack(this);
    }

    @Override
    public IAEFluidStack empty() {
        IAEFluidStack dup = this.copy();
        dup.reset();
        return dup;
    }

    @Override
    public boolean isItem() {
        return false;
    }

    @Override
    public boolean isFluid() {
        return true;
    }

    @Override
    public IStorageChannel<IAEFluidStack> getChannel() {
        return AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class);
    }

    @Override
    public int compareTo(AEFluidStack other) {
        if (this.fluid != other.fluid) {
            return this.fluid.getName().compareTo(other.fluid.getName());
        }
        if (Platform.itemComparisons().isNbtTagEqual((NBTBase)this.tagCompound, (NBTBase)other.tagCompound)) {
            return 0;
        }
        return this.tagCompound.hashCode() - other.tagCompound.hashCode();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fluid == null ? 0 : this.fluid.hashCode());
        result = 31 * result + (this.tagCompound == null ? 0 : this.tagCompound.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof AEFluidStack) {
            AEFluidStack is = (AEFluidStack)other;
            return is.fluid == this.fluid && Platform.itemComparisons().isNbtTagEqual((NBTBase)this.tagCompound, (NBTBase)is.tagCompound);
        }
        if (other instanceof FluidStack) {
            FluidStack is = (FluidStack)other;
            return is.getFluid() == this.fluid && Platform.itemComparisons().isNbtTagEqual((NBTBase)this.tagCompound, (NBTBase)is.tag);
        }
        return false;
    }

    public String toString() {
        return this.getStackSize() + "x" + this.getFluidStack().getFluid().getName() + " " + this.tagCompound;
    }

    @Override
    public boolean hasTagCompound() {
        return this.tagCompound != null;
    }

    @Override
    public FluidStack getFluidStack() {
        int amount = (int)Math.min(Integer.MAX_VALUE, this.getStackSize());
        FluidStack is = new FluidStack(this.fluid, amount, this.tagCompound);
        return is;
    }

    @Override
    public Fluid getFluid() {
        return this.fluid;
    }

    @Override
    public ItemStack asItemStackRepresentation() {
        ItemStack is = Api.INSTANCE.definitions().items().dummyFluidItem().maybeStack(1).orElse(ItemStack.field_190927_a);
        if (!is.func_190926_b()) {
            FluidDummyItem item = (FluidDummyItem)is.func_77973_b();
            item.setFluidStack(is, this.getFluidStack());
            return is;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void writeToPacket(ByteBuf buffer) throws IOException {
        byte mask = (byte)(this.getType(this.getStackSize()) << 2 | this.getType(this.getCountRequestable()) << 4 | (byte)(this.isCraftable() ? 1 : 0) << 6 | (this.hasTagCompound() ? 1 : 0) << 7);
        buffer.writeByte((int)mask);
        this.writeToStream(buffer);
        this.putPacketValue(buffer, this.getStackSize());
        this.putPacketValue(buffer, this.getCountRequestable());
    }

    private void writeToStream(ByteBuf buffer) throws IOException {
        byte[] name = this.fluid.getName().getBytes("UTF-8");
        buffer.writeByte((int)((byte)name.length));
        buffer.writeBytes(name);
        if (this.hasTagCompound()) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(bytes);
            CompressedStreamTools.func_74800_a((NBTTagCompound)this.tagCompound, (DataOutput)data);
            byte[] tagBytes = bytes.toByteArray();
            int size = tagBytes.length;
            buffer.writeInt(size);
            buffer.writeBytes(tagBytes);
        }
    }
}

