/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.AEApi;
import appeng.api.definitions.IItemDefinition;
import appeng.api.features.IInscriberRecipe;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerUpgradeable;
import appeng.container.interfaces.IProgressProvider;
import appeng.container.slot.SlotOutput;
import appeng.container.slot.SlotRestrictedInput;
import appeng.tile.misc.TileInscriber;
import appeng.util.Platform;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class ContainerInscriber
extends ContainerUpgradeable
implements IProgressProvider {
    private final TileInscriber ti;
    private final Slot top;
    private final Slot middle;
    private final Slot bottom;
    @GuiSync(value=2)
    public int maxProcessingTime = -1;
    @GuiSync(value=3)
    public int processingTime = -1;

    public ContainerInscriber(InventoryPlayer ip, TileInscriber te) {
        super(ip, te);
        this.ti = te;
        IItemHandler inv = te.getInternalInventory();
        this.top = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.INSCRIBER_PLATE, inv, 0, 45, 16, this.getInventoryPlayer());
        this.func_75146_a(this.top);
        this.bottom = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.INSCRIBER_PLATE, inv, 1, 45, 62, this.getInventoryPlayer());
        this.func_75146_a(this.bottom);
        this.middle = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.INSCRIBER_INPUT, inv, 2, 63, 39, this.getInventoryPlayer());
        this.func_75146_a(this.middle);
        this.func_75146_a(new SlotOutput(inv, 3, 113, 40, -1));
    }

    @Override
    protected int getHeight() {
        return 176;
    }

    @Override
    protected void setupConfig() {
        this.setupUpgrades();
    }

    @Override
    protected boolean supportCapacity() {
        return false;
    }

    @Override
    public int availableUpgrades() {
        return 3;
    }

    @Override
    public void func_75142_b() {
        this.standardDetectAndSendChanges();
        if (Platform.isServer()) {
            this.maxProcessingTime = this.ti.getMaxProcessingTime();
            this.processingTime = this.ti.getProcessingTime();
        }
    }

    @Override
    public boolean isValidForSlot(Slot s, ItemStack is) {
        ItemStack top = this.ti.getInternalInventory().getStackInSlot(0);
        ItemStack bot = this.ti.getInternalInventory().getStackInSlot(1);
        if (s == this.middle) {
            IItemDefinition press = AEApi.instance().definitions().materials().namePress();
            if (press.isSameAs(top) || press.isSameAs(bot)) {
                return !press.isSameAs(is);
            }
            boolean matches = false;
            for (IInscriberRecipe recipe : AEApi.instance().registries().inscriber().getRecipes()) {
                boolean matchB;
                boolean matchA = !top.func_190926_b() && (Platform.itemComparisons().isSameItem(top, recipe.getTopOptional().orElse(ItemStack.field_190927_a)) || Platform.itemComparisons().isSameItem(top, recipe.getBottomOptional().orElse(ItemStack.field_190927_a)));
                boolean bl = matchB = !bot.func_190926_b() && (Platform.itemComparisons().isSameItem(bot, recipe.getTopOptional().orElse(ItemStack.field_190927_a)) || Platform.itemComparisons().isSameItem(bot, recipe.getBottomOptional().orElse(ItemStack.field_190927_a)));
                if (!matchA && !matchB) continue;
                matches = true;
                for (ItemStack option : recipe.getInputs()) {
                    if (!Platform.itemComparisons().isSameItem(is, option)) continue;
                    return true;
                }
            }
            if (matches) {
                return false;
            }
        } else if (s == this.top && !bot.func_190926_b() || s == this.bottom && !top.func_190926_b()) {
            ItemStack otherSlot = s == this.top ? this.bottom.func_75211_c() : this.top.func_75211_c();
            IItemDefinition namePress = AEApi.instance().definitions().materials().namePress();
            if (namePress.isSameAs(otherSlot)) {
                return namePress.isSameAs(is);
            }
            for (IInscriberRecipe recipe : AEApi.instance().registries().inscriber().getRecipes()) {
                boolean isValid = false;
                if (Platform.itemComparisons().isSameItem(otherSlot, recipe.getTopOptional().orElse(ItemStack.field_190927_a))) {
                    isValid = Platform.itemComparisons().isSameItem(is, recipe.getBottomOptional().orElse(ItemStack.field_190927_a));
                } else if (Platform.itemComparisons().isSameItem(otherSlot, recipe.getBottomOptional().orElse(ItemStack.field_190927_a))) {
                    isValid = Platform.itemComparisons().isSameItem(is, recipe.getTopOptional().orElse(ItemStack.field_190927_a));
                }
                if (!isValid) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public int getCurrentProgress() {
        return this.processingTime;
    }

    @Override
    public int getMaxProgress() {
        return this.maxProcessingTime;
    }
}

