/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import appeng.client.render.VertexFormats;
import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPart;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.BlockPartRotation;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.animation.ModelBlockAnimation;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.client.model.pipeline.VertexLighterFlat;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.ITransformation;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.util.vector.Vector3f;

public enum UVLModelLoader implements ICustomModelLoader
{
    INSTANCE;

    private static final Gson gson;
    private static final Constructor<? extends IModel> vanillaModelWrapper;
    private static final Field faceBakery;
    private static final Object vanillaLoader;
    private static final MethodHandle loaderGetter;
    private IResourceManager resourceManager;

    private static Object deserializer(Class clas) {
        try {
            clas = Class.forName(clas.getName() + "$Deserializer");
            Constructor<?> constr = clas.getDeclaredConstructor(new Class[0]);
            constr.setAccessible(true);
            return constr.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static <M extends IModel> M vanillaModelWrapper(ModelLoader loader, ResourceLocation location, ModelBlock model, boolean uvlock, ModelBlockAnimation animation) {
        try {
            return (M)vanillaModelWrapper.newInstance(loader, location, model, uvlock, animation);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static void setFaceBakery(ModelBakery modelBakery, FaceBakery faceBakery) {
        try {
            UVLModelLoader.faceBakery.set(modelBakery, faceBakery);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public ModelLoader getLoader() {
        try {
            return loaderGetter.invoke(vanillaLoader);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean accepts(ResourceLocation modelLocation) {
        String modelPath = modelLocation.func_110623_a();
        if (modelLocation.func_110623_a().startsWith("models/")) {
            modelPath = modelPath.substring("models/".length());
        }
        try (InputStreamReader io = new InputStreamReader(Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation(modelLocation.func_110624_b(), "models/" + modelPath + ".json")).func_110527_b());){
            boolean bl = ((UVLMarker)UVLModelLoader.gson.fromJson((Reader)io, UVLMarker.class)).ae2_uvl_marker;
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public IModel loadModel(ResourceLocation modelLocation) throws Exception {
        return new UVLModelWrapper(modelLocation);
    }

    static {
        gson = new Gson();
        try {
            Field modifiers = Field.class.getDeclaredField("modifiers");
            modifiers.setAccessible(true);
            faceBakery = ReflectionHelper.findField(ModelBakery.class, (String[])new String[]{"faceBakery", "field_177607_l"});
            modifiers.set(faceBakery, faceBakery.getModifiers() & 0xFFFFFFEF);
            Class<?> clas = Class.forName(ModelLoader.class.getName() + "$VanillaModelWrapper");
            vanillaModelWrapper = clas.getDeclaredConstructor(ModelLoader.class, ResourceLocation.class, ModelBlock.class, Boolean.TYPE, ModelBlockAnimation.class);
            vanillaModelWrapper.setAccessible(true);
            Class<?> vanillaLoaderClass = Class.forName(ModelLoader.class.getName() + "$VanillaLoader");
            Field instanceField = vanillaLoaderClass.getField("INSTANCE");
            vanillaLoader = instanceField.get(null);
            Field loaderField = vanillaLoaderClass.getDeclaredField("loader");
            loaderField.setAccessible(true);
            loaderGetter = MethodHandles.lookup().unreflectGetter(loaderField);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    class UVLMarker {
        boolean ae2_uvl_marker = false;

        UVLMarker() {
        }
    }

    public class UVLModelWrapper
    implements IModel {
        final Gson UVLSERIALIZER;
        private Map<BlockPartFace, Pair<Float, Float>> uvlightmap;
        private final IModel parent;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public UVLModelWrapper(ResourceLocation modelLocation) {
            ModelBlock lvt_5_1_;
            ModelBlockAnimation animation;
            block6: {
                this.UVLSERIALIZER = new GsonBuilder().registerTypeAdapter(ModelBlock.class, UVLModelLoader.deserializer(ModelBlock.class)).registerTypeAdapter(BlockPart.class, UVLModelLoader.deserializer(BlockPart.class)).registerTypeAdapter(BlockPartFace.class, (Object)new BlockPartFaceOverrideSerializer()).registerTypeAdapter(BlockFaceUV.class, UVLModelLoader.deserializer(BlockFaceUV.class)).registerTypeAdapter(ItemTransformVec3f.class, UVLModelLoader.deserializer(ItemTransformVec3f.class)).registerTypeAdapter(ItemCameraTransforms.class, UVLModelLoader.deserializer(ItemCameraTransforms.class)).registerTypeAdapter(ItemOverride.class, UVLModelLoader.deserializer(ItemOverride.class)).create();
                this.uvlightmap = new HashMap<BlockPartFace, Pair<Float, Float>>();
                String modelPath = modelLocation.func_110623_a();
                if (modelLocation.func_110623_a().startsWith("models/")) {
                    modelPath = modelPath.substring("models/".length());
                }
                ResourceLocation armatureLocation = new ResourceLocation(modelLocation.func_110624_b(), "armatures/" + modelPath + ".json");
                animation = ModelBlockAnimation.loadVanillaAnimation((IResourceManager)UVLModelLoader.this.resourceManager, (ResourceLocation)armatureLocation);
                InputStreamReader reader = null;
                IResource iresource = null;
                lvt_5_1_ = null;
                try {
                    String s = modelLocation.func_110623_a();
                    iresource = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation(modelLocation.func_110624_b(), "models/" + modelPath + ".json"));
                    reader = new InputStreamReader(iresource.func_110527_b(), Charsets.UTF_8);
                    lvt_5_1_ = (ModelBlock)JsonUtils.func_188173_a((Gson)this.UVLSERIALIZER, (Reader)reader, ModelBlock.class, (boolean)false);
                    lvt_5_1_.field_178317_b = modelLocation.toString();
                    IOUtils.closeQuietly((Reader)reader);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break block6;
                }
                finally {
                    IOUtils.closeQuietly(reader);
                    IOUtils.closeQuietly(iresource);
                }
                IOUtils.closeQuietly((Closeable)iresource);
            }
            ModelBlock model = lvt_5_1_;
            this.parent = UVLModelLoader.vanillaModelWrapper(UVLModelLoader.this.getLoader(), modelLocation, model, false, animation);
        }

        public Collection<ResourceLocation> getDependencies() {
            return this.parent.getDependencies();
        }

        public Collection<ResourceLocation> getTextures() {
            return this.parent.getTextures();
        }

        public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            UVLModelLoader.setFaceBakery((ModelBakery)UVLModelLoader.this.getLoader(), new FaceBakeryOverride());
            IBakedModel model = this.parent.bake(state, format, bakedTextureGetter);
            UVLModelLoader.setFaceBakery((ModelBakery)UVLModelLoader.this.getLoader(), new FaceBakery());
            return model;
        }

        public IModelState getDefaultState() {
            return this.parent.getDefaultState();
        }

        public class FaceBakeryOverride
        extends FaceBakery {
            public BakedQuad makeBakedQuad(Vector3f posFrom, Vector3f posTo, BlockPartFace face, TextureAtlasSprite sprite, EnumFacing facing, ITransformation modelRotationIn, BlockPartRotation partRotation, boolean uvLocked, boolean shade) {
                BakedQuad quad = super.makeBakedQuad(posFrom, posTo, face, sprite, facing, modelRotationIn, partRotation, uvLocked, shade);
                final Pair brightness = (Pair)UVLModelWrapper.this.uvlightmap.get(face);
                if (brightness != null) {
                    VertexFormat newFormat = VertexFormats.getFormatWithLightMap(quad.getFormat());
                    UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(newFormat);
                    VertexLighterFlat trans = new VertexLighterFlat(Minecraft.func_71410_x().func_184125_al()){

                        protected void updateLightmap(float[] normal, float[] lightmap, float x, float y, float z) {
                            lightmap[0] = ((Float)brightness.getRight()).floatValue();
                            lightmap[1] = ((Float)brightness.getLeft()).floatValue();
                        }

                        public void setQuadTint(int tint) {
                        }
                    };
                    trans.setParent((IVertexConsumer)builder);
                    quad.pipe((IVertexConsumer)trans);
                    builder.setQuadTint(quad.func_178211_c());
                    builder.setQuadOrientation(quad.func_178210_d());
                    builder.setTexture(quad.func_187508_a());
                    builder.setApplyDiffuseLighting(false);
                    return builder.build();
                }
                return quad;
            }
        }

        public class BlockPartFaceOverrideSerializer
        implements JsonDeserializer<BlockPartFace> {
            public BlockPartFace deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
                JsonObject jsonobject = p_deserialize_1_.getAsJsonObject();
                EnumFacing enumfacing = this.parseCullFace(jsonobject);
                int i = this.parseTintIndex(jsonobject);
                String s = this.parseTexture(jsonobject);
                BlockFaceUV blockfaceuv = (BlockFaceUV)p_deserialize_3_.deserialize((JsonElement)jsonobject, BlockFaceUV.class);
                BlockPartFace blockFace = new BlockPartFace(enumfacing, i, s, blockfaceuv);
                UVLModelWrapper.this.uvlightmap.put(blockFace, this.parseUVL(jsonobject));
                return blockFace;
            }

            protected int parseTintIndex(JsonObject object) {
                return JsonUtils.func_151208_a((JsonObject)object, (String)"tintindex", (int)-1);
            }

            private String parseTexture(JsonObject object) {
                return JsonUtils.func_151200_h((JsonObject)object, (String)"texture");
            }

            @Nullable
            private EnumFacing parseCullFace(JsonObject object) {
                String s = JsonUtils.func_151219_a((JsonObject)object, (String)"cullface", (String)"");
                return EnumFacing.func_176739_a((String)s);
            }

            protected Pair<Float, Float> parseUVL(JsonObject object) {
                if (!object.has("uvlightmap")) {
                    return null;
                }
                object = object.get("uvlightmap").getAsJsonObject();
                return new ImmutablePair((Object)Float.valueOf(JsonUtils.func_151221_a((JsonObject)object, (String)"sky", (float)0.0f)), (Object)Float.valueOf(JsonUtils.func_151221_a((JsonObject)object, (String)"block", (float)0.0f)));
            }
        }
    }
}

