/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.AEApi;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IParts;
import appeng.api.storage.ITerminalHost;
import appeng.client.gui.implementations.GuiCraftingCPU;
import appeng.client.gui.widgets.GuiTabButton;
import appeng.container.implementations.ContainerCraftingStatus;
import appeng.core.AELog;
import appeng.core.localization.GuiText;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketSwitchGuis;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.parts.reporting.PartCraftingTerminal;
import appeng.parts.reporting.PartPatternTerminal;
import appeng.parts.reporting.PartTerminal;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Mouse;

public class GuiCraftingStatus
extends GuiCraftingCPU {
    private final ContainerCraftingStatus status;
    private GuiButton selectCPU;
    private GuiTabButton originalGuiBtn;
    private GuiBridge originalGui;
    private ItemStack myIcon = ItemStack.field_190927_a;

    public GuiCraftingStatus(InventoryPlayer inventoryPlayer, ITerminalHost te) {
        super(new ContainerCraftingStatus(inventoryPlayer, te));
        this.status = (ContainerCraftingStatus)this.field_147002_h;
        Object target = this.status.getTarget();
        IDefinitions definitions = AEApi.instance().definitions();
        IParts parts = definitions.parts();
        if (target instanceof WirelessTerminalGuiObject) {
            this.myIcon = definitions.items().wirelessTerminal().maybeStack(1).orElse(ItemStack.field_190927_a);
            this.originalGui = GuiBridge.GUI_WIRELESS_TERM;
        }
        if (target instanceof PartTerminal) {
            this.myIcon = parts.terminal().maybeStack(1).orElse(ItemStack.field_190927_a);
            this.originalGui = GuiBridge.GUI_ME;
        }
        if (target instanceof PartCraftingTerminal) {
            this.myIcon = parts.craftingTerminal().maybeStack(1).orElse(ItemStack.field_190927_a);
            this.originalGui = GuiBridge.GUI_CRAFTING_TERMINAL;
        }
        if (target instanceof PartPatternTerminal) {
            this.myIcon = parts.patternTerminal().maybeStack(1).orElse(ItemStack.field_190927_a);
            this.originalGui = GuiBridge.GUI_PATTERN_TERMINAL;
        }
    }

    @Override
    protected void func_146284_a(GuiButton btn) throws IOException {
        super.func_146284_a(btn);
        boolean backwards = Mouse.isButtonDown((int)1);
        if (btn == this.selectCPU) {
            try {
                NetworkHandler.instance().sendToServer(new PacketValueConfig("Terminal.Cpu", backwards ? "Prev" : "Next"));
            }
            catch (IOException e) {
                AELog.debug(e);
            }
        }
        if (btn == this.originalGuiBtn) {
            NetworkHandler.instance().sendToServer(new PacketSwitchGuis(this.originalGui));
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.selectCPU = new GuiButton(0, this.field_147003_i + 8, this.field_147009_r + this.field_147000_g - 25, 150, 20, GuiText.CraftingCPU.getLocal() + ": " + (Object)((Object)GuiText.NoCraftingCPUs));
        this.field_146292_n.add(this.selectCPU);
        if (!this.myIcon.func_190926_b()) {
            this.originalGuiBtn = new GuiTabButton(this.field_147003_i + 213, this.field_147009_r - 4, this.myIcon, this.myIcon.func_82833_r(), this.field_146296_j);
            this.field_146292_n.add(this.originalGuiBtn);
            this.originalGuiBtn.setHideEdge(13);
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float btn) {
        this.updateCPUButtonText();
        super.func_73863_a(mouseX, mouseY, btn);
    }

    private void updateCPUButtonText() {
        String btnTextText = GuiText.NoCraftingJobs.getLocal();
        if (this.status.selectedCpu >= 0) {
            if (this.status.myName.length() > 0) {
                String name = this.status.myName.substring(0, Math.min(20, this.status.myName.length()));
                btnTextText = GuiText.CPUs.getLocal() + ": " + name;
            } else {
                btnTextText = GuiText.CPUs.getLocal() + ": #" + this.status.selectedCpu;
            }
        }
        if (this.status.noCPU) {
            btnTextText = GuiText.NoCraftingJobs.getLocal();
        }
        this.selectCPU.field_146126_j = btnTextText;
    }

    @Override
    protected String getGuiDisplayName(String in) {
        return in;
    }
}

