/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import mcjty.lib.network.IClientCommandHandler;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.thirteen.Context;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.Logging;
import mcjty.xnet.XNet;
import mcjty.xnet.clientinfo.ChannelClientInfo;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketChannelsReady
implements IMessage {
    public BlockPos pos;
    public List<ChannelClientInfo> list;
    public String command;

    public PacketChannelsReady() {
    }

    public PacketChannelsReady(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketChannelsReady(BlockPos pos, String command, List<ChannelClientInfo> list) {
        this.pos = pos;
        this.command = command;
        this.list = new ArrayList<ChannelClientInfo>();
        this.list.addAll(list);
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            TileEntity te = XNet.proxy.getClientWorld().func_175625_s(this.pos);
            IClientCommandHandler clientCommandHandler = (IClientCommandHandler)te;
            if (!clientCommandHandler.receiveListFromServer(this.command, this.list, Type.create(ChannelClientInfo.class))) {
                Logging.log((String)("Command " + this.command + " was not handled!"));
            }
        });
        ctx.setPacketHandled(true);
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = NetworkTools.readPos((ByteBuf)buf);
        this.command = NetworkTools.readString((ByteBuf)buf);
        int size = buf.readInt();
        if (size != -1) {
            this.list = new ArrayList<ChannelClientInfo>(size);
            for (int i = 0; i < size; ++i) {
                ChannelClientInfo result = buf.readBoolean() ? new ChannelClientInfo(buf) : null;
                ChannelClientInfo item = result;
                this.list.add(item);
            }
        } else {
            this.list = null;
        }
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
        NetworkTools.writeString((ByteBuf)buf, (String)this.command);
        if (this.list == null) {
            buf.writeInt(-1);
        } else {
            buf.writeInt(this.list.size());
            for (ChannelClientInfo item : this.list) {
                if (item == null) {
                    buf.writeBoolean(false);
                    continue;
                }
                buf.writeBoolean(true);
                item.writeToNBT(buf);
            }
        }
    }
}

