/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.clientinfo;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import mcjty.lib.network.NetworkTools;
import mcjty.xnet.api.keys.SidedPos;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class ConnectedBlockClientInfo {
    @Nonnull
    private final SidedPos pos;
    @Nonnull
    private final ItemStack connectedBlock;
    @Nonnull
    private final String name;
    @Nonnull
    private final String blockName;

    public ConnectedBlockClientInfo(@Nonnull SidedPos pos, @Nonnull ItemStack connectedBlock, @Nonnull String name) {
        this.pos = pos;
        this.connectedBlock = connectedBlock;
        this.name = name;
        this.blockName = ConnectedBlockClientInfo.getStackUnlocalizedName(connectedBlock);
    }

    public ConnectedBlockClientInfo(@Nonnull ByteBuf buf) {
        this.pos = new SidedPos(NetworkTools.readPos((ByteBuf)buf), EnumFacing.field_82609_l[buf.readByte()]);
        this.connectedBlock = NetworkTools.readItemStack((ByteBuf)buf);
        this.name = NetworkTools.readStringUTF8((ByteBuf)buf);
        this.blockName = NetworkTools.readStringUTF8((ByteBuf)buf);
    }

    public void writeToBuf(@Nonnull ByteBuf buf) {
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos.getPos());
        buf.writeByte(this.pos.getSide().ordinal());
        NetworkTools.writeItemStack((ByteBuf)buf, (ItemStack)this.connectedBlock);
        NetworkTools.writeStringUTF8((ByteBuf)buf, (String)this.name);
        NetworkTools.writeStringUTF8((ByteBuf)buf, (String)this.blockName);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getBlockUnlocName() {
        return this.blockName;
    }

    @Nonnull
    public SidedPos getPos() {
        return this.pos;
    }

    @Nonnull
    public ItemStack getConnectedBlock() {
        return this.connectedBlock;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectedBlockClientInfo that = (ConnectedBlockClientInfo)o;
        return this.pos.equals(that.pos);
    }

    public int hashCode() {
        return this.pos.hashCode();
    }

    private static String getStackUnlocalizedName(ItemStack stack) {
        NBTTagCompound nbttagcompound = ConnectedBlockClientInfo.getSubCompound(stack, "display");
        if (nbttagcompound != null) {
            if (nbttagcompound.func_150297_b("Name", 8)) {
                return nbttagcompound.func_74779_i("Name");
            }
            if (nbttagcompound.func_150297_b("LocName", 8)) {
                return nbttagcompound.func_74779_i("LocName");
            }
        }
        return stack.func_77973_b().func_77667_c(stack) + ".name";
    }

    private static NBTTagCompound getSubCompound(ItemStack stack, String key) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_150297_b(key, 10)) {
            return stack.func_77978_p().func_74775_l(key);
        }
        return null;
    }
}

