/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.blocks.wireless;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.bindings.DefaultValue;
import mcjty.lib.bindings.IValue;
import mcjty.lib.tileentity.GenericEnergyReceiverTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.WorldTools;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.xnet.api.channels.IChannelType;
import mcjty.xnet.api.channels.IConnectorSettings;
import mcjty.xnet.api.keys.NetworkId;
import mcjty.xnet.api.keys.SidedConsumer;
import mcjty.xnet.blocks.generic.CableColor;
import mcjty.xnet.blocks.router.TileEntityRouter;
import mcjty.xnet.clientinfo.ControllerChannelClientInfo;
import mcjty.xnet.config.ConfigSetup;
import mcjty.xnet.init.ModBlocks;
import mcjty.xnet.logic.LogicTools;
import mcjty.xnet.multiblock.BlobId;
import mcjty.xnet.multiblock.ColorId;
import mcjty.xnet.multiblock.WirelessChannelKey;
import mcjty.xnet.multiblock.WorldBlob;
import mcjty.xnet.multiblock.XNetBlobData;
import mcjty.xnet.multiblock.XNetWirelessChannels;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.Optional;

public final class TileEntityWirelessRouter
extends GenericEnergyReceiverTileEntity
implements ITickable {
    public static final PropertyBool ERROR = PropertyBool.func_177716_a((String)"error");
    public static final int TIER_INVALID = -1;
    public static final int TIER_1 = 0;
    public static final int TIER_2 = 1;
    public static final int TIER_INF = 2;
    public static final Key<Boolean> VALUE_PUBLIC = new Key("public", Type.BOOLEAN);
    private boolean error = false;
    private int counter = 10;
    private boolean publicAccess = false;
    private int globalChannelVersion = -1;

    public TileEntityWirelessRouter() {
        super((long)ConfigSetup.wirelessRouterMaxRF.get(), (long)ConfigSetup.wirelessRouterRfPerTick.get());
    }

    public IValue<?>[] getValues() {
        return new IValue[]{new DefaultValue(VALUE_PUBLIC, this::isPublicAccess, this::setPublicAccess)};
    }

    public boolean isPublicAccess() {
        return this.publicAccess;
    }

    public void setPublicAccess(boolean publicAccess) {
        this.publicAccess = publicAccess;
        this.markDirtyClient();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            NetworkId networkId;
            --this.counter;
            if (this.counter > 0) {
                return;
            }
            this.counter = 10;
            int version = XNetWirelessChannels.getWirelessChannels(this.field_145850_b).getGlobalChannelVersion();
            if (this.globalChannelVersion != version) {
                this.globalChannelVersion = version;
                NetworkId networkId2 = this.findRoutingNetwork();
                if (networkId2 != null) {
                    WorldBlob worldBlob = XNetBlobData.getBlobData(this.field_145850_b).getWorldBlob(this.field_145850_b);
                    worldBlob.markNetworkDirty(networkId2);
                }
            }
            boolean err = false;
            int range = this.getAntennaRange();
            if (range < 0) {
                err = true;
            }
            if (!err && (networkId = this.findRoutingNetwork()) != null) {
                LogicTools.consumers(this.field_145850_b, networkId).forEach(consumerPos -> LogicTools.routers(this.field_145850_b, consumerPos).forEach(r -> this.publishChannels((TileEntityRouter)((Object)((Object)r)), networkId)));
            }
            this.setError(err);
        }
    }

    private int getAntennaTier() {
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_177230_c() != ModBlocks.antennaBaseBlock) {
            return -1;
        }
        Block aboveAntenna = this.field_145850_b.func_180495_p(this.field_174879_c.func_177981_b(2)).func_177230_c();
        if (aboveAntenna == ModBlocks.antennaDishBlock) {
            return 2;
        }
        if (aboveAntenna != ModBlocks.antennaBlock) {
            return -1;
        }
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177981_b(3)).func_177230_c() == ModBlocks.antennaBlock) {
            return 1;
        }
        return 0;
    }

    private int getAntennaRange() {
        int tier = this.getAntennaTier();
        switch (tier) {
            case -1: {
                return -1;
            }
            case 0: {
                return ConfigSetup.antennaTier1Range.get();
            }
            case 1: {
                return ConfigSetup.antennaTier2Range.get();
            }
            case 2: {
                return Integer.MAX_VALUE;
            }
        }
        return -1;
    }

    private boolean inRange(TileEntityWirelessRouter otherRouter) {
        int thisRange = this.getAntennaRange();
        int otherRange = otherRouter.getAntennaRange();
        if (thisRange >= Integer.MAX_VALUE && otherRange >= Integer.MAX_VALUE) {
            return true;
        }
        if (thisRange <= 0 || otherRange <= 0) {
            return false;
        }
        if (this.field_145850_b.field_73011_w.getDimension() != otherRouter.field_145850_b.field_73011_w.getDimension()) {
            return false;
        }
        double maxSqdist = Math.min(thisRange, otherRange);
        maxSqdist *= maxSqdist;
        double sqdist = this.field_174879_c.func_177951_i((Vec3i)otherRouter.field_174879_c);
        return sqdist <= maxSqdist;
    }

    private boolean inRange(XNetWirelessChannels.WirelessRouterInfo wirelessRouter) {
        WorldServer otherWorld = DimensionManager.getWorld((int)wirelessRouter.getCoordinate().getDimension());
        if (otherWorld == null) {
            return false;
        }
        return LogicTools.consumers((World)otherWorld, wirelessRouter.getNetworkId()).filter(arg_0 -> TileEntityWirelessRouter.lambda$inRange$2((World)otherWorld, arg_0)).anyMatch(arg_0 -> this.lambda$inRange$3((World)otherWorld, arg_0));
    }

    public void findRemoteChannelInfo(List<ControllerChannelClientInfo> list) {
        NetworkId network = this.findRoutingNetwork();
        if (network == null) {
            return;
        }
        XNetWirelessChannels wirelessData = XNetWirelessChannels.getWirelessChannels(this.field_145850_b);
        wirelessData.findChannels(this.getOwnerUUID()).forEach(channel -> channel.getRouters().values().stream().filter(routerInfo -> this.isDifferentRouter(network, (XNetWirelessChannels.WirelessRouterInfo)routerInfo)).filter(this::inRange).forEach(routerInfo -> {
            WorldServer otherWorld = DimensionManager.getWorld((int)routerInfo.getCoordinate().getDimension());
            LogicTools.consumers((World)otherWorld, routerInfo.getNetworkId()).filter(arg_0 -> ((World)otherWorld).func_175667_e(arg_0)).forEach(arg_0 -> TileEntityWirelessRouter.lambda$null$6((World)otherWorld, list, arg_0));
        }));
    }

    private boolean isDifferentRouter(NetworkId thisNetwork, XNetWirelessChannels.WirelessRouterInfo routerInfo) {
        return routerInfo.getCoordinate().getDimension() != this.field_145850_b.field_73011_w.getDimension() || !thisNetwork.equals(routerInfo.getNetworkId());
    }

    private void publishChannels(TileEntityRouter router, NetworkId networkId) {
        int tier = this.getAntennaTier();
        UUID ownerUUID = this.publicAccess ? null : this.getOwnerUUID();
        XNetWirelessChannels wirelessData = XNetWirelessChannels.getWirelessChannels(this.field_145850_b);
        router.publishedChannelStream().forEach(pair -> {
            String name = (String)pair.getKey();
            IChannelType channelType = (IChannelType)pair.getValue();
            long energyStored = this.getStoredPower();
            if ((long)ConfigSetup.wirelessRouterRfPerChannel[tier].get() <= energyStored) {
                this.consumeEnergy(ConfigSetup.wirelessRouterRfPerChannel[tier].get());
                wirelessData.transmitChannel(name, channelType, ownerUUID, this.field_145850_b.field_73011_w.getDimension(), this.field_174879_c, networkId);
            }
        });
    }

    public void addWirelessConnectors(Map<SidedConsumer, IConnectorSettings> connectors, String channelName, IChannelType type, @Nullable UUID owner, @Nonnull Map<WirelessChannelKey, Integer> wirelessVersions) {
        WirelessChannelKey key = new WirelessChannelKey(channelName, type, owner);
        XNetWirelessChannels.WirelessChannelInfo info = XNetWirelessChannels.getWirelessChannels(this.field_145850_b).findChannel(key);
        if (info != null) {
            info.getRouters().keySet().stream().filter(routerPos -> routerPos.getDimension() != this.field_145850_b.field_73011_w.getDimension() || !routerPos.getCoordinate().equals((Object)this.field_174879_c)).filter(routerPos -> WorldTools.chunkLoaded((World)DimensionManager.getWorld((int)routerPos.getDimension()), (BlockPos)routerPos.getCoordinate())).forEach(routerPos -> {
                NetworkId routingNetwork;
                TileEntityWirelessRouter otherRouter;
                WorldServer otherWorld = DimensionManager.getWorld((int)routerPos.getDimension());
                TileEntity otherTE = otherWorld.func_175625_s(routerPos.getCoordinate());
                if (otherTE instanceof TileEntityWirelessRouter && this.inRange(otherRouter = (TileEntityWirelessRouter)otherTE) && !otherRouter.inError() && (routingNetwork = otherRouter.findRoutingNetwork()) != null) {
                    LogicTools.consumers(this.field_145850_b, routingNetwork).forEach(consumerPos -> LogicTools.routers((World)otherWorld, consumerPos).forEach(router -> {
                        if (router.addConnectorsFromConnectedNetworks(connectors, channelName, type)) {
                            wirelessVersions.put(key, info.getVersion());
                        }
                    }));
                }
            });
        }
    }

    private void setError(boolean err) {
        if (this.error != err) {
            this.error = err;
            this.markDirtyClient();
        }
    }

    public boolean inError() {
        return this.error;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        boolean oldError = this.inError();
        super.onDataPacket(net, packet);
        if (this.field_145850_b.field_72995_K && oldError != this.inError()) {
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    @Nullable
    public NetworkId findRoutingNetwork() {
        WorldBlob worldBlob = XNetBlobData.getBlobData(this.field_145850_b).getWorldBlob(this.field_145850_b);
        return LogicTools.routingConnectors(this.field_145850_b, this.func_174877_v()).findFirst().map(worldBlob::getNetworkAt).orElse(null);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        tagCompound.func_74757_a("error", this.error);
        return super.func_189515_b(tagCompound);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.error = tagCompound.func_74767_n("error");
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74757_a("publicAcc", this.publicAccess);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.publicAccess = tagCompound.func_74767_n("publicAcc");
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        XNetBlobData blobData = XNetBlobData.getBlobData(world);
        WorldBlob worldBlob = blobData.getWorldBlob(world);
        Set<NetworkId> networks = worldBlob.getNetworksAt(data.getPos());
        for (NetworkId networkId : networks) {
            probeInfo.text(TextStyleClass.LABEL + "Network: " + TextStyleClass.INFO + networkId.getId());
            if (mode == ProbeMode.EXTENDED) continue;
            break;
        }
        if (this.inError()) {
            probeInfo.text(TextStyleClass.ERROR + "Missing antenna!");
        }
        if (mode == ProbeMode.DEBUG) {
            ColorId colorId;
            BlobId blobId = worldBlob.getBlobAt(data.getPos());
            if (blobId != null) {
                probeInfo.text(TextStyleClass.LABEL + "Blob: " + TextStyleClass.INFO + blobId.getId());
            }
            if ((colorId = worldBlob.getColorAt(data.getPos())) != null) {
                probeInfo.text(TextStyleClass.LABEL + "Color: " + TextStyleClass.INFO + colorId.getId());
            }
        }
    }

    public void onBlockBreak(World world, BlockPos pos, IBlockState state) {
        super.onBlockBreak(world, pos, state);
        if (!this.field_145850_b.field_72995_K) {
            XNetBlobData blobData = XNetBlobData.getBlobData(this.field_145850_b);
            WorldBlob worldBlob = blobData.getWorldBlob(this.field_145850_b);
            worldBlob.removeCableSegment(pos);
            blobData.save();
        }
    }

    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.onBlockPlacedBy(world, pos, state, placer, stack);
        if (!world.field_72995_K) {
            XNetBlobData blobData = XNetBlobData.getBlobData(world);
            WorldBlob worldBlob = blobData.getWorldBlob(world);
            NetworkId networkId = worldBlob.newNetwork();
            worldBlob.createNetworkProvider(pos, new ColorId(CableColor.ROUTING.ordinal() + 1), networkId);
            blobData.save();
        }
    }

    public IBlockState getActualState(IBlockState state) {
        return state.func_177226_a((IProperty)ERROR, (Comparable)Boolean.valueOf(this.inError()));
    }

    private static /* synthetic */ void lambda$null$6(World otherWorld, List list, BlockPos consumerPos) {
        LogicTools.routers(otherWorld, consumerPos).forEach(router -> router.findLocalChannelInfo(list, true, true));
    }

    private /* synthetic */ boolean lambda$inRange$3(World otherWorld, BlockPos consumerPos) {
        return LogicTools.wirelessRouters(otherWorld, consumerPos).anyMatch(this::inRange);
    }

    private static /* synthetic */ boolean lambda$inRange$2(World otherWorld, BlockPos consumerPos) {
        return WorldTools.chunkLoaded((World)otherWorld, (BlockPos)consumerPos);
    }
}

