/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.blocks.facade;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.xnet.blocks.cables.ConnectorTileEntity;
import mcjty.xnet.blocks.cables.NetCableSetup;
import mcjty.xnet.blocks.facade.FacadeBlock;
import mcjty.xnet.blocks.facade.FacadeTileEntity;
import mcjty.xnet.blocks.generic.GenericCableBlock;
import mcjty.xnet.init.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FacadeItemBlock
extends ItemBlock {
    public FacadeItemBlock(FacadeBlock block) {
        super((Block)block);
    }

    public static void setMimicBlock(@Nonnull ItemStack item, IBlockState mimicBlock) {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74778_a("regName", mimicBlock.func_177230_c().getRegistryName().toString());
        tagCompound.func_74768_a("meta", mimicBlock.func_177230_c().func_176201_c(mimicBlock));
        item.func_77982_d(tagCompound);
    }

    public static IBlockState getMimicBlock(@Nonnull ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null || !tagCompound.func_74764_b("regName")) {
            return Blocks.field_150347_e.func_176223_P();
        }
        String regName = tagCompound.func_74779_i("regName");
        int meta = tagCompound.func_74762_e("meta");
        Block value = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(regName));
        return value.func_176203_a(meta);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_179222_a(World worldIn, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_190926_b()) return EnumActionResult.FAIL;
        if (block == NetCableSetup.netCableBlock) {
            FacadeBlock facadeBlock = (FacadeBlock)this.field_150939_a;
            int i = this.func_77647_b(itemstack.func_77960_j());
            IBlockState placementState = facadeBlock.getPlacementState(world, pos, facing, hitX, hitY, hitZ, i, (EntityLivingBase)player).func_177226_a(GenericCableBlock.COLOR, state.func_177229_b(GenericCableBlock.COLOR));
            if (!this.placeBlockAt(itemstack, player, world, pos, facing, hitX, hitY, hitZ, placementState)) return EnumActionResult.SUCCESS;
            SoundType soundtype = world.func_180495_p(pos).func_177230_c().getSoundType(world.func_180495_p(pos), world, pos, (Entity)player);
            world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof FacadeTileEntity) {
                ((FacadeTileEntity)te).setMimicBlock(FacadeItemBlock.getMimicBlock(itemstack));
            }
            int amount = -1;
            itemstack.func_190917_f(amount);
            return EnumActionResult.SUCCESS;
        } else if (block == NetCableSetup.connectorBlock || block == NetCableSetup.advancedConnectorBlock) {
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof ConnectorTileEntity)) return EnumActionResult.SUCCESS;
            ConnectorTileEntity connectorTileEntity = (ConnectorTileEntity)te;
            if (connectorTileEntity.getMimicBlock() != null) return EnumActionResult.FAIL;
            connectorTileEntity.setMimicBlock(FacadeItemBlock.getMimicBlock(itemstack));
            SoundType soundtype = world.func_180495_p(pos).func_177230_c().getSoundType(world.func_180495_p(pos), world, pos, (Entity)player);
            world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            int amount = -1;
            itemstack.func_190917_f(amount);
            return EnumActionResult.SUCCESS;
        } else {
            if (block == ModBlocks.facadeBlock) {
                return EnumActionResult.FAIL;
            }
            FacadeItemBlock.setMimicBlock(itemstack, state);
            if (!world.field_72995_K) return EnumActionResult.SUCCESS;
            player.func_146105_b((ITextComponent)new TextComponentString("Facade is now mimicing " + block.func_149732_F()), false);
        }
        return EnumActionResult.SUCCESS;
    }

    public void func_77624_a(ItemStack stack, @Nullable World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        super.func_77624_a(stack, null, tooltip, advanced);
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null || !tagCompound.func_74764_b("regName")) {
            tooltip.add(TextFormatting.BLUE + "Right or sneak-right click on block to mimic");
            tooltip.add(TextFormatting.BLUE + "Right or sneak-right click on cable/connector to hide");
        } else {
            ItemStack s;
            String regName = tagCompound.func_74779_i("regName");
            int meta = tagCompound.func_74762_e("meta");
            Block value = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(regName));
            if (value != null && (s = new ItemStack(value, 1, meta)).func_77973_b() != null) {
                tooltip.add(TextFormatting.BLUE + "Mimicing " + s.func_82833_r());
            }
        }
    }
}

