/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.guidebook.elements;

import com.google.common.primitives.Ints;
import gigaherz.guidebook.GuidebookMod;
import gigaherz.guidebook.guidebook.BookDocument;
import gigaherz.guidebook.guidebook.IBookGraphics;
import gigaherz.guidebook.guidebook.IConditionSource;
import gigaherz.guidebook.guidebook.drawing.VisualElement;
import gigaherz.guidebook.guidebook.elements.Element;
import gigaherz.guidebook.guidebook.elements.ElementImage;
import gigaherz.guidebook.guidebook.elements.ElementSpan;
import gigaherz.guidebook.guidebook.elements.ElementStack;
import gigaherz.guidebook.guidebook.elements.TextStyle;
import gigaherz.guidebook.guidebook.recipe.RecipeProvider;
import gigaherz.guidebook.guidebook.util.Point;
import gigaherz.guidebook.guidebook.util.Rect;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ElementRecipe
extends Element {
    private ResourceLocation recipeProviderKey = new ResourceLocation("gbook", "shaped");
    private ResourceLocation recipeKey;
    private Element recipeOutput;
    private int recipeIndex = 0;
    private int indent = 0;

    private RecipeProvider.ProvidedComponents retrieveRecipe(RecipeProvider recipeProvider, ElementStack output) {
        if (output == null || output.stacks == null || output.stacks.size() == 0) {
            return null;
        }
        ItemStack targetOutput = (ItemStack)output.stacks.get(0);
        return recipeProvider.provideRecipeComponents(targetOutput, this.recipeIndex);
    }

    private RecipeProvider.ProvidedComponents retrieveRecipe(RecipeProvider recipeProvider, ResourceLocation recipeKey) {
        return recipeProvider.provideRecipeComponents(recipeKey);
    }

    @Override
    public int reflow(List<VisualElement> list, IBookGraphics nav, Rect bounds, Rect pageBounds) {
        RecipeProvider recipeProvider = RecipeProvider.registry.get(this.recipeProviderKey);
        RecipeProvider.ProvidedComponents components = null;
        if (recipeProvider != null && (this.recipeKey != null || this.recipeOutput instanceof ElementStack)) {
            RecipeProvider.ProvidedComponents providedComponents = components = this.recipeKey != null ? this.retrieveRecipe(recipeProvider, this.recipeKey) : this.retrieveRecipe(recipeProvider, (ElementStack)this.recipeOutput);
        }
        if (components == null) {
            ElementSpan s = recipeProvider == null ? ElementSpan.of(String.format("Recipe type specifies a RecipeProvider with key '%s', which hasn't been registered.", this.recipeProviderKey), TextStyle.ERROR) : (this.recipeKey != null ? ElementSpan.of(String.format("Recipe not found for registry name: %s", this.recipeKey), TextStyle.ERROR) : (this.recipeOutput != null ? (this.recipeOutput instanceof ElementStack ? ElementSpan.of("Recipe not found for provided output item.", TextStyle.ERROR) : ElementSpan.of("Recipe output is not a stack element.", TextStyle.ERROR)) : ElementSpan.of("Recipe name or output not provided, could not identify recipe.", TextStyle.ERROR)));
            return s.reflow(list, nav, bounds, pageBounds);
        }
        ElementImage background = components.background;
        VisualElement additionalRenderer = components.delegate;
        ElementStack[] ingredients = components.recipeComponents;
        int height = this.h != 0 ? this.h : components.height;
        Point adjustedPosition = this.applyPosition(bounds.position, bounds.position);
        Rect adjustedBounds = new Rect(adjustedPosition, bounds.size);
        for (int i = 0; i < ingredients.length; ++i) {
            ingredients[i].reflow(list, nav, adjustedBounds, pageBounds);
        }
        background.reflow(list, nav, adjustedBounds, pageBounds);
        if (additionalRenderer != null) {
            list.add(additionalRenderer);
        }
        if (this.position != 0) {
            return bounds.position.y;
        }
        return adjustedPosition.y + height;
    }

    @Override
    public void parse(IConditionSource book, NamedNodeMap attributes) {
        Integer recipeIndexObj;
        Integer indentObj;
        Node attr = attributes.getNamedItem("type");
        if (attr != null) {
            String registryName = attr.getTextContent();
            this.recipeProviderKey = new ResourceLocation((registryName.indexOf(58) == -1 ? "gbook:" : "") + registryName);
        }
        if ((attr = attributes.getNamedItem("key")) != null) {
            this.recipeKey = new ResourceLocation(attr.getTextContent());
        }
        if ((attr = attributes.getNamedItem("indent")) != null && (indentObj = Ints.tryParse((String)attr.getTextContent())) != null) {
            this.indent = indentObj;
        }
        if ((attr = attributes.getNamedItem("index")) != null && (recipeIndexObj = Ints.tryParse((String)attr.getTextContent())) != null) {
            this.recipeIndex = recipeIndexObj;
        }
    }

    @Override
    public void parseChildNodes(IConditionSource book, Node element) {
        for (int i = 0; i < element.getChildNodes().getLength(); ++i) {
            Node childNode = element.getChildNodes().item(i);
            String nodeName = childNode.getNodeName();
            if (!nodeName.equals("recipe.result")) continue;
            if (childNode.hasChildNodes()) {
                for (int j = 0; j < childNode.getChildNodes().getLength(); ++j) {
                    Node stackNode = childNode.getChildNodes().item(j);
                    String stackNodeName = stackNode.getNodeName();
                    if (!stackNodeName.equals("stack") && !stackNodeName.equals("element")) continue;
                    this.recipeOutput = BookDocument.parseParagraphElement(book, stackNode, stackNodeName, false, false, TextStyle.DEFAULT);
                }
                continue;
            }
            GuidebookMod.logger.warn("<recipe.result> sub-node is empty; Must contain exactly one <stack> node child");
        }
    }

    @Override
    public String toString(boolean complete) {
        return "<recipe .../>";
    }

    @Override
    @Nullable
    public Element applyTemplate(IConditionSource book, List<Element> sourceElements) {
        ElementRecipe elementRecipe = super.copy(new ElementRecipe());
        if (this.recipeOutput != null) {
            elementRecipe.recipeOutput = this.recipeOutput.applyTemplate(book, sourceElements);
        }
        elementRecipe.recipeIndex = this.recipeIndex;
        if (this.recipeKey != null) {
            elementRecipe.recipeKey = new ResourceLocation(this.recipeKey.toString());
        }
        elementRecipe.indent = this.indent;
        return elementRecipe;
    }

    @Override
    public Element copy() {
        ElementRecipe elementRecipe = super.copy(new ElementRecipe());
        if (this.recipeOutput != null) {
            elementRecipe.recipeOutput = this.recipeOutput.copy();
        }
        elementRecipe.recipeIndex = this.recipeIndex;
        if (this.recipeKey != null) {
            elementRecipe.recipeKey = new ResourceLocation(this.recipeKey.toString());
        }
        elementRecipe.indent = this.indent;
        return elementRecipe;
    }

    @Override
    public boolean supportsPageLevel() {
        return true;
    }

    @Override
    public boolean supportsSpanLevel() {
        return false;
    }
}

