/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.guidebook.drawing;

import gigaherz.guidebook.guidebook.HoverContext;
import gigaherz.guidebook.guidebook.IBookGraphics;
import gigaherz.guidebook.guidebook.SectionRef;
import gigaherz.guidebook.guidebook.drawing.VisualElement;
import gigaherz.guidebook.guidebook.util.Size;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class VisualStack
extends VisualElement {
    public static final int CYCLE_TIME = 1000;
    public ItemStack[] stacks;
    public float scale = 1.0f;
    public int z;

    public VisualStack(NonNullList<ItemStack> stacks, Size size, int positionMode, float baseline, int verticalAlign, float scale, int z) {
        super(size, positionMode, baseline, verticalAlign);
        this.stacks = (ItemStack[])stacks.toArray((Object[])new ItemStack[0]);
        this.scale = scale;
        this.z = z;
    }

    public ItemStack getCurrentStack() {
        if (this.stacks == null || this.stacks.length == 0) {
            return ItemStack.field_190927_a;
        }
        long time = System.currentTimeMillis();
        return this.stacks[(int)(time / 1000L % (long)this.stacks.length)];
    }

    @Override
    public void draw(IBookGraphics nav) {
        super.draw(nav);
        ItemStack stack = this.getCurrentStack();
        if (stack.func_190916_E() > 0) {
            nav.drawItemStack(this.position.x, this.position.y, this.z, stack, -1, this.scale);
        }
    }

    @Override
    public boolean wantsHover() {
        return true;
    }

    @Override
    public void mouseOver(IBookGraphics nav, HoverContext hoverContext) {
        ItemStack stack = this.getCurrentStack();
        if (stack.func_190916_E() > 0) {
            nav.drawTooltip(stack, hoverContext.mouseX, hoverContext.mouseY);
        }
    }

    @Override
    public void click(IBookGraphics nav) {
        SectionRef ref = nav.getBook().getStackLink(this.getCurrentStack());
        if (ref != null) {
            nav.navigateTo(ref);
        }
    }
}

