/*
 * Decompiled with CFR 0.152.
 */
package rustic.compat.dynamictrees.trees;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.treedata.IDropCreator;
import com.ferreusveritas.dynamictrees.blocks.BlockSurfaceRoot;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenClearVolume;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenFlareBottom;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenMound;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenRoots;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import rustic.common.blocks.BlockLeavesRustic;
import rustic.common.blocks.BlockLogRustic;
import rustic.common.blocks.BlockPlanksRustic;
import rustic.common.blocks.ModBlocks;
import rustic.common.items.ModItems;
import rustic.compat.dynamictrees.DropCreatorFruit;
import rustic.compat.dynamictrees.DynamicTreesCompat;

public class TreeIronwood
extends TreeFamily {
    BlockSurfaceRoot surfaceRootBlock;

    public TreeIronwood() {
        super(new ResourceLocation("rustic", "ironwood"));
        IBlockState primLog = ModBlocks.LOG.func_176223_P().func_177226_a(BlockLogRustic.VARIANT, (Comparable)((Object)BlockPlanksRustic.EnumType.IRONWOOD));
        this.setPrimitiveLog(primLog, new ItemStack((Block)ModBlocks.LOG, 1, BlockPlanksRustic.EnumType.IRONWOOD.getMetadata()));
        DynamicTreesCompat.ironwoodLeavesProperties.setTree((TreeFamily)this);
        this.surfaceRootBlock = new BlockSurfaceRoot(Material.field_151575_d, this.getName() + "root");
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() instanceof BlockLeavesRustic && state.func_177229_b((IProperty)BlockLeavesRustic.VARIANT) == BlockPlanksRustic.EnumType.IRONWOOD);
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesIronwood(this));
    }

    public List<Block> getRegisterableBlocks(List<Block> blockList) {
        blockList.add((Block)this.surfaceRootBlock);
        return super.getRegisterableBlocks(blockList);
    }

    public boolean isThick() {
        return true;
    }

    public BlockSurfaceRoot getSurfaceRoots() {
        return this.surfaceRootBlock;
    }

    public class SpeciesIronwood
    extends Species {
        SpeciesIronwood(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, DynamicTreesCompat.ironwoodLeavesProperties);
            this.setBasicGrowingParameters(0.4f, 14.0f, 4, 4, 1.0f);
            this.envFactor(BiomeDictionary.Type.COLD, 0.5f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.5f);
            this.envFactor(BiomeDictionary.Type.HOT, 0.75f);
            this.envFactor(BiomeDictionary.Type.FOREST, 1.05f);
            this.generateSeed();
            this.setupStandardSeedDropping();
            this.addDropCreator((IDropCreator)new DropCreatorFruit((Item)ModItems.IRONBERRIES, 48));
            this.addGenFeature((IGenFeature)new FeatureGenClearVolume(6));
            this.addGenFeature((IGenFeature)new FeatureGenFlareBottom());
            this.addGenFeature((IGenFeature)new FeatureGenMound(5));
            this.addGenFeature((IGenFeature)new FeatureGenRoots(11).setScaler(this.getRootScaler()));
        }

        protected BiFunction<Integer, Integer, Integer> getRootScaler() {
            return (inRadius, trunkRadius) -> {
                float scale = MathHelper.func_76131_a((float)(trunkRadius >= 11 ? (float)trunkRadius.intValue() / 20.0f : 0.0f), (float)0.0f, (float)1.0f);
                return (int)((float)inRadius.intValue() * scale);
            };
        }

        public boolean isBiomePerfect(Biome biome) {
            return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST);
        }

        public boolean isThick() {
            return true;
        }
    }
}

