/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rustic.common.crafting.CondenserRecipe;
import rustic.common.crafting.Recipes;
import rustic.common.items.IColoredItem;
import rustic.common.items.ItemBase;
import rustic.common.util.ElixirUtils;
import rustic.core.ClientProxy;
import rustic.core.Rustic;

public class ItemElixir
extends ItemBase
implements IColoredItem {
    public ItemElixir() {
        super("elixir");
        this.func_77637_a(Rustic.alchemyTab);
        this.func_77625_d(16);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        for (CondenserRecipe recipe : Recipes.condenserRecipes) {
            if (subItems.contains((Object)recipe.getResult()) || !this.func_194125_a(tab)) continue;
            subItems.add((Object)recipe.getResult());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack func_190903_i() {
        ItemStack stack = super.func_190903_i();
        ElixirUtils.addEffect(new PotionEffect(MobEffects.field_76432_h, 1, 0), stack);
        return stack;
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        EntityPlayer entityplayer;
        EntityPlayer entityPlayer = entityplayer = entityLiving instanceof EntityPlayer ? (EntityPlayer)entityLiving : null;
        if (!worldIn.field_72995_K) {
            for (PotionEffect potioneffect : ElixirUtils.getEffects(stack)) {
                if (potioneffect.func_188419_a().func_76403_b()) {
                    potioneffect.func_188419_a().func_180793_a((Entity)entityplayer, (Entity)entityplayer, entityLiving, potioneffect.func_76458_c(), 1.0);
                    continue;
                }
                entityLiving.func_70690_d(new PotionEffect(potioneffect));
            }
        }
        if (entityplayer != null) {
            entityplayer.func_71029_a(StatList.func_188057_b((Item)this));
        }
        if (entityplayer != null && !entityplayer.field_71075_bZ.field_75098_d && !entityplayer.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo))) {
            entityplayer.func_71019_a(new ItemStack(Items.field_151069_bo), false);
        }
        if (entityplayer == null || !entityplayer.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        return 24;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    public String func_77653_i(ItemStack stack) {
        String name = I18n.func_74838_a((String)"rustic.elixir.prefix");
        int i = 0;
        List<PotionEffect> effects = ElixirUtils.getEffects(stack);
        for (PotionEffect effect : effects) {
            name = name + I18n.func_74838_a((String)effect.func_76453_d());
            if (i < effects.size() - 1) {
                name = name + I18n.func_74838_a((String)"rustic.elixir.separator");
            }
            ++i;
        }
        return name;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        ElixirUtils.addPotionTooltip(stack, tooltip, 1.0f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                if (tintIndex == 0) {
                    return ElixirUtils.getColor(stack);
                }
                return 0xFFFFFF;
            }
        };
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        super.initModel();
        ClientProxy.addColoredItem(this);
    }
}

