/*
 * Decompiled with CFR 0.152.
 */
package rustic.client.renderer;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.lwjgl.opengl.GL11;
import rustic.client.util.FluidClientUtil;
import rustic.common.tileentity.TileEntityCrushingTub;

public class CrushingTubRenderer
extends TileEntitySpecialRenderer<TileEntityCrushingTub> {
    int blue;
    int green;
    int red;
    int a;
    int lightx;
    int lighty;
    double minU;
    double minV;
    double maxU;
    double maxV;
    double diffU;
    double diffV;

    public void render(TileEntityCrushingTub te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        TileEntityCrushingTub tank = te;
        IItemHandler itemStackHandler = (IItemHandler)tank.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (itemStackHandler.getSlots() > 0 && !itemStackHandler.getStackInSlot(0).func_190926_b() && tank.func_145831_w() != null) {
            ItemStack stack = itemStackHandler.getStackInSlot(0);
            int itemCount = (int)Math.ceil((double)stack.func_190916_E() / 8.0);
            Random rand = new Random();
            rand.setSeed(tank.func_145831_w().func_72905_C());
            for (int i = 0; i < itemCount; ++i) {
                GL11.glPushMatrix();
                RenderHelper.func_74519_b();
                GlStateManager.func_179145_e();
                GL11.glTranslated((double)x, (double)(y + 0.062 + (double)i * 0.0625), (double)z);
                GL11.glTranslated((double)0.5, (double)0.0, (double)0.5);
                GL11.glRotated((double)((double)rand.nextFloat() * 360.0), (double)0.0, (double)1.0, (double)0.0);
                GL11.glTranslated((double)-0.5, (double)0.0, (double)-0.5);
                GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                GL11.glTranslated((double)0.5, (double)-0.1875, (double)0.0);
                GL11.glTranslated((double)0.0, (double)0.6875, (double)0.0);
                GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
                Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.NONE);
                GL11.glPopMatrix();
            }
        }
        int amount = tank.getAmount();
        int capacity = tank.getCapacity();
        Fluid fluid = tank.getFluid();
        if (fluid != null) {
            int c = fluid.getColor();
            this.blue = c & 0xFF;
            this.green = c >> 8 & 0xFF;
            this.red = c >> 16 & 0xFF;
            this.a = c >> 24 & 0xFF;
            TextureAtlasSprite sprite = FluidClientUtil.stillTextures.get(fluid);
            if (sprite == null) {
                return;
            }
            this.diffU = this.maxU - this.minU;
            this.diffV = this.maxV - this.minV;
            this.minU = (double)sprite.func_94209_e() + this.diffU * 0.0625;
            this.maxU = (double)sprite.func_94212_f() - this.diffU * 0.0625;
            this.minV = (double)sprite.func_94206_g() + this.diffV * 0.0625;
            this.maxV = (double)sprite.func_94210_h() - this.diffV * 0.0625;
            int i = this.func_178459_a().func_175626_b(te.func_174877_v(), fluid.getLuminosity());
            this.lightx = i >> 16 & 0xFFFF;
            this.lighty = i & 0xFFFF;
            GlStateManager.func_179123_a();
            GlStateManager.func_179129_p();
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_179141_d();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            Tessellator tess = Tessellator.func_178181_a();
            BufferBuilder buffer = tess.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181711_k);
            buffer.func_181662_b(x + 0.0625, y + 0.0625 + 0.5 * (double)((float)amount / (float)capacity), z + 0.0625).func_187315_a(this.minU, this.minV).func_187314_a(this.lightx, this.lighty).func_181669_b(this.red, this.green, this.blue, this.a).func_181675_d();
            buffer.func_181662_b(x + 0.9375, y + 0.0625 + 0.5 * (double)((float)amount / (float)capacity), z + 0.0625).func_187315_a(this.maxU, this.minV).func_187314_a(this.lightx, this.lighty).func_181669_b(this.red, this.green, this.blue, this.a).func_181675_d();
            buffer.func_181662_b(x + 0.9375, y + 0.0625 + 0.5 * (double)((float)amount / (float)capacity), z + 0.9375).func_187315_a(this.maxU, this.maxV).func_187314_a(this.lightx, this.lighty).func_181669_b(this.red, this.green, this.blue, this.a).func_181675_d();
            buffer.func_181662_b(x + 0.0625, y + 0.0625 + 0.5 * (double)((float)amount / (float)capacity), z + 0.9375).func_187315_a(this.minU, this.maxV).func_187314_a(this.lightx, this.lighty).func_181669_b(this.red, this.green, this.blue, this.a).func_181675_d();
            tess.func_78381_a();
            GlStateManager.func_179118_c();
            GlStateManager.func_179084_k();
            GlStateManager.func_179145_e();
            GlStateManager.func_179089_o();
            GlStateManager.func_179099_b();
        }
    }
}

