/*
 * Decompiled with CFR 0.152.
 */
package rustic.client.renderer;

import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import rustic.client.models.ModelCabinet;
import rustic.client.models.ModelCabinetDouble;
import rustic.client.util.ItemColorCache;
import rustic.common.blocks.BlockCabinet;
import rustic.common.blocks.ModBlocks;
import rustic.common.tileentity.TileEntityCabinet;

public class CabinetRenderer
extends TileEntitySpecialRenderer<TileEntityCabinet> {
    protected static final ResourceLocation TEXTURE_NORMAL = new ResourceLocation("rustic:textures/models/cabinet.png");
    protected static final ResourceLocation TEXTURE_DOUBLE = new ResourceLocation("rustic:textures/models/cabinet_double.png");
    protected static final ResourceLocation TEXTURE_NORMAL_COLOR = new ResourceLocation("rustic:textures/models/cabinet_color.png");
    protected static final ResourceLocation TEXTURE_DOUBLE_COLOR = new ResourceLocation("rustic:textures/models/cabinet_double_color.png");
    protected final ModelCabinet simpleCabinet = new ModelCabinet(false);
    protected final ModelCabinet simpleCabinetM = new ModelCabinet(true);
    protected final ModelCabinetDouble doubleCabinet = new ModelCabinetDouble(false);
    protected final ModelCabinetDouble doubleCabinetM = new ModelCabinetDouble(true);

    public void render(TileEntityCabinet te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        GlStateManager.func_179126_j();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
        if (te.func_145830_o() && te.func_145831_w().func_180495_p(te.func_174877_v()).func_177230_c() == ModBlocks.CABINET && !((Boolean)te.func_145831_w().func_180495_p(te.func_174877_v()).func_177229_b((IProperty)BlockCabinet.TOP)).booleanValue()) {
            ItemStack material = te.material;
            boolean mirror = (Boolean)te.func_145831_w().func_180495_p(te.func_174877_v()).func_177229_b((IProperty)BlockCabinet.MIRROR);
            boolean renderDouble = (Boolean)te.func_145831_w().func_180495_p(te.func_174877_v()).func_185899_b((IBlockAccess)te.func_145831_w(), te.func_174877_v()).func_177229_b((IProperty)BlockCabinet.BOTTOM);
            boolean useColoredTexture = material.func_190926_b();
            ModelBase modelcabinet = this.simpleCabinet;
            this.func_147499_a(useColoredTexture ? TEXTURE_NORMAL_COLOR : TEXTURE_NORMAL);
            if (mirror) {
                modelcabinet = this.simpleCabinetM;
            }
            if (renderDouble) {
                modelcabinet = this.doubleCabinet;
                this.func_147499_a(useColoredTexture ? TEXTURE_DOUBLE_COLOR : TEXTURE_DOUBLE);
                if (mirror) {
                    modelcabinet = this.doubleCabinetM;
                }
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179091_B();
            if (!useColoredTexture) {
                int color = ItemColorCache.INSTANCE.getColor(material);
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)alpha);
            } else {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            }
            GlStateManager.func_179109_b((float)((float)x), (float)((float)y + 1.0f), (float)((float)z + 1.0f));
            GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
            int rotation = 0;
            switch ((EnumFacing)te.func_145831_w().func_180495_p(te.func_174877_v()).func_177229_b((IProperty)BlockCabinet.FACING)) {
                case WEST: {
                    rotation = 90;
                    break;
                }
                case NORTH: {
                    rotation = 180;
                    break;
                }
                case EAST: {
                    rotation = 270;
                    break;
                }
            }
            GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
            float f = te.prevLidAngle + (te.lidAngle - te.prevLidAngle) * partialTicks;
            f = 1.0f - f;
            f = 1.0f - f * f * f;
            if (renderDouble) {
                ((ModelCabinetDouble)modelcabinet).setRotation(((ModelCabinetDouble)modelcabinet).door, 0.0f, mirror ? -(f * 1.5707964f) : f * 1.5707964f, 0.0f);
            } else {
                ((ModelCabinet)modelcabinet).setRotation(((ModelCabinet)modelcabinet).door, 0.0f, mirror ? -(f * 1.5707964f) : f * 1.5707964f, 0.0f);
            }
            GlStateManager.func_179109_b((float)0.5f, (float)-0.5f, (float)0.5f);
            if (renderDouble) {
                ((ModelCabinetDouble)modelcabinet).renderAll();
            } else {
                ((ModelCabinet)modelcabinet).renderAll();
            }
            GlStateManager.func_179101_C();
            GlStateManager.func_179121_F();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static class CabinetTEISR
    extends TileEntityItemStackRenderer {
        private static ModelCabinet model = new ModelCabinet(false);

        public void func_192838_a(ItemStack stack, float partialTicks) {
            GlStateManager.func_179126_j();
            GlStateManager.func_179143_c((int)515);
            GlStateManager.func_179132_a((boolean)true);
            ItemStack material = ItemStack.field_190927_a;
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("material")) {
                material = new ItemStack(stack.func_77978_p().func_74775_l("material"));
            }
            boolean useColoredTexture = material.func_190926_b();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(useColoredTexture ? TEXTURE_NORMAL_COLOR : TEXTURE_NORMAL);
            GlStateManager.func_179094_E();
            GlStateManager.func_179091_B();
            if (!useColoredTexture) {
                int color = ItemColorCache.INSTANCE.getColor(material);
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)1.0f);
            } else {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            GlStateManager.func_179109_b((float)0.0f, (float)2.0f, (float)1.0f);
            GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
            GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
            model.renderAll();
            GlStateManager.func_179101_C();
            GlStateManager.func_179121_F();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

