/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.multimob.spawn;

import java.util.List;
import java.util.Set;
import net.daveyx0.multimob.core.MMEntityRegistry;
import net.daveyx0.multimob.core.MultiMob;
import net.daveyx0.multimob.spawn.MMSpawnEntry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class MMSpawnChecks {
    private static final int distanceCheck = 10;
    private static boolean enableDebug = false;

    public static boolean performSpawnChecks(WorldServer worldIn, BlockPos pos, MMSpawnEntry entry) {
        if (!entry.getIsAllowedToSpawn()) {
            MMSpawnChecks.debug(entry, 0, pos, enableDebug);
            return false;
        }
        if (!MMSpawnChecks.isWithinWorldBorder((World)worldIn, pos)) {
            MMSpawnChecks.debug(entry, 1, pos, enableDebug);
            return false;
        }
        if (!entry.getIsAllowedOnPeaceful() && worldIn.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            MMSpawnChecks.debug(entry, 2, pos, enableDebug);
            return false;
        }
        if (!MMSpawnChecks.isLuckyEnoughToSpawn((World)worldIn, entry.getAdditionalRarity())) {
            MMSpawnChecks.debug(entry, 3, pos, enableDebug);
            return false;
        }
        if (!MMSpawnChecks.isDimensionSuitable((World)worldIn, entry.getDimensions())) {
            MMSpawnChecks.debug(entry, 4, pos, enableDebug);
            return false;
        }
        if (!MMSpawnChecks.isWeatherConditionSuitable((World)worldIn, pos, entry.getWeatherCondition())) {
            MMSpawnChecks.debug(entry, 19, pos, enableDebug);
            return false;
        }
        if (!MMSpawnChecks.isInsideSuitableStructure(worldIn, pos, entry.getStructures())) {
            MMSpawnChecks.debug(entry, 7, pos, enableDebug);
            return false;
        }
        if (entry.getNeedsToSeeSky() && !MMSpawnChecks.canPositionSeeSky((World)worldIn, pos)) {
            MMSpawnChecks.debug(entry, 18, pos, enableDebug);
            return false;
        }
        if (!MMSpawnChecks.isHeightLevelSuitable(pos, entry.getHeightLevelRange()[0], entry.getHeightLevelRange()[1])) {
            MMSpawnChecks.debug(entry, 9, pos, enableDebug);
            return false;
        }
        if (!MMSpawnChecks.isLightLevelSuitable((World)worldIn, pos, entry.getLightLevelRange()[0], entry.getLightLevelRange()[1])) {
            MMSpawnChecks.debug(entry, 10, pos, enableDebug);
            return false;
        }
        if (entry.getNeedsMoreSpace() && !MMSpawnChecks.hasLoadsOfSpaceAbove((World)worldIn, pos)) {
            MMSpawnChecks.debug(entry, 11, pos, enableDebug);
            return false;
        }
        if (!MMSpawnChecks.isNearEntity((World)worldIn, pos, entry.getEntitiesNearList(), 10.0)) {
            MMSpawnChecks.debug(entry, 12, pos, enableDebug);
            return false;
        }
        if (!MMSpawnChecks.isNearBlock((World)worldIn, pos, entry.getBlocksNearList(), 10)) {
            MMSpawnChecks.debug(entry, 13, pos, enableDebug);
            return false;
        }
        return true;
    }

    public static boolean canEntitySpawnHere(Entity entity, MMSpawnEntry entry) {
        if (entity == null || !(entity instanceof EntityLiving) || MMEntityRegistry.entities.containsKey(entity.getClass()) && !MMEntityRegistry.entities.get(entity.getClass()).booleanValue()) {
            return false;
        }
        BlockPos pos = entity.func_180425_c();
        EntityLiving entityLiving = (EntityLiving)entity;
        if (!entityLiving.func_70058_J()) {
            MMSpawnChecks.debug(entry, 14, pos, enableDebug);
            return false;
        }
        if (!entry.getOverrideCanGetSpawnHere()) {
            return entityLiving.func_70601_bi();
        }
        if (!MMSpawnChecks.canSpawnOnBlock(entity, entry.getSpawnBlocksList())) {
            MMSpawnChecks.debug(entry, 15, pos, enableDebug);
            return false;
        }
        if (!MMSpawnChecks.checkCanEntitySpawnOnBlockState(entity)) {
            MMSpawnChecks.debug(entry, 16, pos, enableDebug);
            return false;
        }
        if (entity instanceof EntityCreature && !MMSpawnChecks.checkBlockPathWeight((EntityCreature)entity)) {
            MMSpawnChecks.debug(entry, 17, pos, enableDebug);
            return false;
        }
        return true;
    }

    public static boolean isInsideSuitableStructure(WorldServer worldIn, BlockPos pos, List<String> structures) {
        if (structures == null || structures.isEmpty()) {
            return true;
        }
        for (String entry : structures) {
            if (!worldIn.func_72863_F().func_193413_a((World)worldIn, entry, pos)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWeatherConditionSuitable(World worldIn, BlockPos pos, MMSpawnEntry.WeatherCondition condition) {
        if (condition == MMSpawnEntry.WeatherCondition.NONE) {
            return true;
        }
        if (condition == MMSpawnEntry.WeatherCondition.GENERAL_DOWNFALL) {
            return worldIn.func_72896_J();
        }
        if (condition == MMSpawnEntry.WeatherCondition.THUNDERSTORM) {
            return worldIn.func_72911_I();
        }
        if (condition == MMSpawnEntry.WeatherCondition.RAIN || condition == MMSpawnEntry.WeatherCondition.SNOW) {
            return MMSpawnChecks.isDownfallAtPosition(worldIn, pos, condition);
        }
        return false;
    }

    public static boolean isWithinWorldBorder(World worldIn, BlockPos pos) {
        return worldIn.func_175723_af().func_177746_a(pos);
    }

    public static boolean isHeightLevelSuitable(BlockPos pos, int min, int max) {
        if (min <= -1 && max <= -1) {
            return true;
        }
        if (min <= -1) {
            return pos.func_177956_o() <= max;
        }
        if (max <= -1) {
            return pos.func_177956_o() >= min;
        }
        return pos.func_177956_o() >= min && pos.func_177956_o() <= max;
    }

    public static boolean isLightLevelSuitable(World worldIn, BlockPos pos, int min, int max) {
        if (min == -1 && max == -1) {
            return true;
        }
        if (min == -2 && max == -2) {
            return MMSpawnChecks.isValidMobLightLevel(worldIn, pos);
        }
        if (min <= -1) {
            return worldIn.func_175699_k(pos) <= max;
        }
        if (max <= -1) {
            return worldIn.func_175699_k(pos) >= min;
        }
        return worldIn.func_175699_k(pos) >= min && worldIn.func_175699_k(pos) <= max;
    }

    public static boolean isNearEntity(World worldIn, BlockPos pos, List<Class<? extends Entity>> entities, double distance) {
        if (entities == null || entities.isEmpty() || distance <= -1.0) {
            return true;
        }
        for (Entity entity : worldIn.func_72910_y()) {
            double d0;
            if (entity == null || !entities.contains(entity.getClass()) || !((d0 = entity.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p())) < 0.0) && !(d0 < distance * distance)) continue;
            entities.remove(entity.getClass());
        }
        return entities.isEmpty();
    }

    public static boolean isNearBlock(World worldIn, BlockPos pos, List<IBlockState> blockstates, int searchLength) {
        if (blockstates == null || blockstates.isEmpty() || searchLength <= -1) {
            return true;
        }
        int i = searchLength;
        boolean j = true;
        int k = 0;
        while (k <= 1) {
            for (int l = 0; l < i; ++l) {
                int i1 = 0;
                while (i1 <= l) {
                    int j1;
                    int n = j1 = i1 < l && i1 > -l ? l : 0;
                    while (j1 <= l) {
                        BlockPos blockpos1 = pos.func_177982_a(i1, k, j1);
                        if (blockstates.contains(worldIn.func_180495_p(blockpos1))) {
                            blockstates.remove(worldIn.func_180495_p(blockpos1));
                        }
                        j1 = j1 > 0 ? -j1 : 1 - j1;
                    }
                    i1 = i1 > 0 ? -i1 : 1 - i1;
                }
            }
            k = k > 0 ? -k : 1 - k;
        }
        return blockstates.isEmpty();
    }

    public static boolean isLuckyEnoughToSpawn(World worldIn, int chance) {
        if (chance <= -1) {
            return true;
        }
        return worldIn.field_73012_v.nextInt(chance) == 0;
    }

    public static boolean isBiomeSuitable(World worldIn, BlockPos pos, List<Biome> biomes) {
        if (biomes == null || biomes.isEmpty()) {
            return true;
        }
        return biomes.contains(worldIn.func_180494_b(pos));
    }

    public static boolean isBiomeTypeSuitable(World worldIn, BlockPos pos, List<BiomeDictionary.Type> types) {
        if (types == null || types.isEmpty()) {
            return true;
        }
        Biome biome = worldIn.func_180494_b(pos);
        if (!BiomeDictionary.hasAnyType((Biome)biome)) {
            return false;
        }
        Set biomeTypes = BiomeDictionary.getTypes((Biome)biome);
        for (BiomeDictionary.Type type : types) {
            if (biomeTypes.contains(type)) continue;
            return false;
        }
        return true;
    }

    public static boolean isDimensionSuitable(World worldIn, List<Integer> ids) {
        if (ids == null || ids.isEmpty()) {
            return worldIn.field_73011_w.getDimension() == 0;
        }
        return ids.contains(worldIn.field_73011_w.getDimension());
    }

    public static boolean isAllowedToSpawnOnPeaceful(World worldIn, boolean check) {
        return check ? true : worldIn.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    public static boolean canCreatureTypeSpawnHere(World worldIn, BlockPos pos, EntityLiving.SpawnPlacementType spawnType) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        if (spawnType == MultiMob.IN_LAVA) {
            return iblockstate.func_185904_a() == Material.field_151587_i && worldIn.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151587_i && !worldIn.func_180495_p(pos.func_177984_a()).func_185915_l();
        }
        if (spawnType == EntityLiving.SpawnPlacementType.IN_WATER) {
            return iblockstate.func_185904_a() == Material.field_151586_h && worldIn.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151586_h && !worldIn.func_180495_p(pos.func_177984_a()).func_185915_l();
        }
        BlockPos blockpos = pos.func_177977_b();
        IBlockState state = worldIn.func_180495_p(blockpos);
        if (!state.func_177230_c().canCreatureSpawn(state, (IBlockAccess)worldIn, blockpos, spawnType)) {
            return false;
        }
        Block block = worldIn.func_180495_p(blockpos).func_177230_c();
        boolean flag = block != Blocks.field_150357_h && block != Blocks.field_180401_cv;
        return flag && WorldEntitySpawner.func_185331_a((IBlockState)iblockstate) && WorldEntitySpawner.func_185331_a((IBlockState)worldIn.func_180495_p(pos.func_177984_a()));
    }

    public static boolean hasLoadsOfSpaceAbove(World worldIn, BlockPos pos) {
        return MMSpawnChecks.check3x3IsAirBlock(worldIn, pos.func_177984_a()) && MMSpawnChecks.check3x3IsAirBlock(worldIn, pos.func_177981_b(2));
    }

    public static boolean check3x3IsAirBlock(World worldIn, BlockPos pos) {
        return worldIn.func_175623_d(pos) && worldIn.func_175623_d(pos.func_177976_e()) && worldIn.func_175623_d(pos.func_177976_e().func_177978_c()) && worldIn.func_175623_d(pos.func_177976_e().func_177968_d()) && worldIn.func_175623_d(pos.func_177974_f()) && worldIn.func_175623_d(pos.func_177974_f().func_177978_c()) && worldIn.func_175623_d(pos.func_177974_f().func_177968_d()) && worldIn.func_175623_d(pos.func_177978_c()) && worldIn.func_175623_d(pos.func_177968_d());
    }

    protected static boolean isValidMobLightLevel(World worldIn, BlockPos pos) {
        if (worldIn.func_175642_b(EnumSkyBlock.SKY, pos) > worldIn.field_73012_v.nextInt(32)) {
            return false;
        }
        int i = worldIn.func_175671_l(pos);
        if (worldIn.func_72911_I()) {
            int j = worldIn.func_175657_ab();
            worldIn.func_175692_b(10);
            i = worldIn.func_175671_l(pos);
            worldIn.func_175692_b(j);
        }
        return i <= worldIn.field_73012_v.nextInt(8);
    }

    public static boolean canPositionSeeSky(World worldIn, BlockPos pos) {
        return worldIn.func_175710_j(pos);
    }

    public static boolean checkCanEntitySpawnOnBlockState(Entity entity) {
        IBlockState iblockstate = entity.field_70170_p.func_180495_p(new BlockPos(entity).func_177977_b());
        return iblockstate.func_189884_a(entity);
    }

    public static boolean checkBlockPathWeight(EntityCreature creature) {
        return creature.func_180484_a(new BlockPos(creature.field_70165_t, creature.func_174813_aQ().field_72338_b, creature.field_70161_v)) >= 0.0f;
    }

    public static boolean canSpawnOnBlock(Entity entity, List<IBlockState> blockstates) {
        if (blockstates == null || blockstates.isEmpty()) {
            return true;
        }
        int i = MathHelper.func_76128_c((double)entity.field_70165_t);
        int j = MathHelper.func_76128_c((double)entity.func_174813_aQ().field_72338_b);
        int k = MathHelper.func_76128_c((double)entity.field_70161_v);
        BlockPos blockpos = new BlockPos(i, j, k);
        return blockstates.contains(entity.field_70170_p.func_180495_p(blockpos.func_177977_b()));
    }

    public static boolean isDownfallAtPosition(World worldIn, BlockPos position, MMSpawnEntry.WeatherCondition condition) {
        if (!worldIn.func_72896_J()) {
            return false;
        }
        if (!worldIn.func_175678_i(position)) {
            return false;
        }
        if (worldIn.func_175725_q(position).func_177956_o() > position.func_177956_o()) {
            return false;
        }
        Biome biome = worldIn.func_180494_b(position);
        if (condition == MMSpawnEntry.WeatherCondition.RAIN) {
            return biome.func_76738_d();
        }
        if (condition == MMSpawnEntry.WeatherCondition.SNOW) {
            return biome.func_76746_c() && worldIn.func_175708_f(position, false);
        }
        return true;
    }

    private static void debug(MMSpawnEntry entry, int context, BlockPos pos, boolean allow) {
        if (!allow) {
            return;
        }
        String message = entry.getEntryName() + " failed to spawn at " + pos.toString() + " due to ";
        switch (context) {
            case 0: {
                message = message + "the entry not being allowed to spawn.";
                break;
            }
            case 1: {
                message = message + "the position being outside of the world border.";
                break;
            }
            case 2: {
                message = message + "the entry not being allowed to spawn on Peaceful.";
                break;
            }
            case 3: {
                message = message + "the entry not being lucky enough to spawn.";
                break;
            }
            case 4: {
                message = message + "the dimension not being suitable.";
                break;
            }
            case 5: {
                message = message + "the biome type not being suitable.";
                break;
            }
            case 6: {
                message = message + "the biome not being suitable.";
                break;
            }
            case 7: {
                message = message + "the structure not being at position or suitable.";
                break;
            }
            case 8: {
                message = message + "the spawn placement type preventing spawn.";
                break;
            }
            case 9: {
                message = message + "the height position not being suitable.";
                break;
            }
            case 10: {
                message = message + "the light level at position not being suitable.";
                break;
            }
            case 11: {
                message = message + "there not being enough available space.";
                break;
            }
            case 12: {
                message = message + "the appropriate entity not being nearby.";
                break;
            }
            case 13: {
                message = message + "the appropriate block not being nearby.";
                break;
            }
            case 14: {
                message = message + "the entity colliding.";
                break;
            }
            case 15: {
                message = message + "the entity not being on the correct block.";
                break;
            }
            case 16: {
                message = message + "the blockstate below not allowing entities to spawn.";
                break;
            }
            case 17: {
                message = message + "the block path weight being too low.";
                break;
            }
            case 18: {
                message = message + "the position could not see the sky.";
                break;
            }
            case 19: {
                message = message + "the position does not have a suitable weather condition.";
            }
        }
        MultiMob.LOGGER.info(message);
    }
}

