/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.multimob.entity.ai;

import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigateGround;

public class EntityAIGrabItemFromFloor
extends EntityAIBase {
    private final EntityCreature temptedEntity;
    private final double speed;
    private double targetX;
    private double targetY;
    private double targetZ;
    private double pitch;
    private double yaw;
    private EntityItem temptingItem;
    private boolean isRunning;
    private final Set<ItemStack> temptItem;
    private boolean canGetScared;
    private int stealDelay = 0;

    public EntityAIGrabItemFromFloor(EntityCreature temptedEntityIn, double speedIn, Set<ItemStack> temptItemIn, boolean canGetScared) {
        this.temptedEntity = temptedEntityIn;
        this.speed = speedIn;
        this.temptItem = temptItemIn;
        this.canGetScared = canGetScared;
        if (!(temptedEntityIn.func_70661_as() instanceof PathNavigateGround)) {
            throw new IllegalArgumentException("Unsupported mob type for TemptGoal");
        }
    }

    public boolean func_75250_a() {
        if (this.temptedEntity.func_110144_aD() != null && this.canGetScared && this.stealDelay <= 0) {
            this.func_75251_c();
            return false;
        }
        if (!this.temptedEntity.func_184614_ca().func_190926_b()) {
            return false;
        }
        List list = this.temptedEntity.func_130014_f_().func_72839_b((Entity)this.temptedEntity, this.temptedEntity.func_174813_aQ().func_72314_b(10.0, 10.0, 10.0));
        if (this.stealDelay > 0) {
            --this.stealDelay;
            if (this.stealDelay == 0) {
                this.temptedEntity.func_130011_c(null);
            }
            return false;
        }
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                EntityItem item;
                ItemStack stack;
                Entity entity = (Entity)list.get(i);
                if (entity == null || !(entity instanceof EntityItem) || !(entity instanceof EntityItem) || (stack = (item = (EntityItem)entity).func_92059_d()).func_190926_b() || !this.isTempting(stack)) continue;
                this.temptingItem = item;
                return true;
            }
        }
        return false;
    }

    protected boolean isTempting(ItemStack stack) {
        if (!stack.func_190926_b()) {
            for (ItemStack item : this.temptItem) {
                if (item == null || item.func_77973_b() != stack.func_77973_b() || item.func_77960_j() != stack.func_77960_j()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.func_75250_a();
    }

    public void func_75249_e() {
        this.targetX = this.temptingItem.field_70165_t;
        this.targetY = this.temptingItem.field_70163_u;
        this.targetZ = this.temptingItem.field_70161_v;
        this.isRunning = true;
    }

    public void func_75251_c() {
        this.temptingItem = null;
        this.temptedEntity.func_70661_as().func_75499_g();
        this.isRunning = false;
        if (this.canGetScared) {
            this.stealDelay = 50;
        }
    }

    public void func_75246_d() {
        this.temptedEntity.func_70671_ap().func_75651_a((Entity)this.temptingItem, (float)(this.temptedEntity.func_184649_cE() + 20), (float)this.temptedEntity.func_70646_bf());
        if (this.temptedEntity.func_70068_e((Entity)this.temptingItem) < 1.0) {
            this.temptedEntity.func_70661_as().func_75499_g();
            ItemStack loot = this.temptingItem.func_92059_d().func_77946_l();
            this.temptingItem.func_70106_y();
            this.temptedEntity.func_184201_a(EntityEquipmentSlot.MAINHAND, loot);
        } else {
            this.temptedEntity.func_70661_as().func_75497_a((Entity)this.temptingItem, this.speed);
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

