/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.multimob.config;

import java.io.File;
import java.util.HashSet;
import net.daveyx0.multimob.config.MMConfigSpawns;
import net.daveyx0.multimob.spawn.MMConfigSpawnEntry;
import net.daveyx0.multimob.spawn.MMSpawnRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MMConfig {
    static Configuration config;
    public static final HashSet<MMConfigSpawnEntry> CONFIGSPAWNS;
    public static final HashSet<MMConfigSpawnEntry> EXTERNALCONFIGSPAWNS;

    public static void preInit(File dir, FMLPreInitializationEvent event) {
        config = new Configuration(new File(dir, "multimob_spawns.cfg"));
        MMConfigSpawns.loadGeneralOptions(config);
        MMConfigSpawnEntry.setupCategoryDescriptions(config);
        MinecraftForge.EVENT_BUS.register((Object)new MMConfig());
    }

    public static Configuration getConfig() {
        return config;
    }

    public static void postInit() {
        MMConfig.reloadConfig();
    }

    private static void reloadConfig() {
        MMConfigSpawns.load(config);
        MMConfig.refreshConfigSpawns();
        for (MMConfigSpawnEntry entry : CONFIGSPAWNS) {
            entry.load(config);
        }
        MMSpawnRegistry.loadSpawns();
        if (config.hasChanged()) {
            config.save();
        }
    }

    private static void refreshConfigSpawns() {
        HashSet<MMConfigSpawnEntry> oldConfigSpawns = CONFIGSPAWNS;
        CONFIGSPAWNS.clear();
        String[] stringArray = EXTERNALCONFIGSPAWNS.iterator();
        while (stringArray.hasNext()) {
            MMConfigSpawnEntry entry;
            MMConfigSpawnEntry newEntry = entry = stringArray.next();
            for (MMConfigSpawnEntry oldEntry : oldConfigSpawns) {
                if (!oldEntry.getEntryName().equals(entry.getEntryName())) continue;
                newEntry = oldEntry;
            }
            CONFIGSPAWNS.add(newEntry);
        }
        for (String configEntry : MMConfigSpawns.getConfigSpawnEntries()) {
            String[] names;
            if (configEntry.equals("") || (names = configEntry.split("#")) != null && names.length < 2) continue;
            MMConfigSpawnEntry newEntry = new MMConfigSpawnEntry(names[0], names[1]);
            for (MMConfigSpawnEntry oldEntry : oldConfigSpawns) {
                if (!oldEntry.getEntryName().equals(names[0])) continue;
                newEntry = oldEntry;
            }
            CONFIGSPAWNS.add(newEntry);
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("multimob")) {
            MMConfig.reloadConfig();
        }
    }

    static {
        CONFIGSPAWNS = new HashSet();
        EXTERNALCONFIGSPAWNS = new HashSet();
    }
}

