/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.multimob.common.capabilities;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.daveyx0.multimob.client.renderer.entity.layer.LayerVariantOverlay;
import net.daveyx0.multimob.common.capabilities.IVariantEntity;
import net.daveyx0.multimob.common.capabilities.VariantEntityHandler;
import net.daveyx0.multimob.core.MMVariantEntries;
import net.daveyx0.multimob.message.MMMessageRegistry;
import net.daveyx0.multimob.message.MessageMMVariant;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CapabilityVariantEntity {
    @CapabilityInject(value=IVariantEntity.class)
    public static Capability<IVariantEntity> VARIANT_ENTITY_CAPABILITY = null;
    public static final ResourceLocation capabilityID = new ResourceLocation("multimob", "Variant");

    public static void register() {
        CapabilityManager.INSTANCE.register(IVariantEntity.class, (Capability.IStorage)new Capability.IStorage<IVariantEntity>(){

            public NBTBase writeNBT(Capability<IVariantEntity> capability, IVariantEntity instance, EnumFacing side) {
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74768_a("VariantID", instance.getVariant());
                return compound;
            }

            public void readNBT(Capability<IVariantEntity> capability, IVariantEntity instance, EnumFacing side, NBTBase base) {
                NBTTagCompound compound = (NBTTagCompound)base;
                instance.setVariant(compound.func_74762_e("VariantID"));
            }
        }, VariantEntityHandler::new);
    }

    @Mod.EventBusSubscriber(modid="multimob")
    public static class EventHandler {
        @SubscribeEvent
        public static void AttachEntityCapabilitiesEvent(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() == null || MMVariantEntries.variantEntries.containsKey(((Entity)event.getObject()).getClass())) {
                // empty if block
            }
        }

        @SubscribeEvent
        public static void LivingEntityEvent(LivingEvent.LivingUpdateEvent event) {
            if (EventHandler.hasVariant(event.getEntity()) && ((IVariantEntity)event.getEntity().getCapability(VARIANT_ENTITY_CAPABILITY, null)).getVariant() != 0 && event.getEntity().field_70173_aa % 10 == 0) {
                MMMessageRegistry.getNetwork().sendToAll((IMessage)new MessageMMVariant(event.getEntity().func_110124_au().toString(), ((IVariantEntity)event.getEntity().getCapability(VARIANT_ENTITY_CAPABILITY, null)).getVariant()));
            }
        }

        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public static void LivingLayerRenderEvent(RenderLivingEvent.Pre event) {
            if (EventHandler.hasVariant((Entity)event.getEntity()) && ((IVariantEntity)event.getEntity().getCapability(VARIANT_ENTITY_CAPABILITY, null)).getVariant() != 0) {
                if (event.getRenderer() != null) {
                    Optional<LayerRenderer> layerEntity;
                    Object objectRenderLayers = ReflectionHelper.getPrivateValue(RenderLivingBase.class, (Object)event.getRenderer(), (String[])ObfuscationReflectionHelper.remapFieldNames((String)RenderLivingBase.class.getName(), (String[])new String[]{"layerRenderers", "layerRenderers"}));
                    Collection layerRenderers = null;
                    try {
                        Field modifier = Field.class.getDeclaredField("modifiers");
                        modifier.setAccessible(true);
                        layerRenderers = (List)objectRenderLayers;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (!(layerRenderers == null || (layerEntity = layerRenderers.stream().filter(layerRenderer -> layerRenderer instanceof LayerVariantOverlay).findFirst()) != null && layerEntity.isPresent())) {
                        event.getRenderer().func_177094_a((LayerRenderer)new LayerVariantOverlay(event.getRenderer()));
                    }
                }
                GlStateManager.func_179132_a((boolean)false);
            }
        }

        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public static void LivingLayerRenderEvent(RenderLivingEvent.Post event) {
            if (EventHandler.hasVariant((Entity)event.getEntity()) && ((IVariantEntity)event.getEntity().getCapability(VARIANT_ENTITY_CAPABILITY, null)).getVariant() != 0) {
                GlStateManager.func_179132_a((boolean)true);
            }
        }

        public static boolean hasVariant(Entity entity) {
            return entity != null && entity instanceof EntityLiving && entity.hasCapability(VARIANT_ENTITY_CAPABILITY, null);
        }
    }
}

