/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.multimob.common.capabilities;

import java.util.UUID;
import net.daveyx0.multimob.capabilities.CapabilityProviderSerializable;
import net.daveyx0.multimob.common.capabilities.ITameableEntity;
import net.daveyx0.multimob.common.capabilities.TameableEntityEntry;
import net.daveyx0.multimob.common.capabilities.TameableEntityHandler;
import net.daveyx0.multimob.core.MMTameableEntries;
import net.daveyx0.multimob.entity.ai.EntityAITameableFollowOwner;
import net.daveyx0.multimob.entity.ai.EntityAITameableOwnerHurtByTarget;
import net.daveyx0.multimob.entity.ai.EntityAITameableOwnerHurtTarget;
import net.daveyx0.multimob.message.MMMessageRegistry;
import net.daveyx0.multimob.message.MessageMMParticle;
import net.daveyx0.multimob.message.MessageMMTameable;
import net.daveyx0.multimob.util.EntityUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CapabilityTameableEntity {
    @CapabilityInject(value=ITameableEntity.class)
    public static Capability<ITameableEntity> TAMEABLE_ENTITY_CAPABILITY = null;
    public static final ResourceLocation capabilityID = new ResourceLocation("multimob", "Tameable");

    public static void register() {
        CapabilityManager.INSTANCE.register(ITameableEntity.class, (Capability.IStorage)new Capability.IStorage<ITameableEntity>(){

            public NBTBase writeNBT(Capability<ITameableEntity> capability, ITameableEntity instance, EnumFacing side) {
                NBTTagCompound compound = new NBTTagCompound();
                UUID owner = instance.getOwnerId();
                if (owner == null) {
                    compound.func_74778_a("OwnerUUID", "");
                } else {
                    compound.func_74778_a("OwnerUUID", owner.toString());
                }
                compound.func_74768_a("FollowState", instance.getFollowState());
                return compound;
            }

            public void readNBT(Capability<ITameableEntity> capability, ITameableEntity instance, EnumFacing side, NBTBase base) {
                NBTTagCompound compound = (NBTTagCompound)base;
                String s = "";
                if (compound.func_150297_b("OwnerUUID", 8)) {
                    s = compound.func_74779_i("OwnerUUID");
                }
                if (!s.isEmpty()) {
                    try {
                        instance.setOwner(UUID.fromString(s));
                        instance.setTamed(true);
                    }
                    catch (Throwable var4) {
                        instance.setTamed(false);
                    }
                }
                instance.setFollowState(compound.func_74762_e("FollowState"));
            }
        }, TameableEntityHandler::new);
    }

    @Mod.EventBusSubscriber(modid="multimob")
    public static class EventHandler {
        @SubscribeEvent
        public static void AttachEntityCapabilitiesEvent(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() != null && MMTameableEntries.tameableEntries.containsKey(((Entity)event.getObject()).getClass())) {
                event.addCapability(capabilityID, new CapabilityProviderSerializable<ITameableEntity>(TAMEABLE_ENTITY_CAPABILITY));
            }
        }

        @SubscribeEvent
        public static void EntityLivingDeathEvent(LivingDeathEvent event) {
            if (EventHandler.isTameableEntity((Entity)event.getEntityLiving())) {
                ITameableEntity tameable = EntityUtil.getCapability(event.getEntity(), TAMEABLE_ENTITY_CAPABILITY, null);
                EntityLiving entity = (EntityLiving)event.getEntityLiving();
                if (!entity.field_70170_p.field_72995_K && entity.field_70170_p.func_82736_K().func_82766_b("showDeathMessages") && tameable.getOwner((EntityLivingBase)entity) != null && tameable.getOwner((EntityLivingBase)entity) instanceof EntityPlayerMP) {
                    tameable.getOwner((EntityLivingBase)entity).func_145747_a(entity.func_110142_aN().func_151521_b());
                }
            }
        }

        @SubscribeEvent
        public static void JoinWorldEvent(EntityJoinWorldEvent event) {
            if (EventHandler.isTameableEntity(event.getEntity())) {
                EntityLiving entity = (EntityLiving)event.getEntity();
                ITameableEntity tameable = EntityUtil.getCapability(event.getEntity(), TAMEABLE_ENTITY_CAPABILITY, null);
                if (tameable != null && tameable.isTamed()) {
                    if (tameable.getFollowState() == 0 || tameable.getFollowState() == 0) {
                        EventHandler.resetEntityTargetAI(entity);
                    } else {
                        EventHandler.updateEntityTargetAI(entity);
                    }
                    entity.field_70714_bg.field_75782_a.stream().filter(taskEntry -> taskEntry.field_75733_a instanceof EntityAITameableFollowOwner).findFirst().ifPresent(taskEntry -> entity.field_70714_bg.func_85156_a(taskEntry.field_75733_a));
                    if (tameable.getFollowState() == 2) {
                        entity.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITameableFollowOwner(entity, 1.2, 8.0f, 2.0f));
                    }
                    if (MMTameableEntries.tameableEntries.containsKey(entity)) {
                        TameableEntityEntry entry = MMTameableEntries.tameableEntries.get(entity);
                        entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)entry.getTamedHealth());
                    }
                }
            }
        }

        @SubscribeEvent
        public static void EntityUpdateEvent(LivingEvent.LivingUpdateEvent event) {
            if (EventHandler.isTameableEntity((Entity)event.getEntityLiving())) {
                EntityLiving entity = (EntityLiving)event.getEntity();
                ITameableEntity tameable = EntityUtil.getCapability(event.getEntity(), TAMEABLE_ENTITY_CAPABILITY, null);
                if (tameable != null && tameable.isTamed()) {
                    if (tameable.getFollowState() == 0) {
                        entity.func_70661_as().func_75499_g();
                        entity.func_70659_e(0.0f);
                        entity.func_70624_b(null);
                    }
                    if (entity.field_70170_p.field_73012_v.nextInt(200) == 0) {
                        entity.func_130014_f_().func_175688_a(EnumParticleTypes.HEART, entity.field_70165_t + (double)(entity.field_70170_p.field_73012_v.nextFloat() - entity.field_70170_p.field_73012_v.nextFloat()), entity.field_70163_u + (double)entity.field_70170_p.field_73012_v.nextFloat() + 1.0, entity.field_70161_v + (double)(entity.field_70170_p.field_73012_v.nextFloat() - entity.field_70170_p.field_73012_v.nextFloat()), 1.0, 1.0, 1.0, new int[0]);
                    }
                }
            }
        }

        @SubscribeEvent
        public static void EntityDamageEvent(LivingDamageEvent event) {
            if (EventHandler.isTameableEntity((Entity)event.getEntityLiving())) {
                EntityLiving entity = (EntityLiving)event.getEntity();
                ITameableEntity tameable = EntityUtil.getCapability(event.getEntity(), TAMEABLE_ENTITY_CAPABILITY, null);
                if (tameable != null && tameable.isTamed() && (event.getSource() == DamageSource.field_76379_h || event.getSource() == DamageSource.field_76369_e || event.getSource() == DamageSource.field_76368_d)) {
                    event.setResult(Event.Result.DENY);
                }
            }
        }

        @SubscribeEvent
        public static void PlayerStartsTrackingEvent(PlayerEvent.StartTracking event) {
            ITameableEntity tameable;
            if (!event.getEntityPlayer().func_130014_f_().field_72995_K && EventHandler.isTameableEntity(event.getTarget()) && (tameable = EntityUtil.getCapability(event.getTarget(), TAMEABLE_ENTITY_CAPABILITY, null)).getOwnerId() != null) {
                MMMessageRegistry.getNetwork().sendToAllAround((IMessage)new MessageMMTameable(event.getTarget().func_110124_au().toString(), tameable.getOwnerId().toString(), tameable.getFollowState()), new NetworkRegistry.TargetPoint(event.getEntityPlayer().field_71093_bK, event.getTarget().field_70165_t, event.getTarget().field_70163_u, event.getTarget().field_70161_v, 255.0));
            }
        }

        @SubscribeEvent
        public static void PlayerInteractEvent(PlayerInteractEvent.EntityInteract event) {
            block15: {
                TameableEntityEntry entry;
                ITameableEntity tameable;
                EntityLiving entity;
                block16: {
                    TameableEntityEntry entry2;
                    block17: {
                        block18: {
                            if (!EventHandler.isTameableEntity(event.getTarget()) || event.getHand() != EnumHand.MAIN_HAND) break block15;
                            entity = (EntityLiving)event.getTarget();
                            tameable = EntityUtil.getCapability(event.getTarget(), TAMEABLE_ENTITY_CAPABILITY, null);
                            if (tameable == null) break block15;
                            if (!tameable.isTamed() || tameable.getOwner((EntityLivingBase)entity) != event.getEntityPlayer()) break block16;
                            if (event.getItemStack() != ItemStack.field_190927_a) break block17;
                            if (!event.getEntityPlayer().func_70093_af()) break block18;
                            tameable.setFollowState(tameable.getFollowState() + 1);
                            if (tameable.getFollowState() == 3) {
                                tameable.setFollowState(0);
                            }
                            MMMessageRegistry.getNetwork().sendToAllAround((IMessage)new MessageMMTameable(event.getTarget().func_110124_au().toString(), tameable.getOwnerId().toString(), tameable.getFollowState()), new NetworkRegistry.TargetPoint(event.getEntityPlayer().field_71093_bK, event.getTarget().field_70165_t, event.getTarget().field_70163_u, event.getTarget().field_70161_v, 255.0));
                            if (tameable.getFollowState() == 2) {
                                entity.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITameableFollowOwner(entity, 1.2, 8.0f, 2.0f));
                            } else {
                                entity.field_70714_bg.field_75782_a.stream().filter(taskEntry -> taskEntry.field_75733_a instanceof EntityAITameableFollowOwner).findFirst().ifPresent(taskEntry -> entity.field_70714_bg.func_85156_a(taskEntry.field_75733_a));
                            }
                            if (tameable.getFollowState() == 0) {
                                EventHandler.resetEntityTargetAI(entity);
                            } else {
                                EventHandler.updateEntityTargetAI(entity);
                            }
                            if (event.getEntity().func_130014_f_().field_72995_K) break block15;
                            int particleID = 0;
                            if (tameable.getFollowState() == 0) {
                                particleID = EnumParticleTypes.VILLAGER_HAPPY.func_179348_c();
                                event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("%1$s is now sitting.", new Object[]{event.getTarget().func_145748_c_()}));
                            } else if (tameable.getFollowState() == 1) {
                                particleID = EnumParticleTypes.NOTE.func_179348_c();
                                event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("%1$s is now wandering.", new Object[]{event.getTarget().func_145748_c_()}));
                            } else if (tameable.getFollowState() == 2) {
                                particleID = EnumParticleTypes.HEART.func_179348_c();
                                event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("%1$s is now following.", new Object[]{event.getTarget().func_145748_c_()}));
                            }
                            MMMessageRegistry.getNetwork().sendToAll((IMessage)new MessageMMParticle(particleID, 15, (float)entity.field_70165_t + 0.5f, (float)entity.field_70163_u + 0.5f, (float)entity.field_70161_v + 0.5f, 0.0, 0.0, 0.0, 0));
                            break block15;
                        }
                        if (!entity.func_82171_bF() || event.getEntity().func_130014_f_().field_72995_K) break block15;
                        event.getEntityPlayer().func_184220_m((Entity)entity);
                        break block15;
                    }
                    if (!MMTameableEntries.tameableEntries.containsKey(entity.getClass()) || (entry2 = MMTameableEntries.tameableEntries.get(entity.getClass())).getHealItems() == null || entry2.getHealItems().length <= 0) break block15;
                    for (Item item : entry2.getHealItems()) {
                        if (event.getItemStack().func_77973_b() != item) continue;
                        if (!event.getEntityPlayer().field_71075_bZ.field_75098_d) {
                            event.getItemStack().func_190918_g(1);
                        }
                        entity.func_70691_i(10.0f);
                        EventHandler.playHealEffect((Entity)entity);
                        break block15;
                    }
                    break block15;
                }
                if (!tameable.isTamed() && event.getItemStack() != null && MMTameableEntries.tameableEntries.containsKey(entity.getClass()) && (entry = MMTameableEntries.tameableEntries.get(entity.getClass())).getTameItems() != null && entry.getCanBeTamedWithItem() && entry.getTameItems().length > 0) {
                    for (Item item : entry.getTameItems()) {
                        if (event.getItemStack().func_77973_b() != item) continue;
                        if (!event.getEntityPlayer().field_71075_bZ.field_75098_d) {
                            event.getItemStack().func_190918_g(1);
                        }
                        EventHandler.setUpTameable(tameable, entity, (EntityLivingBase)event.getEntityPlayer());
                        break;
                    }
                }
            }
        }

        public static void setUpTameable(ITameableEntity tameable, EntityLiving entity, EntityLivingBase owner) {
            tameable.setOwner(owner.func_110124_au());
            tameable.setTamed(true);
            tameable.setFollowState(2);
            MMMessageRegistry.getNetwork().sendToAllAround((IMessage)new MessageMMTameable(entity.func_110124_au().toString(), tameable.getOwnerId().toString(), tameable.getFollowState()), new NetworkRegistry.TargetPoint(owner.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 255.0));
            EventHandler.updateEntityTargetAI(entity);
            entity.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITameableFollowOwner(entity, 1.2, 8.0f, 2.0f));
            EventHandler.playHealEffect((Entity)entity);
        }

        @SubscribeEvent
        public static void EntityDespawnEvent(LivingSpawnEvent.AllowDespawn event) {
            ITameableEntity tameable;
            if (EventHandler.isTameableEntity(event.getEntity()) && (tameable = EntityUtil.getCapability(event.getEntity(), TAMEABLE_ENTITY_CAPABILITY, null)) != null && tameable.isTamed()) {
                event.setResult(Event.Result.DENY);
            }
        }

        public static void updateEntityTargetAI(EntityLiving base) {
            while (base.field_70715_bh.field_75782_a.stream().filter(taskEntry -> taskEntry.field_75733_a instanceof EntityAIBase).findFirst().isPresent()) {
                base.field_70715_bh.field_75782_a.stream().filter(taskEntry -> taskEntry.field_75733_a instanceof EntityAIBase).findFirst().ifPresent(taskEntry -> base.field_70715_bh.func_85156_a(taskEntry.field_75733_a));
            }
            base.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITameableOwnerHurtByTarget(base));
            base.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITameableOwnerHurtTarget(base));
        }

        public static void resetEntityTargetAI(EntityLiving base) {
            while (base.field_70715_bh.field_75782_a.stream().filter(taskEntry -> taskEntry.field_75733_a instanceof EntityAIBase).findFirst().isPresent()) {
                base.field_70715_bh.field_75782_a.stream().filter(taskEntry -> taskEntry.field_75733_a instanceof EntityAIBase).findFirst().ifPresent(taskEntry -> base.field_70715_bh.func_85156_a(taskEntry.field_75733_a));
            }
        }

        public static boolean isTameableEntity(Entity entity) {
            return entity != null && entity instanceof EntityLiving && entity.hasCapability(TAMEABLE_ENTITY_CAPABILITY, null);
        }

        protected static void playHealEffect(Entity entity) {
            EnumParticleTypes enumparticletypes = EnumParticleTypes.HEART;
            for (int i = 0; i < 7; ++i) {
                double d0 = entity.field_70170_p.field_73012_v.nextGaussian() * 0.02;
                double d1 = entity.field_70170_p.field_73012_v.nextGaussian() * 0.02;
                double d2 = entity.field_70170_p.field_73012_v.nextGaussian() * 0.02;
                entity.func_130014_f_().func_175688_a(enumparticletypes, entity.field_70165_t + (double)(entity.field_70170_p.field_73012_v.nextFloat() * entity.field_70130_N * 2.0f) - (double)entity.field_70130_N, entity.field_70163_u + 0.5 + (double)(entity.field_70170_p.field_73012_v.nextFloat() * entity.field_70131_O), entity.field_70161_v + (double)(entity.field_70170_p.field_73012_v.nextFloat() * entity.field_70130_N * 2.0f) - (double)entity.field_70130_N, d0, d1, d2, new int[0]);
            }
        }
    }
}

