/*
 * Decompiled with CFR 0.152.
 */
package arcaratus.bloodarsenal.tile;

import WayofTime.bloodmagic.altar.IBloodAltar;
import WayofTime.bloodmagic.api.impl.BloodMagicAPI;
import WayofTime.bloodmagic.api.impl.recipe.RecipeBloodAltar;
import WayofTime.bloodmagic.core.data.Binding;
import WayofTime.bloodmagic.core.data.SoulTicket;
import WayofTime.bloodmagic.iface.IBindable;
import WayofTime.bloodmagic.orb.IBloodOrb;
import WayofTime.bloodmagic.util.helper.NetworkHelper;
import WayofTime.bloodmagic.util.helper.TextHelper;
import arcaratus.bloodarsenal.ConfigHandler;
import arcaratus.bloodarsenal.block.BlockAltareAenigmatica;
import arcaratus.bloodarsenal.tile.TileInventory;
import arcaratus.bloodarsenal.util.BloodArsenalUtils;
import com.google.common.base.Strings;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TileAltareAenigmatica
extends TileInventory
implements ISidedInventory,
ITickable {
    public static final int ORB_SLOT = 9;
    private BlockPos altarPos = BlockPos.field_177992_a;
    private String linkedOrbOwner = "";

    public TileAltareAenigmatica() {
        super(10, "altare_aenigmatica");
    }

    @Override
    public void deserialize(NBTTagCompound tag) {
        super.deserialize(tag);
        this.altarPos = BloodArsenalUtils.getPosFromNBT(tag);
        this.linkedOrbOwner = tag.func_74779_i("ownerUUID");
    }

    @Override
    public NBTTagCompound serialize(NBTTagCompound tag) {
        super.serialize(tag);
        BloodArsenalUtils.writePosToNBT(tag, this.altarPos.func_177958_n(), this.altarPos.func_177956_o(), this.altarPos.func_177952_p());
        tag.func_74778_a("ownerUUID", this.linkedOrbOwner);
        return tag;
    }

    public int[] func_180463_a(EnumFacing side) {
        IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
        if (state.func_177230_c() instanceof BlockAltareAenigmatica) {
            BlockAltareAenigmatica aenigmatica = (BlockAltareAenigmatica)state.func_177230_c();
            if (EnumFacing.values()[aenigmatica.func_176201_c(state)] == side) {
                return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
            }
        }
        return new int[0];
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }

    public void func_73660_a() {
        TileEntity tile;
        if (this.altarPos != BlockPos.field_177992_a && (tile = this.func_145831_w().func_175625_s(this.altarPos)) instanceof IBloodAltar && tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN) instanceof InvWrapper) {
            IBloodAltar altar = (IBloodAltar)tile;
            ItemStack orbStack = this.func_70301_a(9);
            IItemHandler altarInventory = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN);
            boolean inThis = this.checkOrb(orbStack);
            boolean inAltar = this.checkOrb(altarInventory.getStackInSlot(0));
            if (inThis) {
                this.manageAltar(altarInventory, orbStack, altar);
            } else if (inAltar) {
                this.manageAltar(altarInventory, altarInventory.getStackInSlot(0), altar);
            }
        }
    }

    private boolean canInsertIntoAltar(IItemHandler altarInventory) {
        return altarInventory.getStackInSlot(0).func_190926_b() || this.checkOrb(altarInventory.getStackInSlot(0));
    }

    private boolean checkOrb(ItemStack orbStack) {
        return orbStack.func_77973_b() instanceof IBloodOrb && orbStack.func_77973_b() instanceof IBindable && ((IBindable)orbStack.func_77973_b()).getBinding(orbStack) != null && ((IBindable)orbStack.func_77973_b()).getBinding(orbStack).getOwnerName().equals(this.linkedOrbOwner);
    }

    private void manageAltar(IItemHandler altarInventory, ItemStack orbStack, IBloodAltar altar) {
        IBloodOrb orb = (IBloodOrb)orbStack.func_77973_b();
        IBindable sameOrb = (IBindable)orb;
        if (sameOrb.getBinding(orbStack) != null) {
            ItemStack stackInSlot = ItemStack.field_190927_a;
            int slot = -1;
            for (int i = 0; i < 9; ++i) {
                if (this.func_70301_a(i).func_190926_b()) continue;
                stackInSlot = this.func_70301_a(i);
                slot = i;
                break;
            }
            int altarEssence = altar.getCurrentBlood();
            if (!stackInSlot.func_190926_b() && slot > -1) {
                RecipeBloodAltar altarRecipe = BloodMagicAPI.INSTANCE.getRecipeRegistrar().getBloodAltar(stackInSlot);
                if (altarRecipe != null && altarRecipe.getInput().apply(stackInSlot) && altar.getTier().toInt() >= altarRecipe.getMinimumTier().toInt()) {
                    if (this.checkOrb(altarInventory.getStackInSlot(0))) {
                        ItemStack copyStack = altarInventory.getStackInSlot(0).func_77946_l();
                        altarInventory.extractItem(0, 1, false);
                        this.func_70299_a(9, copyStack);
                        altarInventory.insertItem(0, stackInSlot.func_77946_l(), false);
                        this.func_70299_a(slot, ItemStack.field_190927_a);
                        NetworkHelper.syphonFromContainer((ItemStack)orbStack, (SoulTicket)SoulTicket.block((World)this.field_145850_b, (BlockPos)this.field_174879_c, (int)(stackInSlot.func_190916_E() * ConfigHandler.values.altareAenigmaticaMoveMultiplier)));
                    } else if (altarRecipe.getSyphon() * stackInSlot.func_190916_E() <= altarEssence && NetworkHelper.canSyphonFromContainer((ItemStack)orbStack, (int)(stackInSlot.func_190916_E() * ConfigHandler.values.altareAenigmaticaMoveMultiplier))) {
                        altarInventory.insertItem(0, stackInSlot.func_77946_l(), false);
                        this.func_70299_a(slot, ItemStack.field_190927_a);
                        NetworkHelper.syphonFromContainer((ItemStack)orbStack, (SoulTicket)SoulTicket.block((World)this.field_145850_b, (BlockPos)this.field_174879_c, (int)(stackInSlot.func_190916_E() * ConfigHandler.values.altareAenigmaticaMoveMultiplier)));
                    }
                } else {
                    this.shoveOrbIntoAltar(altarInventory, orbStack);
                }
            } else if (altarInventory.getStackInSlot(0).func_190926_b()) {
                this.shoveOrbIntoAltar(altarInventory, orbStack);
            }
        }
    }

    private void shoveOrbIntoAltar(IItemHandler altarInventory, ItemStack orbStack) {
        ItemStack copyStack = orbStack.func_77946_l();
        this.func_70299_a(9, ItemStack.field_190927_a);
        altarInventory.insertItem(0, copyStack, false);
    }

    public BlockPos getAltarPos() {
        return this.altarPos;
    }

    public void setAltarPos(BlockPos pos) {
        this.altarPos = pos;
    }

    public boolean setLinkedOrbOwner(EntityPlayer player) {
        String probablyOwnerName;
        Binding binding = ((IBindable)player.func_184614_ca().func_77973_b()).getBinding(player.func_184614_ca());
        String string = probablyOwnerName = binding == null ? "" : binding.getOwnerName();
        if (Strings.isNullOrEmpty((String)probablyOwnerName)) {
            player.func_146105_b((ITextComponent)new TextComponentString(TextHelper.localize((String)"chat.bloodarsenal.no_owner", (Object[])new Object[0])), true);
            return false;
        }
        if (this.linkedOrbOwner.equals(probablyOwnerName)) {
            player.func_146105_b((ITextComponent)new TextComponentString(TextHelper.localize((String)"chat.bloodarsenal.already_owner", (Object[])new Object[0])), true);
            return false;
        }
        this.linkedOrbOwner = probablyOwnerName;
        player.func_146105_b((ITextComponent)new TextComponentString(TextHelper.localize((String)"chat.bloodarsenal.set_owner", (Object[])new Object[]{player.func_70005_c_()})), true);
        return true;
    }
}

