/*
 * Decompiled with CFR 0.152.
 */
package arcaratus.bloodarsenal.item.baubles;

import WayofTime.bloodmagic.altar.IAltarManipulator;
import WayofTime.bloodmagic.altar.IBloodAltar;
import WayofTime.bloodmagic.client.IVariantProvider;
import WayofTime.bloodmagic.iface.IItemLPContainer;
import WayofTime.bloodmagic.util.helper.ItemHelper;
import WayofTime.bloodmagic.util.helper.NBTHelper;
import WayofTime.bloodmagic.util.helper.PlayerHelper;
import WayofTime.bloodmagic.util.helper.TextHelper;
import arcaratus.bloodarsenal.ConfigHandler;
import arcaratus.bloodarsenal.item.baubles.BaubleUtils;
import arcaratus.bloodarsenal.item.baubles.ItemBauble;
import baubles.api.BaubleType;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSelfSacrificeAmulet
extends ItemBauble
implements IAltarManipulator,
IItemLPContainer,
IVariantProvider {
    public final int CAPACITY = 10000;

    public ItemSelfSacrificeAmulet(String name) {
        super(name, BaubleType.AMULET);
        this.func_77627_a(true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void selfSacrificeHandler(LivingAttackEvent event) {
        EntityPlayer player;
        ItemStack baubleStack;
        if (event.getEntity().func_130014_f_().field_72995_K) {
            return;
        }
        EntityLivingBase entityAttacked = event.getEntityLiving();
        if (entityAttacked instanceof EntityPlayerMP && (baubleStack = BaubleUtils.getBaubleStackInPlayer(player = (EntityPlayer)entityAttacked, this)).func_77973_b() instanceof ItemSelfSacrificeAmulet) {
            ItemSelfSacrificeAmulet amulet = (ItemSelfSacrificeAmulet)baubleStack.func_77973_b();
            boolean shouldSyphon = amulet.getStoredLP(baubleStack) < amulet.CAPACITY;
            float damageDone = event.getAmount();
            int totalLP = (int)Math.round((double)damageDone * ConfigHandler.values.selfSacrificeAmuletMultiplier);
            if (shouldSyphon) {
                PotionEffect regen = player.func_70660_b(MobEffects.field_76428_l);
                if (regen != null && regen.func_76458_c() >= 1) {
                    ItemHelper.LPContainer.addLPToItem((ItemStack)baubleStack, (int)(totalLP * (1 / regen.func_76458_c() + 1)), (int)amulet.CAPACITY);
                } else {
                    ItemHelper.LPContainer.addLPToItem((ItemStack)baubleStack, (int)totalLP, (int)amulet.CAPACITY);
                }
            }
        }
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (PlayerHelper.isFakePlayer((EntityPlayer)player)) {
            return super.func_77659_a(world, player, hand);
        }
        if (world.field_72995_K) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        RayTraceResult rayTrace = this.func_77621_a(world, player, false);
        if (rayTrace == null) {
            return super.func_77659_a(world, player, EnumHand.MAIN_HAND);
        }
        if (rayTrace.field_72313_a == RayTraceResult.Type.BLOCK) {
            TileEntity tile = world.func_175625_s(rayTrace.func_178782_a());
            if (!(tile instanceof IBloodAltar)) {
                return super.func_77659_a(world, player, EnumHand.MAIN_HAND);
            }
            ItemHelper.LPContainer.tryAndFillAltar((IBloodAltar)((IBloodAltar)tile), (ItemStack)stack, (World)world, (BlockPos)rayTrace.func_178782_a());
        }
        return super.func_77659_a(world, player, hand);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag flag) {
        if (!stack.func_77942_o()) {
            return;
        }
        list.add(TextHelper.localize((String)"tooltip.bloodarsenal.sacrifice_amulet.desc", (Object[])new Object[0]));
        list.add(TextHelper.localizeEffect((String)"tooltip.bloodarsenal.stored", (Object[])new Object[]{this.getStoredLP(stack)}));
        super.func_77624_a(stack, world, list, flag);
    }

    @Override
    public void onWornTick(ItemStack itemstack, EntityLivingBase entity) {
        if (this.getStoredLP(itemstack) > 10000) {
            this.setStoredLP(itemstack, 10000);
        }
    }

    public int getCapacity() {
        return this.CAPACITY;
    }

    public int getStoredLP(ItemStack stack) {
        return !stack.func_190926_b() ? NBTHelper.checkNBT((ItemStack)stack).func_77978_p().func_74762_e("storedLP") : 0;
    }

    public void setStoredLP(ItemStack stack, int lp) {
        if (!stack.func_190926_b()) {
            NBTHelper.checkNBT((ItemStack)stack).func_77978_p().func_74768_a("storedLP", lp);
        }
    }

    public void gatherVariants(@Nonnull Int2ObjectMap<String> variants) {
        variants.put(0, (Object)"type=normal");
    }
}

