/*
 * Decompiled with CFR 0.152.
 */
package arcaratus.bloodarsenal.block;

import WayofTime.bloodmagic.client.IVariantProvider;
import WayofTime.bloodmagic.util.helper.PlayerSacrificeHelper;
import arcaratus.bloodarsenal.BloodArsenal;
import arcaratus.bloodarsenal.ConfigHandler;
import arcaratus.bloodarsenal.block.IBABlock;
import arcaratus.bloodarsenal.core.RegistrarBloodArsenal;
import arcaratus.bloodarsenal.item.types.EnumBaseTypes;
import arcaratus.bloodarsenal.util.DamageSourceGlass;
import com.google.common.collect.ImmutableMap;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGlassShards
extends Block
implements IVariantProvider,
IBABlock {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool NORTHEAST = PropertyBool.func_177716_a((String)"northeast");
    public static final PropertyBool NORTHWEST = PropertyBool.func_177716_a((String)"northwest");
    private static final ImmutableMap<EnumFacing, AxisAlignedBB> BOUNDS;

    public BlockGlassShards(String name) {
        super(Material.field_151592_s);
        this.func_149663_c("bloodarsenal." + name);
        this.setRegistryName(name);
        this.func_149647_a(BloodArsenal.TAB_BLOOD_ARSENAL);
        this.func_149711_c(0.75f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)NORTHEAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)NORTHWEST, (Comparable)Boolean.valueOf(false)));
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.add((Object)EnumBaseTypes.GLASS_SHARD.getStack(RANDOM.nextInt(6)));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, NORTH, EAST, NORTHEAST, NORTHWEST});
    }

    public IBlockState func_176203_a(int meta) {
        if (meta >= EnumFacing.values().length) {
            meta = EnumFacing.DOWN.ordinal();
        }
        EnumFacing face = EnumFacing.values()[meta];
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)face);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        int off = -facing.ordinal() % 2;
        EnumFacing face1 = EnumFacing.values()[(facing.ordinal() + 2) % 6];
        EnumFacing face2 = EnumFacing.values()[(facing.ordinal() + 4 + off) % 6];
        IBlockState north = worldIn.func_180495_p(pos.func_177972_a(face1));
        IBlockState east = worldIn.func_180495_p(pos.func_177972_a(face2));
        if (north.func_177230_c() == this && north.func_177229_b((IProperty)FACING) == facing) {
            state = state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(true));
        }
        if (east.func_177230_c() == this && east.func_177229_b((IProperty)FACING) == facing) {
            state = state.func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(true));
        }
        IBlockState northeast = worldIn.func_180495_p(pos.func_177972_a(face1).func_177972_a(face2));
        IBlockState northwest = worldIn.func_180495_p(pos.func_177972_a(face1).func_177972_a(face2.func_176734_d()));
        if (northeast.func_177230_c() == this && northeast.func_177229_b((IProperty)FACING) == facing) {
            state = state.func_177226_a((IProperty)NORTHEAST, (Comparable)Boolean.valueOf(true));
        }
        if (northwest.func_177230_c() == this && northwest.func_177229_b((IProperty)FACING) == facing) {
            state = state.func_177226_a((IProperty)NORTHWEST, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumFacing enumfacing = facing.func_176734_d();
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return worldIn.isSideSolid(pos.func_177972_a(side.func_176734_d()), side, true);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (!worldIn.isSideSolid(pos.func_177972_a(facing), facing.func_176734_d(), true)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return (AxisAlignedBB)BOUNDS.get((Object)state.func_177229_b((IProperty)FACING));
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (worldIn.func_72820_D() % 10L == 0L && entityIn instanceof EntityLivingBase) {
            double damage = ConfigHandler.values.glassShardsDamage;
            if (entityIn.field_70143_R > 0.0f) {
                damage += (double)entityIn.field_70143_R * 1.5 + 1.0;
            }
            if (entityIn.func_70097_a((DamageSource)DamageSourceGlass.INSTANCE, (float)damage)) {
                PlayerSacrificeHelper.findAndFillAltar((World)worldIn, (EntityLivingBase)((EntityLivingBase)entityIn), (int)((int)Math.round(damage * (double)RANDOM.nextInt(101))), (boolean)false);
            }
            ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(RegistrarBloodArsenal.BLEEDING, RANDOM.nextInt(100), 0));
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public ItemBlock getItem() {
        return new ItemBlock((Block)this);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)EnumFacing.DOWN, (Object)new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.25, 0.875));
        builder.put((Object)EnumFacing.UP, (Object)new AxisAlignedBB(0.125, 0.75, 0.125, 0.875, 1.0, 0.875));
        builder.put((Object)EnumFacing.NORTH, (Object)new AxisAlignedBB(0.125, 0.125, 0.0, 0.875, 0.875, 0.25));
        builder.put((Object)EnumFacing.SOUTH, (Object)new AxisAlignedBB(0.125, 0.125, 0.75, 0.875, 0.875, 1.0));
        builder.put((Object)EnumFacing.EAST, (Object)new AxisAlignedBB(0.75, 0.125, 0.125, 1.0, 0.875, 0.875));
        builder.put((Object)EnumFacing.WEST, (Object)new AxisAlignedBB(0.0, 0.125, 0.125, 0.25, 0.875, 0.875));
        BOUNDS = builder.build();
    }
}

