/*
 * Decompiled with CFR 0.152.
 */
package com.polipo.fishing;

import com.polipo.fishing.BlockDynamicNetWet;
import com.polipo.fishing.BlockNetDry;
import com.polipo.fishing.BlockStaticNetWet;
import com.polipo.fishing.CraftingHandler;
import com.polipo.fishing.EntityNet;
import com.polipo.fishing.ItemFishmeal;
import com.polipo.fishing.ItemNet;
import com.polipo.fishing.ServerProxy;
import com.polipo.fishing.TileEntityNet;
import com.polipo.fishing.advancements.Triggers;
import java.lang.reflect.Method;
import java.util.Random;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.dispenser.BehaviorProjectileDispense;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Bootstrap;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="giacomos_fishing_net", name="Fishing Net Mod", version="1.6.1", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public class FishingNet {
    public static final String MODID = "giacomos_fishing_net";
    public static final String MODNAME = "Fishing Net Mod";
    public static final String VERSION = "1.6.1";
    @Mod.Instance
    public static FishingNet instance = new FishingNet();
    public static final Block netDry = new BlockNetDry();
    public static final Block netWetDynamic = new BlockDynamicNetWet();
    public static final Block netWetStatic = new BlockStaticNetWet();
    public static final ItemNet itemNet = new ItemNet();
    public static final Item itemFishmeal = new ItemFishmeal();
    @SidedProxy(clientSide="com.polipo.fishing.ClientProxy", serverSide="com.polipo.fishing.ServerProxy")
    public static ServerProxy proxy;
    public static SoundEvent snatchEvt;
    public static SoundEvent splashEvt;
    public static SoundEvent swishEvt;
    public static SoundEvent throwEvt;
    public static SoundEvent baitEvt;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        proxy.preInit(e);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new CraftingHandler());
    }

    public static SoundEvent registerSound(RegistryEvent.Register<SoundEvent> event, String soundName) {
        ResourceLocation soundID = new ResourceLocation(MODID, soundName);
        SoundEvent soundEvent = (SoundEvent)new SoundEvent(soundID).setRegistryName(soundID);
        event.getRegistry().register((IForgeRegistryEntry)soundEvent);
        return soundEvent;
    }

    @SubscribeEvent
    public void onRegisterSounds(RegistryEvent.Register<SoundEvent> event) {
        snatchEvt = FishingNet.registerSound(event, "snatch");
        splashEvt = FishingNet.registerSound(event, "splash");
        swishEvt = FishingNet.registerSound(event, "swish");
        throwEvt = FishingNet.registerSound(event, "throw");
        baitEvt = FishingNet.registerSound(event, "bait");
    }

    @SubscribeEvent
    public void onRegisterBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().register((IForgeRegistryEntry)netDry);
        event.getRegistry().register((IForgeRegistryEntry)netWetDynamic);
        event.getRegistry().register((IForgeRegistryEntry)netWetStatic);
        GameRegistry.registerTileEntity(TileEntityNet.class, (String)"tileEntityNetID");
    }

    @SubscribeEvent
    public void onRegisterItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)itemNet);
        event.getRegistry().register((IForgeRegistryEntry)itemFishmeal);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        try {
            Method method = ReflectionHelper.findMethod(CriteriaTriggers.class, (String)"register", (String)"func_192118_a", (Class[])new Class[]{ICriterionTrigger.class});
            method.setAccessible(true);
            for (int i = 0; i < Triggers.TRIGGER_ARRAY.length; ++i) {
                method.invoke(null, Triggers.TRIGGER_ARRAY[i]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        proxy.init(e);
        GameRegistry.addSmelting((ItemStack)new ItemStack(Items.field_151115_aP, 1, 2), (ItemStack)new ItemStack(itemFishmeal, 1), (float)0.375f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(Items.field_151115_aP, 1, 3), (ItemStack)new ItemStack(itemFishmeal, 1), (float)0.375f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(Items.field_179566_aV, 1, 0), (ItemStack)new ItemStack(itemFishmeal, 1), (float)0.375f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(Items.field_179566_aV, 1, 1), (ItemStack)new ItemStack(itemFishmeal, 1), (float)0.375f);
        ResourceLocation registryName = new ResourceLocation("giacomos_fishing_net:netDry");
        EntityRegistry.registerModEntity((ResourceLocation)registryName, EntityNet.class, (String)"EntityNet", (int)1, (Object)this, (int)64, (int)10, (boolean)true);
        IForgeRegistry reg = ForgeRegistries.VILLAGER_PROFESSIONS;
        VillagerRegistry.VillagerProfession brown = (VillagerRegistry.VillagerProfession)reg.getValue(new ResourceLocation("minecraft:farmer"));
        VillagerRegistry.VillagerCareer fisherman = brown.getCareer(1);
        fisherman.addTrade(3, new EntityVillager.ITradeList[]{new EmeraldForFish(0, new EntityVillager.PriceInfo(12, 15))});
        fisherman.addTrade(3, new EntityVillager.ITradeList[]{new EmeraldForFish(1, new EntityVillager.PriceInfo(5, 7))});
        fisherman.addTrade(4, new EntityVillager.ITradeList[]{new EmeraldForFish(3, new EntityVillager.PriceInfo(2, 3))});
        fisherman.addTrade(4, new EntityVillager.ITradeList[]{new EmeraldForFish(2, new EntityVillager.PriceInfo(1, 1))});
        BlockDispenser.field_149943_a.func_82595_a((Object)itemFishmeal, (Object)new Bootstrap.BehaviorDispenseOptional(){

            protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                BlockPos blockpos;
                this.field_190911_b = true;
                World world = source.func_82618_k();
                if (ItemFishmeal.applyBonemeal(stack, world, blockpos = source.func_180699_d().func_177972_a((EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a)))) {
                    if (!world.field_72995_K) {
                        world.func_175718_b(2005, blockpos, 0);
                    }
                } else {
                    this.field_190911_b = false;
                }
                return stack;
            }
        });
        BlockDispenser.field_149943_a.func_82595_a((Object)itemNet, (Object)new BehaviorProjectileDispense(){

            protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                return new EntityNet(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
            }
        });
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        proxy.postInit(e);
    }

    class EmeraldForFish
    implements EntityVillager.ITradeList {
        public EntityVillager.PriceInfo price;
        int meta;

        public EmeraldForFish(int meta, EntityVillager.PriceInfo price) {
            this.price = price;
            this.meta = meta;
        }

        public void func_190888_a(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
            int i = 1;
            if (this.price != null) {
                i = this.price.func_179412_a(random);
            }
            recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151115_aP, i, this.meta), Items.field_151166_bC));
        }
    }
}

