/*
 * Decompiled with CFR 0.152.
 */
package exterminatorjeff.undergroundbiomes.common.block;

import com.google.common.base.Predicate;
import exterminatorjeff.undergroundbiomes.api.API;
import exterminatorjeff.undergroundbiomes.api.enums.MetamorphicVariant;
import exterminatorjeff.undergroundbiomes.api.enums.UBStoneStyle;
import exterminatorjeff.undergroundbiomes.api.enums.UBStoneType;
import exterminatorjeff.undergroundbiomes.common.block.UBStone;
import exterminatorjeff.undergroundbiomes.intermod.DropsRegistry;
import exterminatorjeff.undergroundbiomes.intermod.OresRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MetamorphicMonsterStone
extends UBStone {
    public static final String internal_name = "metamorphic_monster_stone";

    @Override
    public String getInternalName() {
        return internal_name;
    }

    public MetamorphicMonsterStone() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(MetamorphicVariant.METAMORPHIC_VARIANT_PROPERTY, (Comparable)MetamorphicVariant.GNEISS));
    }

    @Override
    public UBStoneType getStoneType() {
        return UBStoneType.METAMORPHIC;
    }

    @Override
    public UBStoneStyle getStoneStyle() {
        return UBStoneStyle.MONSTER_STONE;
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MetamorphicVariant.METAMORPHIC_VARIANT_PROPERTY});
    }

    @Override
    public int getNbVariants() {
        return MetamorphicVariant.NB_VARIANTS;
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!worldIn.field_72995_K && worldIn.func_82736_K().func_82766_b("doTileDrops")) {
            EntitySilverfish entitysilverfish = new EntitySilverfish(worldIn);
            entitysilverfish.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
            worldIn.func_72838_d((Entity)entitysilverfish);
            entitysilverfish.func_70656_aK();
        }
    }

    @Override
    public String getVariantName(int meta) {
        return MetamorphicVariant.METAMORPHIC_VARIANTS[meta & 7].toString();
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(MetamorphicVariant.METAMORPHIC_VARIANT_PROPERTY, (Comparable)MetamorphicVariant.METAMORPHIC_VARIANTS[meta & 7]);
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((MetamorphicVariant)state.func_177229_b(MetamorphicVariant.METAMORPHIC_VARIANT_PROPERTY)).getMetadata();
    }

    @Override
    public boolean isFortuneAffected(IBlockState state) {
        return false;
    }

    @Override
    public float func_176195_g(IBlockState state, World worldIn, BlockPos pos) {
        return this.getBaseHardness() * ((MetamorphicVariant)state.func_177229_b(MetamorphicVariant.METAMORPHIC_VARIANT_PROPERTY)).getHardness();
    }

    @Override
    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        return this.getBaseResistance() * ((MetamorphicVariant)world.func_180495_p(pos).func_177229_b(MetamorphicVariant.METAMORPHIC_VARIANT_PROPERTY)).getResistance();
    }

    @Override
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ItemBlock cobbleBlock = API.METAMORPHIC_COBBLE.getItemBlock();
        int meta = state.func_177230_c().func_176201_c(state);
        ItemStack itemStack = new ItemStack((Item)cobbleBlock, 1, meta);
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        result.add(itemStack);
        DropsRegistry.INSTANCE.addDrops(result, this, world, pos, state, fortune);
        return result;
    }

    @Override
    public void getDrops(NonNullList<ItemStack> stacks, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ItemBlock cobbleBlock = API.METAMORPHIC_COBBLE.getItemBlock();
        int meta = state.func_177230_c().func_176201_c(state);
        ItemStack itemStack = new ItemStack((Item)cobbleBlock, 1, meta);
        stacks.add((Object)itemStack);
        DropsRegistry.INSTANCE.addDrops((List<ItemStack>)stacks, this, world, pos, state, fortune);
    }

    @Override
    public boolean isReplaceableOreGen(IBlockState state, IBlockAccess world, BlockPos pos, Predicate<IBlockState> target) {
        OresRegistry.INSTANCE.setRecheck(world, pos);
        return super.isReplaceableOreGen(state, world, pos, target);
    }

    @Override
    public UBStone baseStone() {
        return this;
    }
}

